.TH CARRTIME 3L
.SH NAME
carrtime - compute Carrington time
.SH SYNOPSIS
.nf
TIME carrtime(Ctime,Crot,Clong)
 TIME *Ctime;
 int  *Crot, *Clong;
.fi
.SH DESCRIPTION

The return value of this function is always the appropriate Carrington
time.  In every case date() is called with the corresponding value of
the standard time.

Calculations are completed with the following priority:

If Ctime == NULL (0) the remaining quantities will be computed from
the DATE structure value for currtime._time.

If *Ctime != 0.0 the remaining quantities will be computed from it.

If *Crot and *Clong != 0 then the unknowns will be calculated from them.

If *Ctime, *Crot, and *Clong = 0 then they will be computed from the
DATE structure curtime.

.SH FILES
.nf
/usr/local/lib/libdate.a
/usr/src/local/date/carrtime.c
/usr/man/manl/carrtime.l
.fi
.SH SEE ALSO
date(3)
.SH DIAGNOSTICS
none
.SH BUGS
Since the Earth's orbit is an ellipse, carrington time is not really a
linear function of standard time.  This is ignored here.  See solephem
for a more accurate computation from StdT -> CT.
