.TH getnames 3l
.SH NAME
getnames -- get a list of names from the command line
.SH SYNOPSIS
.nf
#include <stdio.h>
#include "param.h"

int getnames(kind,names)
char *kind;
char **names[];
.fi
.SH DESCRIPTION

getnames - routine to get a list of file names for dataset, or other
use.  Call with a pointer to a table of strings and a prototype string,
such as "in" which defines the list.  getnames will try first (in the
case of "in" e.g.):

	inlist=<file containing list of files>
		- then -
	in=<file to use>
		- then -
	<non-parameter list of file names>
		- then -
	"<"  (i.e. stdin)

getnames will return the number of names found.  NOTE that at least 1
name will always be "found" so you must check for the "<" if you don't
want it.

A simple example follows:

	DATASET *dsin;
	char *fn, **namelist;
	
	for (getnames(&namelist); (fn = *namelist++) != NULL; )
		{
		dsin = dsopen(fn,"R");
		.
		.
		.
		dsclose(dsin);
		}

.SH FILES
.nf
/usr/src/local/date/getnames.c
.fi
.SH SEE ALSO
parameter(3l)
.SH DIAGNOSTICS
.SH BUGS
