/* getjob trnum ufile
 * move the output of a run from the rje output file to a user file
 * and change the ownership if the output file is currently "unclaimed".
 * Do this via links if on same device, otherwise via copy.
 *
 * by David E. Miran
 * 8/26/81
 */

#include	<stdio.h>
#include	"../ntr/rjedef.h"
#include	"../ntr/rjefiles.h"
#define		EXDEV	18	/* error code for cross device link attempt */

int	uid, gid, setid, rjeown;
int	fxuid;
int	nrd, nwrt, ofid, infid;
char	buf[1024];
long int curtime, diff;
char	upjob[7];
struct	{		/* returned from a stat system call */
	char	fill1[4];
	int	flags;
	char	fill2;
	char	fuid;
	char	fgid;
	char	size0;
	int	sizew;
	char	fill3[20];
	long int modtime;
	}	sbuf;

char	*uoutfile;

main(argc, argv)
int argc;
char **argv;
{
extern int errno;
register int i, j;
register char c;

	uid = getuid()&0377;
	gid = getgid()&0377;
	setid = uid|(gid<<8);
	rjeown = SITUID | (SITGID<<8);
	if (argc < 2) {
		printf("usage: getjob transmittal-number [user-file]\n");
		exit(1);
	}
	for (i=0; i<6; i++) {
		c = argv[1][i];
		if (c == 0) goto null;
		if ((c>= 'a') && (c<='z')) c =& 0337;  /* fold to upper case */
		upjob[i] = jobctrl[i+10] = jobout[i+9] = c;
	}
	if (argv[1][6] != '\0') goto null;
	goto gotf;
null:
	printf("getjob: invalid transmittal number %s\n", argv[1]);
	exit(1);
gotf:
	if (stat(jobout, &sbuf) < 0) {
	/* no such run - quit */
		printf("getjob: no such job as %s exists\n", argv[1]);
			exit(1);
	}

	fxuid = sbuf.fuid & 0377;
	if (fxuid == uid) goto owned;
	if (fxuid == SITUID) {
		chown(jobout, setid);
		goto owned;
	}
	printf("job %s is not yours\n", upjob);
	exit(1);
owned:
	if (argc > 2)
		uoutfile = argv[2];
	else
		uoutfile = argv[1];
	if (saccess(uoutfile, 2)) goto trylink;
	printf("getjob: write access forbidden on file %s\n", uoutfile);
	exit(1);
trylink:
	if (link(jobout, uoutfile) < 0) {
		if (errno != EXDEV) {
			printf("getjob: cannot link to %s\n", uoutfile);
			exit(1);
		}  else  {   /* cross device - do a copy  */
			if (stat(jobctrl, &sbuf) < 0) goto trysiz;
			if ((sbuf.flags & 070) != 070) goto not_don2;
trysiz:
			stat(jobout, &sbuf);
			if (sbuf.sizew == 0) goto not_don2;
			if ((ofid = creat(uoutfile, 0600)) < 0) goto nocopy;
			if ((infid = open(jobout, 0)) < 0) goto nocopy;
			while ((nrd = read(infid, buf, 1024)) > 0) {
				nwrt = write(ofid, buf, nrd);
				if (nwrt != nrd) goto nocopy;
			}
			if (nrd < 0) goto nocopy; /* error rather than eof */
			close(infid);	close(ofid);
			chown(uoutfile, setid);
			unlink(jobout);
			unlink(jobctrl);
			exit(0);
		}
	}
	if (stat(jobctrl, &sbuf) < 0) goto trysize;
	if ((sbuf.flags & 070) != 070) goto not_done;
trysize:
	stat(jobout, &sbuf);
	if (sbuf.sizew == 0) goto not_done;
	unlink(jobout);
	unlink(jobctrl);
	exit(0);
not_done:
	printf("getjob:  job %s is not complete.  Job not moved\n",upjob);
	unlink(uoutfile);
	exit(1);
not_don2:
	printf("getjob: job %s is not complete - copy not done\n", upjob);
	exit(1);
nocopy:
	printf("getjob: cannot copy to %s\n", uoutfile);
	unlink(uoutfile);
	exit(1);
}
