/*
 *	fastin px ex sn a
 *	read high speed input from a tty line in block raw mode
 *   ****** relies on a hygiene lab kernel mod (tty.c) for block raw input
 *	px - x is the port from which to read (/dev/ttyx)
 *	ex - x is the end of block character
 *	sn - n is the line speed (300, 1200, 2400, 4800, 9600)
	a  - all option - do not strip out control characters
 *	r - report input statistics (testing option)
		default is to strip out all control chars but newline
 *	default line is /dev/ttyd and default speed is 2400 baud
 *	default block char is newline (line feed).
 *	recognize eof by a control s on user terminal.
 *	must be setuid root for priority.
 *	prints one 'r' every 1000 characters as a sign of progress
 *	output is to standard output, so redirect to a file ('r' is on file 2)
 *	by David E. Miran     10/19/81
 */

#include	<stdio.h>
#define	NOTNICE	-100
#define	IMODE	0100340		/* input mode - BLOCK, RAW, ANYP  */
#define	RAW	040
#define	CR	015
#define NEWLN	012
#define	CTRLS	023

char *mesg[] {
	"START INPUT DEVICE\n",
	"END OF INPUT\n",
	};
char dev[] "/dev/ttyd";
char bchar '\n';
int bsize 80;
int sspeed {11<<8|11};	/* default speed 2400 */
int aopt 0; /* default a option off */
int ropt 0; /* default r (report input statistics) option off */
char lch;
int	nlost	0;
int	dseen	0;	/* set after non-null data seen */
int	nullsn	0;	/* set after null seen */
long	lostloc[100];	/* save first 100 locations of data loss */
long	ocnt	0L;

int x50, x100, x150, x200, x250, x300, x350, x400;
int maxchr, avgchr,rdcnti;
int minchr 1000;
long chcnt, rdcnt;

struct spd
	{  int baud, speed;  }     speeds[]
	{
		300,  (7<<8|7),
		1200, (9<<8|9),
		2400, (11<<8|11),
		4800, (12<<8|12),
		9600, (13<<8|13),
		0
	};
int ptfile;


main(argc, argv)
char **argv;
{
int ccnt, pid, ttyset[3], nchr, i, savmod;
int s, x;
struct spd *sp;
char rec[500], mark, c;
extern int done();

mark = 'r';
/* set up for options */
while (--argc) switch (**++argv){
	case 'p':
			dev[8] = (*argv)[1];  break;

	case 's':
			s = atoi(*argv+1);
			for (sp = speeds; x=sp->baud; sp++)
				if (x == s) {sspeed=sp->speed; break;}
			if (x) break;
			fprintf(stderr,"unknown speed %d\n",s);
			exit(1);
	case 'e':
			bchar = (*argv)[1]; break;

	case 'a':
			aopt = 1;  break;

	case 'r':
			ropt = 1;  break;

	default:
			fprintf(stderr,"unknown option: %c\n",**argv);
			exit(1);
	}
pid = fork();
if (pid > 0) goto parent; /* handle user terminal */
if (pid < 0) {		/* error */
	fprintf(stderr,"cannot create input process\n");
	exit(1);
	}
/*  this is the child process, set up for input and process until
    signaled by parent that all is done */

if ((ptfile = open(dev, 0)) < 0) {
	fprintf(stderr,"cannot open paper tape input device\n");
	exit(1);
	}
gtty(ptfile,&ttyset[0]);
ttyset[0] = sspeed;
ttyset[1] = bchar<<8|bsize;  /* block raw mode size and char */
ttyset[2] = IMODE;
stty(ptfile, &ttyset[0]);
signal(2, &done);
nice(NOTNICE);
write(2,mesg[0],19);
ccnt = 0;

rdlp:		/* read loop  */
	nchr = read(ptfile, &rec[0], 500);
	if (nchr < 0) {
		fprintf(stderr,"read error\n");
		exit(1);
		}
	if (nchr < 1) goto rdlp;
	ccnt += nchr;
	chcnt += nchr;
	if (ropt == 1) {
		rdcnt++;
		if (nchr > maxchr) maxchr = nchr;
		if (nchr < minchr) minchr = nchr;
		if (nchr < 50) {x50++; goto doit;}
		if (nchr < 100) {x100++; goto doit;}
		if (nchr < 150) {x150++; goto doit;}
		if (nchr < 200) {x200++; goto doit;}
		if (nchr < 250) {x250++; goto doit;}
		if (nchr < 300) {x300++; goto doit;}
		if (nchr < 350) {x350++; goto doit;}
		x400++;
		}
doit:
	for (i = 0; i < nchr; i++) {
		c = rec[i];
		if (c == 0) {
			if (dseen && (ocnt > 0L)) nullsn++;
		}  else  {
			dseen = 1;
			if (nullsn) {  /* we have seen a null in mid data */
				if (nlost < 100) lostloc[nlost] = ocnt;
				nlost++;
				nullsn = 0;
			}
		}
		c =& 0177;
		lch = c;
		if (aopt) {  putchar(c);  continue;  ocnt++; }
		if ((c < 040) & (c != NEWLN)) continue;
		putchar(c);
		ocnt++;
		}
	if (ccnt > 1000) {  /* progress marker on terminal */
		write(2, &mark, 1);
		ccnt = 0;
		}
	goto rdlp;

/* parent process waits for control s and then signals child to quit */

parent:
	gtty(0, &ttyset[0]);
	savmod = ttyset[2];
	ttyset[2] =| RAW;
	stty(0, &ttyset[0]);

wtlp:  /* wait for a control s */
	read(0, &c, 1);
	if (c != CTRLS) goto wtlp;
	kill(pid, 2);
	wait();
	ttyset[2] = savmod;
	stty(0, &ttyset[0]);
	write(2,mesg[1], 13);
	exit(0);
}
done()
{
register int i;
	close(ptfile);
	if (lch != NEWLN) putchar(NEWLN);
	if (nlost) {
		fprintf(stderr,"\n** some input data lost at the following character locations:\n");
		if (nlost>100) nlost = 100;
		for (i=0; i<nlost; i++)
			fprintf(stderr,"%D\n",lostloc[i]);
	}
	fprintf(stderr,"\n%D characters read\n",ocnt);
	if (ropt == 1) {
		avgchr = chcnt/rdcnt;
		rdcnti=rdcnt;
		fprintf(stderr,"input statistics: # reads = %d\n",rdcnti);
		fprintf(stderr,"average read = %d  max read= %d\n",avgchr, maxchr);
		fprintf(stderr,"minimum read = %d\n",minchr);
		if (x50) fprintf(stderr,"# reads < 50 chars = %d\n",x50);
		if (x100) fprintf(stderr,"# reads < 100 chars = %d\n",x100);
		if (x150) fprintf(stderr,"# reads < 150 chars = %d\n",x150);
		if (x200) fprintf(stderr,"# reads < 200 chars = %d\n",x200);
		if (x250) fprintf(stderr,"# reads < 250 chars = %d\n",x250);
		if (x300) fprintf(stderr,"# reads < 300 chars = %d\n",x300);
		if (x350) fprintf(stderr,"# reads < 350 chars = %d\n",x350);
		if (x400) fprintf(stderr,"# reads 350 - 400 chars = %d\n",x400);
		}
	exit(0);
}
