/*
 * fmtran fieldfile codefile [datafile] ....
 * For selected fields in data records (specified in fieldfile)
 * look for specified codes and augment with additional data fields
 * (codes and augmentation in codefile).
 * If no datafiles are specified reads standard input.  Writes standard output.
 * By David E. Miran
 * Version of 2/21/83
 */

#include	<stdio.h>
#include	<myio.h>
#define		MAXCODE	1000
#define		MAXCHR	20000
#define		MAXREC	4000
#define		MAXFLD	200

char	irec[MAXREC];	/* the data record buffer */
char	fl[80];		/* a single field buffer */
char	cspace[MAXCHR];	/* storage for field augmentation strings */
int	strt[MAXCODE], len[MAXCODE];	/* augmentation start and length */
int	maxs	0;	/* highest cspace used */
int	ccnt	0;	/* line output position counter */
int	flds[MAXFLD];	/* set if the field is to be checked */
struct	fbuf	ibuf, obuf;	/* i/o buffers (myio) */
int	rpnt, rlen, flen, fnum;  /* record and field info */
char	*unk	"**UNKNOWN**'UNK'";	/* unknown code augmentation */

main(argc, argv)
int argc;
char **argv;
{
register int i, j;
register char c;
int fid;

	for (i=0; i<MAXFLD; i++) flds[i]=0;
	for (i=0; i<MAXCODE; i++) strt[i] = len[i] = 0;
/* read the field file - list of fields to process */
	if ((fid = open(argv[1], 0)) < 0) {
		fprintf(stderr,"fmtran: cannot open %s\n",argv[1]);
		exit(1);
	}
	mfinit(&ibuf,fid);
	while (mgetlin(irec, &ibuf)) {
		i = atoi(irec);
		flds[i] = 1;
	}
	close(fid);
	ccnt = 0;
	strcpy(cspace, unk);
	len[0] = strlen(unk);
	maxs = len[0]+1;
/* read the codefile - codes and insertion text */
	if ((fid = open(argv[2], 0)) < 0) {
		fprintf(stderr,"fmtran: cannot open %s\n",argv[2]);
		exit(1);
	}
	mfinit(&ibuf,fid);
	while (mgetlin(irec, &ibuf)) {
		i = atoi(irec);
		if (i >= MAXCODE) {
			fprintf(stderr,"fmtran: illegal augmentation code=%s\n",irec);
			exit(1);
		}
		j=0;
		while((c = irec[j++]) != '\'');	/* skip past leading code */
		strt[i] = maxs;
		strcpy(&cspace[maxs], &irec[j]);
		j = strlen(&irec[j]);
		len[i] = j;
		maxs += j+1;
	}
	close(fid);
/* now begin actual processing */
	mfinit(&obuf,1);
	argc -= 3;
	argv += 3;
	fid = 0;
flp:	/* loop back here for each file */
	if (argc <= 0) goto init;
	if ((fid = open(*argv, 0)) < 0) {
		fprintf(stderr,"fmtran: cannot open %s\n",argv[0]);
		exit(1);
	}
init:
	mfinit(&ibuf,fid);
	while(getr()) {	/* get next record to process */
		while(getf()) {	/* get next field */
			tput(fl,flen);	/* the field itself */
			if (flds[fnum])	{  /* this field needs checking */
				if (flen == 1) { /* field only has a field mark character */
					tput("''",2);
				} else {
					i = atoi(fl);
					if ( i >= MAXCODE) i=0;
					if (len[i] == 0) i=0;  /* UNKNOWN */
					tput(&cspace[strt[i]],len[i]);
				}
			}
		}
		rput();	/* end of record */
	}
	close(fid);
	argc--;
	if (argc <= 0) goto done;
	argv++;
	goto flp;
done:
	mflush(&obuf);
	exit(0);
}

/* getr - get next record and set up for processing */

getr()
{
register int i;
register char c;

	rpnt = i = 0;
glp:
	c = mget(&ibuf);
	if (ibuf.nrd < 1) return(0);
	if (c == '\n') goto glp;
	irec[i++] = c;
	if (c != '!') goto glp;
	irec[i] = '\0';
	rlen = i;
	fnum = -1;
	return(1);
}

/* getf - get the next field into the field buffer */

getf()
{
register int i;
register char c;
	fnum++;
	i = 0;
glp:
	c = irec[rpnt++];
	if (c == '\'') {
		fl[i++] = c;
		fl[i] = '\0';
		flen = i;
		return(1);
	}
	if (c == '!') {
		if (i == 0) return(0);
		rpnt--;
		fl[i++] = '\'';
		fl[i] = '\0';
		flen = i;
		return(1);
	}
	fl[i++] = c;
	goto glp;
}

/* tput - write records out with column 80 breaks */

tput(str, l)
char *str;
register int l;
{
register char c;
register int i;

	i = 0;
	while (l--) {
		c = str[i++];
		if (ccnt >=80) {
			mput('\n',&obuf);
			ccnt = 0;
		}
		mput(c, &obuf);
		ccnt++;
	}
}

rput()
{
	mput('!', &obuf);
	mput('\n', &obuf);
	ccnt = 0;
}
