/*
 * submit file
 * submit a file of commands to be processed in a batch mode during off hours
 * jobs are entered in file /usr/lib/subtab in the form
 * uid:gid:dir:file
 * where dir is the working directory when submit is called
 * and file is the file of commands to be processed by sh.
 * by David E. Miran
 * 12/1/81
 */

#include	<stdio.h>

int uid, gid, fid;
char	lbuf[200];
char	wdbuf[500];
extern char *getwd();
int wd;

char	*subfile	"/usr/lib/subtab";
char	*lockfile	"/usr/lib/sub_lockfile";

main(argc, argv)
int argc;
char **argv;
{
register int i, j;
	if (argc != 2) {
		fprintf(stderr,"Usage: submit file\n");
		exit(1);
	}
	if (!saccess(argv[1], 4)) {
		fprintf(stderr,"submit: access forbidden to file %s\n",argv[1]);
		exit(1);
	}
	uid = getuid()&0377;
	gid = getgid()&0377;
	wd = getwd(wdbuf);
	wdbuf[wd] = '\0';
	sprintf(lbuf,"%d:%d:%s:%s\n\0",uid,gid,wdbuf,argv[1]);
	i = strlen(lbuf);
	j = 0;
	while (!flock(lockfile)) {
		if (j++ > 20) {
			fprintf(stderr,"submit: file %s locked - cannot register job\n",subfile);
			exit(1);
		}
		sleep(1);
	}
	fid = open(subfile,2);
	seek(fid,0,2);
	write(fid,lbuf,i);
	close(fid);
	funlock(lockfile);
	fprintf(stderr,"submit: job %s registered\n",argv[1]);
	exit(0);
}
