/*
 * zdel [-v] [dir]
 * will remove all files in the specified directory of length zero
 * the -v option will cause all files removed to be listed.
 * If no directory is given the current directory is used.
 * Files whose names begin with '.' are NOT removed ever.
 *
 * by David E. Miran
 * 12/3/81
 */

#include	<stdio.h>
#include	<myio.h>

#define	SPMODE	060000

struct fbuf ibuf;
int fid;
struct {
	int dino;
	char dname[14];
	} dirent;	/* directory entry */

struct {
	char	f1[4];
	int	flags;
	char	f2[3];
	char	s0;
	unsigned s1;
	char	f3[24];
	} stb;		/* stat system call buffer */

char	*dirname;
char	*dot	".";
int	vflag	0;	/* verbose option */

main(argc, argv)
int argc;
char **argv;
{
register int i;
	if (argc < 2) {
no_f:
		dirname = dot;
		goto dodel;
	}
	argc--;
	argv++;
	if (strcmp(*argv, "-v") == 0) {
		vflag++;
		argv++;
		argc--;
	}
	if (argc < 1) goto no_f;
	dirname = *argv;
	i = chdir(dirname);
	if (i < 0) {
		printf("Zdel: Cannot access directory %s\n",dirname);
		exit(1);
	}
dodel:
	if (vflag) printf("Zdel: cleaning directory %s\n",dirname);
	fid = open(dot, 0);
	if (fid < 0) {
		printf("Zdel: Cannot read directory %s\n",dirname);
		exit(1);
	}
	mfinit(&ibuf, fid);
	while (mgetrec(&dirent, sizeof dirent, &ibuf)) {
		if (dirent.dino == 0) continue;
		if (dirent.dname[0] == '.') continue;
		i = stat(dirent.dname, &stb);
		if (i < 0) {
			printf("Zdel:  Cannot stat %s/%s\n",dirname,dirent.dname);
			continue;
		}
		if ((stb.flags & SPMODE) != 0) continue; /* dir or special file */
		if (stb.s1 != 0) continue;	/* not empty */
		if (stb.s0 != '\0') continue;
		i = unlink(dirent.dname);
		if (i < 0) {
			printf("Zdel:  Cannot unlink %s/%s\n",dirname,dirent.dname);
			continue;
		}
		if (vflag) printf("%s/%s\n",dirname,dirent.dname);
	}
	close(fid);
	exit(0);
}
