/*
 * tout ?
 * will read its standard input and write it on /dev/tty?
 * tty? must be locked (via rq) and must have a speed file entry
 * (/sptmp/ctrl/?spd) for tout to run.
 * No one may be logged in on /dev/tty? for tout to run.
 * By David E. Miran
 * version of 1/3/83
 */

#include "tpdinf.h"
#include	<stdio.h>

int	statb[18];

char	outb[512];
int	lp;
char	tdev[]	"/dev/tty?";	/* % is code for /dev/lp, rest are /dev/tty? */
char	term;

#define	ROOT	0
struct	statp	{	/* pointer to a stat/fstat buffer */
	char	fila[4];
	int	modes;
	char	nlinks;
	char	xuid;
	char	filb[28];
	};
struct	statp *st;
char	spdbuf[100];	/* buffer for processing terminal characteristics */
#define	TMODE	0322	/* standard stty modes for terminal even,odd,xtab,nl */
int	tty[3], otty[3];		/* stty buffer */

main(argc,argv)
int	argc;
char **argv;
{
register int i;
int fid, j;
int uuid;

	/*
	 * close all files. try to open device for writing. if can't, exit.
	 */
	uuid = getuid()&0377;

	term = '%';
	if (argc > 1) {	/* better be a terminal specification */
		term = argv[1][0];
		tdev[8] = term;
		tpdlock[12] = term;
		tpdspd[12] = term;
	} else {
		fprintf(stderr,"tout: no output device specified\n");
		exit(1);
	}
	for(i = 3; i < 16; i++)
		close(i);
	i = stat(tpdlock,statb);
	if (i < 0) {	/* not locked - quit */
nolock:
		fprintf(stderr,"tout: %s not locked - use rq to lock before printing\n",tdev);
		exit(1);
	}
	st = statb;
	if (st->modes&0777 != 0) goto nolock;
	i = st->xuid&0377;
	if (i != uuid) {
		fprintf(stderr,"tout: %s is locked by someone else\n",tdev);
		exit(1);
	}
	i = stat(tdev,statb);
	if (i < 0) {	/* no such device */
		fprintf(stderr,"tout: There is no such device as %s\n",tdev);
		exit(1);
	}
	st = statb;
	if (st->xuid != ROOT) { /* someone is logged in */
		fprintf(stderr,"tout: Someone is logged in on %s\n",tdev);
		exit(1);
	}
	fid = open(tpdspd,0);	/* check terminal speed */
	if (fid < 0) {	/* no speed file */
		fprintf(stderr,"tout: There is no speed file (%s) for %s - consult DP for assistance\n",tpdspd,tdev);
		exit(1);
	}
	read(fid, spdbuf,100);
	i = atoi(spdbuf);	/* speeds are coded according to stty speed codes */
	close(fid);
	j = TMODE;
	if (i < 0) {  /* set up delays for cr and form feed */
		j |= 050000;  /* cr1 and vt1 */
		i = -i;
	}
	tty[0] = (i<<8) | i;
	tty[1] = 0;
	tty[2] = j;
	lp = open(tdev,1);
	gtty(lp,otty);
	stty(lp,tty);
dolp:	/* read/write loop */
	i = read(0, outb, 512);
	if (i < 1) goto done;
	write(lp,outb,i);
	goto dolp;
done:
	stty(lp,otty);
	close(lp);
	exit(0);
}
