/*
 *	v.misc - various support routines for vir
 *	3/11/83
 */
#include	<stdio.h>
#include	"vmyio.h"
#include	"vir.h"

extern int	hfid, pfid, p1fid, p2fid, nfid, n1fid, n2fid, sfid, s1fid, s2fid, dfid, fmtfid;

extern char mget();
extern long tell(), atol(), lseek();

extern struct	dexhead	hrec;		/* HFILE (header file) */
extern struct	fil_ent	filent[MAXFILE]; /* data file information - HFILE-3 */
extern char	fileok[MAXFILE];	/* set to 'w' or 'r' after auth checked */
extern struct	fmt_def fmtdef[MAXFMT];
extern struct	fmt_inf	fmtinf[MAXFMT];	/* format information (internal) */
extern struct	fdef	fld[MAXFLD];	/* the format field descriptors */
extern struct	pat_ent	prec;		/* one record from PFILE */
extern struct	num_ent	snrec;		/* one record from NFILE */
extern struct	sp_ent	srec;		/* one record from SFILE */

extern char	tbuf[MAXRSIZE], ibuf[MAXRSIZE];	/* terminal and internal buffers */

/* WORKING SET - current set of records */
extern char	afld[250];	/* source for auto copy fields */
extern int	apnt[10],asize[10];	/* autocopy fields start and size */
extern int	amax;			/* auto copy total size */
extern struct	pat_ent	cur;	/* current patient name and number */
extern int	cur_rcnt;		/* count of records in current set */
extern long	cp_off;			/* patient index offset of current patient */

extern struct {
	struct	num_ent crec_n;
	int	nfmt_num;	/* format associated with this record */
	long	nws_loc;	/* loc of index entry for this record */
	}  crec[MAXREC];	/* pointers to records in working set */


/* RECORD - information on current record being processed */
extern int	cur_type;	/* type of record */
extern int	ltype;	/* cur_type - 1 */
extern unsigned cur_fnum;	/* file number */
extern long	cur_strt;	/* offset to record start */
extern int	cur_size;	/* current record size (compressed in file) */
extern int	recsize;	/* current expanded record size */
extern int	new_size;	/* new record (compressed) size */
extern long	cur_n;			/* position of descriptor entry in nfile for current record */

/* LOOKUP - control variables and tables (?2 files) */
extern int	plookp, nlookp, slookp;  /* set if currently searching p, n, or s file */
extern long ploc, nloc, sloc;  /* current offsets into index files */
extern long newnloc;

/* STATE - general system and state definitions */
extern int	fmtstate;		/* fmt off (0) or on (1) */
extern int	fdexmod;		/* set if any changes made */
extern int	icnt;		/* size of command line (= recsize) */
extern int	repmode;		/* set if replicate command is in progress */
extern int	filspot;		/* current data file pointer in filent table */
extern int	nfmt;		/* format to load */

extern int	ttyorig[3],ttybraw[3],ttyraw[3],ttynorm[3];
extern int	hispd;	/* set if line is 9600 baud */

extern char	bell[];

/* EXTERNAL - various externally defined items */

extern char *cls, *fmto, *ccls;
extern int cls_l, fmto_l, cclsl;
extern int dlymode;
extern int termtype;

/* options */
extern int	popt;	/* printing mode output */
extern int	fopt;
extern int	mopt;	/* merge mode output */

/* MISC - miscellaneous variables */

extern char	*progname;
extern char	rbuf[80];	/* spare line buffer */
extern char	dfile[50];	/* current in use file name */
extern int fcnt, nspecn, specnpos[30], fnn, fsn, fn, fs;
extern long newloc, spn;
extern int	tflag;		/* set after terminal type checked */
extern int sploc, spsize;
extern long errloc;
extern long errpnum;
extern long	errspec;
extern long ML;
extern int scrst;

/***********  vload windowing for concept terminals *************/
char	*wind[]	{	/* pointers to window selection commands */
		"\033U\033v  8p\033V \033u\033;\033?",
		"\033U\033v8 8p\033V8\033u\033;\033?\t",
		"\033U\033vP 8p\033VP\033u\033;\033?\t",
		"\033U\033vh 8p\033Vh\033u\033;\033?\t",
		"\033U\033v\001  8p\033V\001 \033u\033;\033?\t",
		"\033U\033v\0018 8p\033V\0018\033u\033;\033?\t",
		"\033U\033v\001P 8p\033V\001P\033u\033;\033?\t",
		"\033U\033v\001h 8p\033V\001h\033u\033;\033?\t",
		0 };
int	windlen[]	{ 17,18,18,18,20,20,20,20};

/*******************************  addfile  **********************************/
/* add a new file to the file table (must not be present already) */

addfile(fname,fmnum)
char *fname;
int fmnum;
{
register int i, j;
	hrec.numfile++;
	if (hrec.numfile > MAXFILE) quitsig(28);
	hrec.maxfile++;
	if (hrec.maxfile > 65530) hrec.maxfile = 1;
	j = hrec.numfile-1;
	filent[j].f_num = hrec.maxfile;
	filent[j].fmt_cd = fmnum;
	filent[j].f_mode = NOTCUR;
	strcpy(filent[j].f_name, fname);
	return(j);
}
/*******************************  badsig  ***********************************/

/* badsig - catch signals for bad events, terminate gracefully
   and try to print useful diagnostics */
badsig()
{
	quitsig(29);
}

/*******************************  clr  **************************************/

clr()
{
	if ((fmtstate == 0) && (termtype == 4))
		write(1,ccls,cclsl);
	else
		write(1,cls,cls_l);
	if (termtype != 4) sleep(1);
	scrst = 1;
}

/*******************************  fileck  ***********************************/

fileck(fil,mod)
int fil,mod;
{
/* check that access is allowed to a file. mod=2 for write, 4 for read. */

	if (fileok[fil] == 'w') return;
	if (fileok[fil] == 'r')
		if (mod == 4) return;
chk:
	if (saccess(filent[fil].f_name,2)) {
		fileok[fil] = 'w';
		return;
	}
	if (saccess(filent[fil].f_name,4)) {
		fileok[fil] = 'r';
		if (mod == 4) return;
	}
die:
	strcpy(dfile,filent[fil].f_name);
	quitsig(27);
}
/*******************************  fmtoff  ***********************************/

fmtoff()
{
	if (termtype == 4)
		write(1,wind[7],windlen[7]);
	else  {
		if (!fmtstate) goto stt;
		write(1, fmto, fmto_l);
	}
	fmtstate = ltype = cur_type = 0;
stt:
	clr();
}
/*******************************  gen_frec  ********************************/
/*  take a record from the terminal and compress to internal format */

gen_frec()
{
register int i, ns;
register char ch;
int spcnt, ccnt, fst, fp, fe, fs;

	fst = fmtinf[ltype].st_fld;
	fe = fmtinf[ltype].end_fld;
	fp = fst;
	spcnt = ccnt = i = ns = 0;
lp:
	fs = fld[fp++].f_size;
clp:
	if (i == recsize) goto backlp;	/* done - clean up */
	ch = tbuf[i++];
	fs--;
	if (ch == ' ') {
		spcnt++;
		goto nextc;
	}
	while (spcnt > 0) {
		ibuf[ns++] = ' ';
		ccnt++;
		spcnt--;
		if ((!hrec.modata) && (ccnt == 80)) {
			ibuf[ns++] = '\n';
			ccnt = 0;
		}
	}
	ibuf[ns++] = ch;
	ccnt++;
	if ((!hrec.modata) && (ccnt == 80)) {
		ibuf[ns++] = '\n';
		ccnt = 0;
	}
nextc:
	if (fs) goto clp;
	spcnt = 0;
	ibuf[ns++] = hrec.fldsep;
	ccnt++;
	if ((!hrec.modata) && (ccnt == 80)) {
		ibuf[ns++] = '\n';
		ccnt = 0;
	}
	if (fp <= fe) goto lp;
backlp:
	i = ns - 1;
	if ((ibuf[i] == hrec.fldsep) || (ibuf[i] == '\n')) {
		ns--;
		if (ns) goto backlp;
	}
	ibuf[ns++] = hrec.recsep;
	if (!hrec.modata) ibuf[ns++] = '\n';
	new_size = ns;
	return;
}

/*******************************  getfrec  **********************************/
/* get a record from a specified file and offset.
   terminate program in error if record too large or contains del codes */

getfrec(filen, record, loc)
unsigned filen;
long loc;
char *record;
{
struct fbuf rb;
int ifid;
register char c;
register int i;
/* return codes  n>0 is record size.  n = 0 means eof.  n = -2 means file error */
	i = 0;
	new_size = 0;
	errloc = loc;
	if ((filspot = lookupn(filen)) < 0)
		quitsig(35);
	if ((ifid = open(filent[filspot].f_name, 0)) < 0)
		quitsig(35);
	lseek(ifid, loc, 0);
	mfinit(&rb, ifid);
glp:
	c = mget(&rb);
	if (rb.nrd < 1)
		quitsig(35);
	new_size++;
	if ((c == '\n') && (!hrec.modata)) goto glp;
	if (c == 0177) quitsig(35);  /* bad news - delete codes */
	if (i > MAXRSIZE) quitsig(34); /* also bad - record has no end */
	record[i++] = c;
	if (c == hrec.recsep) {
		if (!hrec.modata) new_size++;
		record[i] = '\0';
		close(ifid);
		return(i);
	}
	goto glp;
}
/*****************************  loadpat  ***********************************/
/* set up next patient - xname as current and load working set.
 * return 1 if found, 0 if not found or done with this name */

loadpat(xpname)
char *xpname;
{
register int i;
	i = lookp(xpname);
	if (!i) return(i);
	ncpy(&cur, &prec, sizeof prec);
	cp_off = ploc;
	loadws(cur.p_num);
	return(i);
}


/****************************  loadws  *************************************/
/* load working set - i.e. index entries of all records for this patient */

loadws(xpnum)
long xpnum;
{
register int i, j;
	cur_rcnt = nlookp = 0;
	i = 0;
	while (lookn(xpnum)) {  /* returns entry in snrec */
		if (i >= MAXREC) {
			cur_rcnt = i;
			errpnum = xpnum;
			quitsig(38);
		}
		ncpy(&crec[i], &snrec, sizeof snrec);
		crec[i].nws_loc = nloc;
		j = lookupn(crec[i].crec_n.nf_num);
		crec[i].nfmt_num = filent[j].fmt_cd;
		i++;
	}
	cur_rcnt = i;
}
/*******************************  lookup, lookupn  *************************/
/* look up files in the file table by name or number */

lookup(fname)
char *fname;
{
register int i;
	for (i=0; i<hrec.numfile; i++)
		if (strcmp(fname, filent[i].f_name) == 0) return(i);
	return(-1);
}
lookupn(fnum)
unsigned fnum;
{
register int i;
	for (i=0; i<hrec.numfile; i++)
		if (fnum == filent[i].f_num) return(i);
	return(-1);
}

/******************************  make entries (makn, makp, maks) ***********/

/* make an nfile entry and write it at specified location */
makn(pnum, fnum, off, loc)
unsigned fnum;
long pnum;
long off, loc;
{
struct num_ent tn;
	tn.np_num = pnum;
	tn.nf_num = fnum;
	tn.f_loc = off;
	if (loc == ML) newnloc=lseek(nfid, 0L, 2);
	else newnloc = lseek(nfid,loc,0);
	write(nfid, &tn, sizeof (struct num_ent));
}

/* makp make a pfile (patient name vs number) entry in pfile */
makp(pname, pnum, loc)
char *pname;
long pnum;
long loc;
{
struct pat_ent tp;
register int i;
register char c;

	for (i=0; i<PNSIZE; i++) {
		c = pname[i];
		if ((c >= 'a') && (c <= 'z')) c &= 0137;
		tp.p_name[i] = c;
	}
	tp.p_num = pnum;
	if (loc == ML) lseek(pfid, 0L, 2);
	else lseek(pfid, loc, 0);
	write(pfid, &tp, sizeof (struct pat_ent));
}

/* maks - make an sfile entry (spec number vs patient number and record location */
maks(spnum, pnum, fnum, off, loc)
unsigned fnum;
long pnum;
long spnum, off, loc;
{
	struct sp_ent ts;
	ts.sp_num = spnum;
	ts.xp_num = pnum;
	ts.sf_num = fnum;
	ts.sf_loc = off;
	if (loc == ML) lseek(sfid, 0L, 2);
	else lseek(sfid, loc, 0);
	write(sfid, &ts, sizeof (struct sp_ent));
}

/*******************************  mergit  **********************************/
/* merge data record with the appropriate format */

mergit(fmt, rec)
int fmt;
char rec[];
{
struct fbuf fpr, opr;
int fsize, dsize, rpnt, i, fmtid;
char fc, dc;

	scrst = 0;
	fmtid = open(fmtdef[fmt].fmt_name,0);
	mfinit(&fpr, fmtid);
	mfinit(&opr, 1);
	rpnt = 0;
lp:
	fc = mget(&fpr);
	if (fpr.nrd < 1) goto mdone;
	mput(fc, &opr);
	if (fc != '[') goto lp;
	fsize = dsize = 0;
	while ((fc = mget(&fpr)) != ']') fsize++;
dlp:
	dc = rec[rpnt++];
	if ((!hrec.modata) && (dc == '\n')) goto dlp;
	if ((dc == hrec.recsep) || (dc ==hrec.fldsep)) goto fdone;
	mput(dc, &opr);
	if (++dsize >= fsize) goto goblp;
	goto dlp;
goblp:
	dc = rec[rpnt++];
	if ((dc == hrec.fldsep) || (dc == hrec.recsep)) goto fdone;
	goto goblp;
fdone:
	i = fsize - dsize;
	while (i--) mput(' ', &opr);
	mput(fc, &opr);
	if (dc == hrec.recsep) {
		mput('\n', &opr);
		goto mdone;
	}
	goto lp;
mdone:
	mflush(&opr);
	close(fmtid);
}

/*******************************  ncpy  ************************************/
/* copy exactly n characters */
ncpy(to, from, n)
char *to, *from;
int n;
{
	while (n--) *to++ = *from++;
}
ncpyt(to, from, n)	/* and add a null at the end */
char *to, *from;
int n;
{
	while (n--) *to++ = *from++;
	*to = '\0';
}

/*******************************  ndfile  *********************************/
/* select new file as default file for a particular format */

ndfile(st)
int st;
{
register int i, j;
register char c;
	fmtoff();
	st++;
	fcnt = 0;
flp:
	c = tbuf[st++];
	if ((c == ' ') && (!fcnt)) goto flp;
	if ((c == ' ') || (c == '\0')) goto gotfile;
	dfile[fcnt++] = c;
	goto flp;
gotfile:
	if (!fcnt) return(-1);
	dfile[fcnt] = '\0';
	filspot = lookup(dfile);
	if (filspot < 0)
		return(-1);
	nfmt = filent[filspot].fmt_cd + 1;
	cur_fnum = filent[filspot].f_num;
	fmtdef[nfmt-1].fil_num = cur_fnum;
	strcpy(fmtdef[nfmt-1].fmt_app,dfile);
	printf("file %s associated with format %d - %s\n",dfile,nfmt,fmtdef[nfmt-1].fmt_name);
	fdexmod = 1;
	return(1);
}

/*******************************  puff  ***********************************/

/* puff - put a timing null as appropriate for output */
puff(rec)
char *rec;
{
register i;
struct fbuf fpr;

	mfinit(&fpr, 1);
	for (i = 0; i<recsize; i++) {
		if (hispd) {
			switch (dlymode) {
				case 2:
					/* most buffered terminals */
					if (i%20 == 0) {
						mputrec("\0\0\0", 3, &fpr);
					}
				default:
					break;
			}
		}
		mput(rec[i], &fpr);
	}
	mflush(&fpr);
	scrst = 0;
}

/*******************************  setcur  **********************************/
/* record current record info for autocopy if needed */

setcur()
{
register int i, j, k;
int l, m;
	if ((fmtinf[ltype].fmt_mod & SOURCE) == 0) return;
	amax = 0;
	for (i=0; i<10; i++) apnt[i] = asize[i] =0;
	for (i=0; i<fmtinf[ltype].num_fld; i++) {
		j = fmtinf[ltype].st_fld + i;
		if ((fld[j].f_flags & SOURCE) == 0) continue;
		m = fld[j].f_pos;
		if (m > recsize) break;
		k = fld[j].f_anum;
		apnt[k] = amax;
		for (l = 0; l<fld[j].f_size; l++) {
			if ((m+l) > recsize) break;
			if (amax >= 249) return;
			afld[amax++] = tbuf[m+l];
			asize[k]++;
		}
		afld[amax++] = 0;
	}
}

/*******************************  setform  **********************************/
/* load a format onto the screen */

setform(type)
int type;
{
int fid;
	if (termtype == 4) {
		ltype = type-1;
		cur_type = type;
		write(1, wind[type],windlen[type]);
		fmtstate = 1;
		clr();
	}  else  {
		if ((cur_type == type) && (fmtstate == 1)) {
			clr();
			return;
		}
		fmtoff();
		ltype = type-1;
		cur_type = type;
		fid = open(fmtdef[ltype].fmt_name, 0);
		ldform(fid, fmtinf[ltype].st_fld);
		scrst = 1;
		close(fid);
		fmtstate = 1;
	}
}

/******************************  showrec  ***********************************/
showrec(fnum, floc, ffmt)
unsigned fnum;
long floc;
int ffmt;
{
register int i, j;
register char c;
	filspot = lookupn(fnum);
	fileck(filspot,4);  /* no return if access not allowed */
	i = getfrec(fnum, ibuf, floc);
	if (i < 1) return(-1);
	errloc = floc;
	if (popt) goto do_pr;
	expand(ibuf, tbuf, ffmt);
	setform(ffmt+1);
	setcur();
	puff(tbuf);
pr_done:
	i = getin(0);
	return(i);
do_pr:
	if (mopt) goto do_m;
	if (fopt) goto do_f;
	i = j = 0;
	while ((c = ibuf[i++]) != hrec.recsep) {
		if (j++>78) {
			j=1;
			putc('\n',stdout);
		}
		putc(c,stdout);
	}
	putc(c,stdout);
	putc('\n',stdout);
	goto pr_done;
do_f:
	fputs(ibuf,stdout);
	goto pr_done;
do_m:
	mergit(ffmt, ibuf);
	goto pr_done;
}

/*******************************  valchk  ***********************************/

/* valchk - check record for validity - return 1 if ok, else 0 */
valchk()
{
register int f, i;
register char c;
int flag, err, st, len, j, fend;
int	endp;

	err = 0;
	f = fmtinf[ltype].st_fld;
	fend = fmtinf[ltype].end_fld;
	for (i=0; i<recsize; i++) {
		c = tbuf[i];
		if ((c == hrec.fldsep) || (c == hrec.recsep)) {
			tbuf[i] = '?';
			err++;
		}
	}

fldlp:
	len = fld[f+1].f_pos - fld[f].f_pos;
	st = fld[f].f_pos;
	flag = fld[f].f_flags;
	endp = st+len;

	if (( flag & (LCASE|NUMERIC|ALPHA|REQUIRED)) == 0) goto fold;
	if (st >= recsize) goto ck_r;	/* past end - check if required field */
	if (flag & NUMERIC) {	/* check numeric only field (also spaces) */
		for (i=st; i<endp; i++) {
			if (i >= recsize) break;
			c = tbuf[i];
			if ((c >= '0') && (c <= '9')) continue;
			if (c == ' ') continue;
			err++;
			tbuf[i] = '?';
		}
	}	/* end of numeric checking */

	if (flag & ALPHA) {	/* check alpha only field (also spaces) */
		for (i=st; i<endp; i++) {
			if (i >= recsize) break;
			c = tbuf[i];
			if ((c>='a') && (c <= 'z')) continue;
			if ((c == ' ') || (c == '-')) continue;
			if ((c >= 'A') && (c <= 'Z')) continue;
			err++;
			tbuf[i] = '?';
		}
	}	/* end of alpha checking */

ck_r:		/* checking for required field */
	if (flag & REQUIRED) {
		for (i=st; i<endp; i++) {
			if (i >= recsize)	{  /* missing required field after end of input */
				for (j = recsize; j<endp; j++)	/* pad up to current location */
					tbuf[j] = ' ';
				recsize = endp+1;		/* update record size */
				goto missing;
			}
			if (tbuf[i] != ' ') goto r_done;	/* something found */
		}
missing:
		tbuf[st] = '?';
		err++;
	}
r_done:
	if (st >= recsize) goto nextf;
	if (flag & LCASE) goto nextf;	/* do not fold to upper case */
fold:	/* convert to all upper case unless LCASE set */
	for (i=st; i<endp; i++) {
		if (i >= recsize) break;
		c = tbuf[i];
		if ((c < 'a') || (c > 'z')) continue;
		tbuf[i] = c & 0137;	/* mask off lower case bit */
	}

nextf:
	f++;
	if (f <= fend) goto fldlp;
	if (err) return(0);
	return(1);
}

/******************************  valrec  **********************************/

valrec()
{
	if (valchk())		/* returns 1 if record is ok */
		return(1);
/* process here if record is bad */
/* clear screen, 1 beep, send record back with ??, 1 more beep */
	write(1,bell,1);
	clr();
	puff(tbuf);
	write(1,bell,1);
	return(0);
}

/***************************  zapn  ****************************************/

zapn(rec, n, c)
char *rec, c;
int n;
{
	while (n--) *rec++ = c;
}
