/*
 * vseqchk
 * by David E. Miran  -  Wisconsin State Hygiene Lab
 * 3/8/82
 */

#include	<myio.h>
#include	<stdio.h>
#include	"vir.h"

struct	fbuf	f1;
struct	num_ent	arec;
struct	num_ent	brec;
struct pat_ent crec;
struct pat_ent drec;
long	rnum;

main(argc,argv)
int argc;
char **argv;
{
int i, fid;
	if ((fid = open("NFILE", 0)) < 0) {
		printf("vseqchk:  cannot open NFILE\n");
		exit(1);
	}
	rnum = 0;
	mfinit(&f1,fid);
	printf("vseqchk: checking NFILE\n");
	while(mgetrec(&arec, sizeof (struct num_ent), &f1)) {
		rnum++;
		if ((rnum%10000) == 0) printf("passing %6D\n",rnum);
		if (rnum == 1) goto mv;
		if (arec.np_num < brec.np_num) {
			printf("sequence error pos, pnum %6D %10D\n",(long) rnum -1, brec.np_num);
			printf("               pos, pnum %6D %10D\n", rnum, arec.np_num);
		}
mv:
		brec.np_num = arec.np_num;
	}
	mfclose(&f1);
	printf("vseqchk done checking NFILE after %D records\n",rnum);
	if ((fid = open("PFILE", 0)) < 0) {
		printf("vseqchk:  cannot open PFILE\n");
		exit(1);
	}
	rnum = 0;
	mfinit(&f1,fid);
	printf("vseqchk: checking PFILE\n");
	while(mgetrec(&crec, sizeof (struct pat_ent), &f1)) {
		rnum++;
		if ((rnum%10000) == 0) printf("passing %6D\n",rnum);
		if (rnum == 1) goto mvp;
		if (strncmp(crec.p_name, drec.p_name, PNSIZE) < 0) {
			printf("sequence error pos, pname %6D %-14.14s\n",(long) rnum -1, drec.p_name);
			printf("               pos, pname %6D %-14.14s\n", rnum, crec.p_name);
		}
mvp:
		strncpy(drec.p_name, crec.p_name,PNSIZE);
	}
	mfclose(&f1);
	printf("vseqchk done checking PFILE after %D records\n",rnum);
	exit(0);
}
