/*
 * written by J. Barry Bulat   01/11/80     P.I.N.Y.
 *
 * This program starts hasp (after doing other nice things)
 * with the correct uid and gid and at the right priority.
 * The lock file is also created to prevent the starting
 * of hasp when its running.
 *
 */

/*  modified  --  6/22/80      J.B.B.
 *  program now writes date and time of the starting of hasp
 *  into the lockfile in the form    mm/dd/yy : HH:MM:SS
 */

#include	<info.h>
#define HASPFILE "/usr/hasp/.hasp.lock"
struct info uinfo;

main() {
	int i,fd,cfd;
	setuid(68);
	fd = open(HASPFILE,0);
	if (fd >= 0) {
		write(1,"\n\07Hasp has already been started.\n", 33);
		exit(-1);
		}
	close(fd);
	if ((i = fork()) == 0)
		execl("/usr/hasp/hasphalt","hasphalt",0);
	if (i != -1)
		wait(&i);

	if ((i = fork()) == 0)
		execl("/usr/hasp/compact","compact",0);
	if (i != -1)
		wait(&i);

	if ((cfd = creat(HASPFILE,0600)) < 0) {
		write(1,"Can not create lock file\n",25);
		exit();
		}
	close(cfd);
	close(1);
	open(HASPFILE,1);
	if ((i = fork()) == 0)
		execl("/bin/date","date","+%m/%d/%y : %H:%M:%S",0);
	if (i != -1)
		wait(&i);
	close(1);
	dup(0);

	chown(HASPFILE, 68, 3);
	if ((i = fork()) == 0) {
		nice(0);
		umask(0);
		strncpy(uinfo.l_lognam, "rje/hasp", 8);
		strncpy(uinfo.l_logdir, "/usr/hasp", 32);
		strcpy(uinfo.l_logtty, "?");
		logpost(&uinfo);
		setgid(3);
		execl("/usr/hasp/haspinit","haspinit",0);
		}
	if (i != -1)
		wait(&i);
	exit(0);
	}
