#include "stdio.h"
#include "utmp.h"
#include "sys/utsname.h"
#include "hsubs.h"
#include "info.h"
#include "quotas.h"

/*
 * define HALTSTAT to do halt time checking
 */

#define UTMP	"/etc/utmp"
#define WTMP	"/etc/wtmp"
#define PWFIL	"/etc/passwd"
#define	LOGFILE	"/usr/adm/.loginlog"
#define	TTYTYPE	"/etc/ttytype"
#define LCNT		0037
#define NONOTIFY	0040
#define WARNING		0100
#define	NOVER		4	/* Number of times allowed in over quota */
#define NDISABLE	9	/* Number of logins that indicates disability */
#define	OVERTIME	(10*60)	/* Time duration/over limit logon */
#define	MAXHOMELEN	64
#define	MAXTTYLEN	16



struct	pwent	{		/* The password file entry structure */
	char	lognm[10];	/* Who entry is for */
	char	passwd[16];	/* User Password (encrypted) */
	char	uid[6];		/* User Id (0-32767) */
	char	gid[6];		/* Group id (0-63) */
#ifdef	NICEFIELD
	char	prio[6];	/* Nice for account */
#endif
	char	pstat;		/* Status of account */
	char	termlim[4];	/* Maximum number of logins */
	char	homedir[24];	/* Account login directory */
	char	shell[34];	/* Shell to run upon login */
};



/* Define LOGLIMIT to be the maximum number of people logged in */

#define	LOGLIMIT	45

/* leave EXPSTUFF defined to support express terminals */
#define	EXPSTUFF 1
#undef	EXPSTUFF

#ifdef EXPSTUFF
#define EXPRESS1 "ttyv"
#define EXPRESS2 "ttyt"
#define EXPRESS3 "ttyu"
#define EXPFILE  "/etc/express1"
#endif
#define WARN  480
#define ONE    60
#define HALF   30
#define FIFTEEN 900


struct exp {
	char names[9];
	char ttys;
	long times;
	} ;

/*
 * Stuff for environs
 */
#define	TYPEPLACE	2	/* Offset into envinit for ttytype */
