

/*
 *	Polytechnic UNIX accounting Package - Program: mktoday.c
 *
 *	Author:	John Buck
 *	Polytechnic Institute NY, September 1981
 *
 *	Program Description:
 *		Program takes the current accounting file, and subtracts
 *		the figures in it with the ones in the previous accounting
 *		file.
 *
 */





#include	"hsubs.h"
#include	"actrecs.h"

char	nbuf[10240];

main(c,v)
char **v;
{
	char err;
	int old , new , wrt , r1 , r2;
	register struct acctrec *op , *np;
	struct acctrec opb, tbuf;
	register hk;


	if(c != 4)exit(1);

	if(((old = open(v[1],2)) == -1) ||
	   ((new = open(v[2],0)) == -1) ||
	    ((wrt = creat(v[3],0600)) == -1)){
		printf("File open error\n");
		exit(1);
	}

	close(wrt);
	if((wrt = open(v[3], 2)) == -1){
		printf("Error - mktoday\n");
		exit(2);
	}
	lseek(wrt, (long)(NHENT)*AREAD - 512L, 0);
	write(wrt, nbuf, 512);
	while((r2 = read(new,nbuf,10240))%AREAD == 0 && r2){
	for(np = nbuf; np < &nbuf[r2]; np++){
		if(np->a_uid == 0 && np->a_gid == 0)
			continue;
		err = 0;
		hk = np->a_uid;
		lseek(old, (long)(akey(hk))*AREAD, 0);
lp:
		if(read(old, (op = &opb), AREAD) != AREAD){
			if(err++){
				printf("Read error in mktoday\n");
				exit(2);
			}
			lseek(old, 0L, 0);
			goto lp;
		}
		if(op->a_uid != np->a_uid || op->a_gid != np->a_gid)
			if(op->a_uid == 0 && op->a_gid == 0)
				op = np;
			else goto lp;
		else {
			op->a_connect = np->a_connect - op->a_connect;
			op->a_usrcpu = np->a_usrcpu - op->a_usrcpu;
			op->a_syscpu = np->a_syscpu - op->a_syscpu;
			op->a_diskblks = np->a_diskblks - op->a_diskblks;
		}
		lseek(old, -(long)(AREAD), 1);
		write(old, np, AREAD);
		lseek(wrt, (long)(akey(hk))*AREAD, 0);
		err = 0;
lp1:
		if(read(wrt, &tbuf, AREAD) != AREAD){
			if(err++){
				printf("Read error -- part 2 mktoday\n");
				exit(3);
			}
			lseek(wrt, 0L, 0);
			goto lp1;
		}
		if(tbuf.a_uid != op->a_uid || tbuf.a_gid != op->a_gid)
			if(tbuf.a_uid != 0 || tbuf.a_gid != 0)
				goto lp1;
		lseek(wrt, -(long)(AREAD), 1);
		write(wrt, op, AREAD);
	}
	}
	close(wrt);
	close(new);
	close(old);
	exit(0);
}
