
#include	"tron.h"

struct direc	rec[] {
	"/usr/lib", "usrlib", MTIME | CKSUM,
	"/usr/bin", "usrbin", MTIME | CKSUM,
	"/usr/src/uts/os", "usrsrcos", ATIME|MTIME,
	"/usr/src/uts/io", "usrsrcio", ATIME | MTIME,
	"/usr/src/uts/cf", "usrsrccf", ATIME | MTIME,
	"/usr/hasp", "usrhasp", MTIME,
	"/bin", "bin", MTIME | CKSUM,
	"/etc", "etc", MTIME | CKSUM,
	"/lib", "lib", MTIME | CKSUM,
	"/", "root", MTIME | CKSUM,
	"/usr/src/uts/pdp11", "usrpdp11", ATIME | MTIME,
	0, 0, 0
};

char	*mess[] {
	"Doing *",
	"Queued as*",
	"2033+0*",
	"1000+0*",
	"prnt[0-9]:*",
	"Hasp halted*",
	"passwd*locked*",
	"[0-9]*cards.*",
	"*device busy*",
	"/accting/util/transmit",
	"/accting/util/coredeath&",
	"/accting/util/disk*",
	"send -y *",
	"/accting/util/do_accting&",
	"/acct/backups/root&",
	"/acct/backups/staff&",
	"/accting/util/daily_acct",
	"/usr/hasp/start.hasp",
	"/accting/util/do.unixupdt.1",
	"/accting/util/do.unixupdt.2",
	"/dev/rrm*:",
	0
};

main(c, v)
char **v;
{
	register struct direc *pd;

	if(getgid() != 0 && getuid() != 0){
		fprintf(stderr, "tron: Must run as group root or uid root\n");
		exit(1);
	}
	if(c > 1)
		fprintf(stderr, "tron: Reading syslog\n");
	getnew();
	if(c > 1)
		fprintf(stderr, "tron: Doing inode checks and checksums\n");
	for(pd = rec; pd->d_namep; pd++){
		if(c > 1)
			fprintf(stderr, "\t%s...\n", pd->d_namep);
		checkdir(pd);
	}
	if(c > 1)
		fprintf(stderr, "tron: Checking cron log\n");
	ckcron();
	if(c > 1)
		fprintf(stderr, "tron: Checking quota file\n");
	ckquotas();
}

