/*************************************************************
 *   Configuration program for Metal
 *
 *	FILE: MECONFIG.C
 *
 *  Z-Msg, Metal and Metal Message System are Trademarked and
 *		  Copyright (c) 1984,1985 Tim Gary
 *   			All rights reserved.
 *
 *
 *  This is the configuration program which enables you to
 * setup the message system without recompiling.
 *
 *************************************************************
 *
 * 1.31a  10/13/85 Release version.  Following changes:
 *		   ^P works here.  Maxdrive added.  ZCPR3 specific
 *		   additions to user status setup.  Config file version
 *		   verified before load.  New clock code stuff.
 *		   Cosmetic changes (default values shown before question)
 * 1.30xx 7/10/85  Epson clock config questions cleared up.
 * 1.30xx 6/15/85  Minutes for auto timeout added to user val parms.
 * 1.30xx 5/15/85  CONFIG define added to cut space on global vars in hmh.h
 * 1.30xx 4/26/85  More Z3 stuff added (Z3ENV string stored with perm save)
 * 1.30xx 3/05/85  Z3 Stuff added..
 * 1.20b 01/16/85  Kenmore tech clock stuff added..
 * 1.20b 01/05/85  CCS stuff back in, and QX10 clock option added.
 * 1.20a 11/04/84  CCS stuff deleted.
 * 1.10d 10/21/84  Sysop pass bug fixed.
 * 1.10c 10/18/84  New config format (from hmh.h)...
 * 1.10b 10/04/84  Cosmetic changes for new version of Metal.
 * 1.01a  7/15/84  Fixed minor bug in menu routine.
 * 1.01a  7/10/84  Fixed some bugs introduced in 1.06 changes.
 * 1.01a  7/02/84  Multi_User Id location added as option.
 * 1.01a  6/10/84  Aztec c 1.06 changes made.  Added CCS Clock
 *		  stuff.  Got rid of
 *		  all the USER/DRIVE stuff, since files now 
 *		  include that in their name.
 * 1.0c	  5/17/84  Hayes clock support added.
 * 1.0b   4/18/84  Added default user status in 'usertypes'.
 * 1.0b   4/14/84  (continue fixing things)
 * 1.0b	  4/13/84  Extensive changes to internal format.  Menu
 *		   changes, addition of message parm options,
 *		   and save configuration function.  The save-
 *		   perm function has been made general, and
 *		   is grouped under one command.
 * 1.0a   2/07/84  Cosmetic and functional additions/fixes.
 * 1.0    1/22/84  Provide for pre-release version 3.0a changes.
 *		   First working version of this !!!
 *
 *************************************************************/

#define CONFIG	1

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/

#include "ctype.h"

#define TITLE  "\nConfiguration %s\nCopyright 1984,1985 Tim Gary\n\n"

#define	CHAR	1	/* flag to return a 1 byte number	*/
#define	INT	2	/* flag to return an int (2 bytes)	*/
#define	HEX	4	/* flag to make it a hex number		*/

/* new menu function declarations.. */

struct menutype	{
	char *itemdesc;		/* description string  */
	int  (*func)();		/* pointer to function */
	};

int finishup(),usertypes(),privatesys(),mfiles(),maxtry(),clock(),
    byestuff(),zcprstuff(),location(),printer(),statline(),
    sysopstuff(),getconf(),savem(),msgstuff(),saveconf();

struct menutype main_menu[] = {
  "Return to operating system\n    (Optionally save configuration file)",finishup,
  "Operating system setup (ZCPR)",zcprstuff,
  "Edit user types",usertypes,
  "Private/Public system setup",privatesys,
  "Files: Names and locations",mfiles,
  "Maximum tries user gets before being logged out",maxtry,
  "Real Time Clock installation",clock,
  "BYE parameters",byestuff,
  "Location of system (Sign-on message)",location,
  "Printer log option",printer,
  "25th status line setup",statline,
  "Sysop name and password",sysopstuff,
  "Message-base options (max messages, etc..)",msgstuff,
  "Save current settings in a configuration file",saveconf,
  "Recall a previously saved configuration file",getconf,
  "Permanently save current configuration",savem,
  0,0	/* mark end of menu */
};


static char tversion[40],tbbsname[55];	/* for saving REAL version/name */

/*********************
 * Main program loop *
 *********************/

main()
{
char *menu();
int (*func)();

strcpy(tversion,O.VERSION);	/* save these..  */
strcpy(tbbsname,O.BBSNAME);

send(O.BBSNAME);
printf(TITLE,O.VERSION);
height=0;		/* no screen pause */
user.status=SYSOP;	/* so ^P works */
user.type=get_type(user.status); /* "  */

getconf();	/* see if he has a config file to use, and get it if so */

while (1) 
	{
	send("\n|||[ Configuration Menu ]|||\n");
	func=menu(main_menu);	/* endless loop */
	(*func)();
	}

} /* main program loop */


/***********************************************************************/


/******************************************************************
 * display menu, and get response. Return pointer to the function *
 ******************************************************************/

char *menu(menu_table)		/* really returns pointer to function, but
				   how the hell do you declare that? */
 struct menutype *menu_table;
{
struct menutype *mp;
register int i;
char n;

n=255;	/* so that RETURN will look like invalid entry */

/* for (items=0,mp=menu_table; mp->itemdesc; ++items,++mp); */ /* get items count */

do {
  for (i=0,mp=menu_table; mp->itemdesc; i++,++mp)
	{
	sprintf(buffer,"\n%2d. %s.",i+1,mp->itemdesc);
	if (send(buffer)==ERROR) break;	/* so you can cheat if you know the item number already */
	}
   send("\n\n");
   asknum("Select",&n,0,CHAR);
   } while (n>i  /*  tems  */   || n==0);
for (mp=menu_table; n-1; --n,++mp);

return mp->func;
}


/*********************************************
 * Get file/drive/user setting the user and  *
 * drive up for an open, and returning a     *
 * string pointer to the filename.	     *
 *********************************************/

char *getfile(ask_str)	/* prints prompt string 'str' */
 char *ask_str;
{
static char gf_fn[23];		/* static so value don't go away on return! */

ask(ask_str,gf_fn,17,UP);		/* ask for file name */
if (gf_fn[0]=='\0') return NULL;	/* signal nothing entered */
 else return gf_fn;
}


/********************************
 * get config file from disk if *
 * he has one to get.. else all *
 * defaults are used ...        *
 ********************************/

getconf()
{
FILE *config;	/* config file */
char *fn;	/* file name */
struct options *TO;	/* temp pointer for duplicate O variable */

while (1) {
	if ((fn=getfile("Configuration file name? "))==NULL) break;
	if ((*fn=='?') || (!ustrcmp("help",fn)))	/* help wanted */
		{
		send("If you have a configuration file saved\
\nfrom running this program previously,\n");
		send("you may retrieve it here.\n");
		}
	config=open(fn,F_RD | F_UNLOCK);  /* open for read */
	if (config==NULL)
		{               /* error, file not found */
		send("Can't find that file.\n");
		continue;       /* ask again */
		}

	if ( !(TO=alloc( (sizeof O)+10 ) ) )
		{
		char t[15];
		strcpy(t,O.cfg_vers);
		uread(config,O.zippo,sizeof O);	/* unix style read.. */
		if ( strcmp(O.cfg_vers,t) )
			{
			send("\nERROR: Configuration file version mismatch.\n\nExiting...\n");
			exit(1);
			}
		}
	  else
		{
		uread(config,TO,sizeof O);
		if ( strcmp(O.cfg_vers,TO->cfg_vers) )
			{
			send("\nERROR: Version mismatch.\
\nconfig file not for this version.\n");
			free(TO);
			continue;
			}
		movmem(TO,O.zippo,sizeof O);	/* copy since it's ok.. */
		free(TO);
		}

	if (O.RTC!=NOCLOCK)
		loadclock(config);
	
	send("Configuration file loaded.\n");
	close(config);

	break;	/* exit loop */
	}

strcpy(O.BBSNAME,tbbsname);	/* fix these up.. */
strcpy(O.VERSION,tversion);

} /* get config */


/*************************************
 * Finish up by saving config. file  *
 * and possibly making changes to the*
 * metal and menter files themselves *
 *************************************/

finishup()
{
while (1) {
	ask("\nSave current configuration in separate\nconfiguration file? ",buffer,2,UP);
	if ( (*buffer=='\0') || (*buffer=='?') || !ustrcmp("help",buffer))
		{
		send("\nYou may save the current configuration in a file\
\nthat may be read at a later time.\n");
		send("Time spent reconfiguring several options\
\nover again can be saved.\n");
		continue;
		}
	if (*buffer!='Y') break;        /* nope, so forget it */
		else { saveconf();	/* save configuration file */
		       break; }
	}
send("\n[Entering The Operating System]");

exit(0);
}


/**************************************
 * save current configuration in file *
 * that getconf() can read later on.. *
 **************************************/

saveconf()
{
register FILE *mfile;           /* metal/menter file descriptor */
register char *addr;            /* address used to write config */
char *fn;

while (1) {	/* seemingly endless loop */
	if ((fn=getfile("File name to save configuration under?\
\n** Be sure to specify USER/DRIVE:filename **\n--> "))==0) break;
	mfile=open(fn,F_RW | F_LOCK);   /* open for write */
	if (mfile==NULL)
		{		/* couldn't open file */
		send("** Unable to open file **\
\nInvalid drive, disk full, or write protected.\nTry again.\n\n");
		continue;       /* ask filename again */
		}
	send("Saving.\n");
	for (addr=O.zippo; addr<=O.zappo; addr+=128)
		{
               movmem(addr,bufloc(mfile),128);
               write(mfile,1);         /* write/increment pos */
               }
       putclock(mfile);	/* save clock routine */
       close(mfile);
       break;
       }       /* endless while */
}


putclock(fil)
 FILE *fil;
{
if (O.RTC!=NOCLOCK)
	{
	movmem(0x0204,bufloc(fil),128);
	write(fil,1);
	movmem(0x0284,bufloc(fil),128);
	write(fil,1);
	movmem(0x0304,bufloc(fil),128);
	write(fil,1);
	}
}

/*********************************************
 * Save config in metal or menter, or most   *
 * any other file by that matter............ *
 *********************************************/

savem()
{
FILE *fil;
char *addr,*addr2;
char *fn;

do {
	if ((fn=getfile("Save configuration permanently in which\
\nMessage System COM file? "))==NULL) break;
	if (*fn=='?' || !ustrcmp("help",fn))
		{	/* help person out */
		send("\nTo make the options you have changed permanent\
\n(operational), you must save the configuration\
\nin the appropriate COM files.\n");
		send("The main message system COM file\
\nand this configuration program are the main files\
\nthat can have the configuration saved in them.\n");
		continue;
		} 
	if (!index(fn,'.')) strcat(fn,".COM");
	fil=open(fn,F_RW | F_LOCK);	/* open for r/w */

	send("[Searching...]\n");
	toeof(fil);		/* go to end of file */
	if (getrec(fil)==0 || fil==NULL) {
			send("\n<<File not found...>>\n");
			close(fil);
			unlink(fn);	/* cleanup open's mess */
			return;
			}
	setrrec(fil,-1);
	read(fil,0);
	movmem(bufloc(fil),buffer,128);
    do	{
	setrrec(fil,-1);
	movmem(buffer,buffer+128,128);
	read(fil,0);
	movmem(bufloc(fil),buffer,128);

	printf("Record %d\r",getrec(fil));

	for (addr=buffer; addr<buffer+250; addr++)
               if (!strncmp(O.zippo,addr,10)) break;
	if (!strcmp(O.zippo,addr)) break;

	} while (getrec(fil)>0);

if (getrec(fil)<=0) { send("\nNothing found to replace..\n"); break; }

	send("\nFound option area, saving.");
/* we have the address in the buffer of zilch */

if (addr>=buffer+128)
	{
	addr2=(buffer+256)-addr;
	movmem(O.zippo,bufloc(fil)+(addr-(buffer+128)),addr2);
	setrrec(fil,-1);
	}
  else	{
	addr2=(buffer+128)-addr;
	movmem(O.zippo,bufloc(fil)+(addr-buffer),addr2);
	}

	write(fil,1);           /* write portion of record+incr. */
	putchar('.');
	for (addr=O.zippo+(int)addr2; addr+128<O.zappo; addr+=128)
        	{
        	movmem(addr,bufloc(fil),128);
        	write(fil,1);   /* write/incr */
        	}

	putchar('.');
	read(fil,0);	/* get background of buffer */
	movmem(addr,bufloc(fil),(O.zappo-addr)+1);	/* put rest of O in */
	write(fil,0);	/* write it	*/
	if (O.ZCPR==3)
		{	/* if Z3, make sure Z3INS will work */
		setarec(fil,0);
		read(fil,0);		/* get first record.. */
		strncpy(bufloc(fil)+3,"Z3ENV\01",6);
		write(fil,0);
		}

	if (O.RTC!=NOCLOCK)	/* yucko routine */
		{
		setarec(fil,2);
		read(fil,0);
		movmem(0x0204,bufloc(fil)+4,124);
		write(fil,1);
		movmem(0x0280,bufloc(fil),128);
		write(fil,1);
		movmem(0x0300,bufloc(fil),128);
		write(fil,1);
		read(fil,0);
		movmem(0x0380,bufloc(fil),4);
		write(fil,1);
		}

	close(fil);     /* boy, that was easy (well, not really) */
	send("<done>\n");

       } while (0); /* one-shot loop */
} /* savem */


/********************************
 * Get number (as a char) 0-255 *
 ********************************/

asknum(str,nptr,max,flag)
 register char *str,flag;
 int *nptr;
 register int max;
{
char ts[10],temp[MAXLINE+1];
char *cptr;
int tint;	/* temp int */

cptr=nptr;	/* make a char pointer to the same thing as int */

if (flag&HEX)
	sprintf(temp,"[%x] %s? ",flag&INT ? *nptr : (int)(*cptr),str);
  else sprintf(temp,"[%d] %s? ",flag&INT ? *nptr : (int)(*cptr),str);

do	{
	ask(temp,ts,10,UP);
	if ( !(flag&HEX) )
		{
		if (isdigit(*ts))
			{
			if (max!=0)
				if (atoi(ts)>max)
					{
					printf("Maximum value is %d.\n",max);
					continue;
					}
			return (flag&INT ? (*nptr=atoi(ts)) : (*cptr=atoi(ts)));
			}
		}
		else	/* wants a hex char */
		    {	if (*ts=='\0') break;
			sscanf(ts,"%x",&tint);
			if (max!=0) if (tint>max)
					{
					printf("Maximum value is %xH.\n",max);
					continue;
					}
			return (flag&INT ? (*nptr=tint) : (*cptr=tint));
		    }
	}
	while (*ts!='\0');

return (*nptr);
}


/*********************
 * Get string, etc.. *
 *********************/

askstr(outstr,str,max)
 register char *outstr;
 char *str,max;
{
char ts[MAXLINE+1];

sprintf(ts,"[ %s ] %s? ",*str ? str : "-none-",outstr);

ask(ts,ts,max,UPLOW);
	
if (*ts!='\0') strcpy(str,ts);
}


/***********************
 * Get yes/no question *
 ***********************/

askyesno(outstr,yn)
 register char *outstr;
 char *yn;
{
char ts[2];
char temp[MAXLINE+1];
sprintf(temp,"[%s] %s (YES/NO)? ",(int)(*yn) ? "yes" : "no ",outstr);

do	{
	ask(temp,ts,1,UP);
	if (*ts=='\0') break;
	if (*ts=='Y') { *yn=YES;  break; }
	if (*ts=='N') { *yn=NO;   break; }
	} while (1);	/* crumby way to do this */
}


/*****************************
 * Edit avaliable user types *
 *****************************/

usertypes()
{
int i;
register u_types *uptr;	/* pointer to user structure */

send("Alter User types and parameters.\n\n");
send("NOTE: If you are running ZCPR3, make sure you've\
\nselected it in the Operating system setup item\
\nbefore you change the user types below.\n");
printf("\nDefault user status='%c'\n\n",O.DSTATUS);
ask("New default status character (see doc) ? ",buffer,1,UPLOW);
if ( (*buffer!='\0') && (index("+snxXabc",*buffer)) ) O.DSTATUS=*buffer;

for (uptr=O.user_types; uptr->type; uptr++)
	{
	printf("\
\nUser Char = '%c' 	  Max User area is %2d\
\nTimeouts:  Inactivity %d mins.,  General %d mins.\
\nMax Drive available is %c:   Wheel Privs are %3s.",
uptr->type,(int)(uptr->maxuser),(int)(uptr->timeout),(int)(uptr->minutes),
((uptr->maxdrive)+'A'),uptr->zcprflag==YES ? "ON" : "OFF");

	printf("\
\nKill other messages: %3s\
\nRead private messages: %s\
\nPost public messages: %3s",uptr->killflag==YES ? "YES" : "NO",
			     uptr->readpriv==YES ? "YES" : "NO",
			     uptr->postmsg==YES ? "YES" : "NO");

	if (O.ZCPR==3)
		{
		printf("\
\n _______________   ______________________________________________________\
\n/ ZCPR3 OPTIONS \\_/ Commands file mask: %4x   System file for user=%d\n",uptr->flags,(int)(uptr->sysnum));
		printf("\n\
System Segments to load on login:   ENV=%-14s   NDR=%-14s\n\
               RCP=%-14s   FCP=%-14s   IOP=%-14s\n",
		uptr->sysseg[ENV],uptr->sysseg[NDR],uptr->sysseg[RCP],
		uptr->sysseg[FCP],uptr->sysseg[IOP]);
		printf("\nRegister settings (if 'ignore' then register is left unchanged):");
		for (i=0; i<10; i++)
			{
			char temp[15];
			if ( i%4 == 0) putchar('\n');

			if (uptr->regs[i]&0xff00) sprintf(temp,"%3d     ",(uptr->regs[i])&255);
			   else strcpy(temp,"[ignore]");
			printf("Reg #%d) %s   ",i,temp);
			}
		send("\n\n");
		show_path(uptr);

		} /* if zcpr3 */

	ask("\n\nAlter this user (Q to return to main menu)? ",buffer,2,UP);
	if (*buffer=='Q') return;
	if (*buffer=='Y')
		{
		asknum("Max OS user number (0-15)",&uptr->maxuser,15,CHAR);
		asknum("Max Drive (Enter a number. 0=A:, 15=P:)",&uptr->maxdrive,15,CHAR);
		asknum("Sleepy caller timeout (minutes)",&uptr->timeout,0,CHAR);
		asknum("Minutes till bbs auto logout\
\n (0=NO LIMIT) (clock systems only)",
			&uptr->minutes,0,CHAR);
		askyesno("Does the user have WHEEL Privs\n(ZCPR Wheel)",
			&uptr->zcprflag);
		askyesno("Can this user kill other msgs",&uptr->killflag);
		askyesno("Can the user read private msgs",&uptr->readpriv);
		askyesno("Can the user post messages",&uptr->postmsg);
		if (O.ZCPR==3)
			{
			asknum("Special ZCPR3 command mask (in hex!)",
				&uptr->flags,0,HEX|INT);
			asknum("System file name area to put user name in (1-4)",&uptr->sysnum,4,CHAR);
			send("\nEnter the following WITHOUT filetypes (no .NDR, etc..),  enter\na single '/' to clear that filename (so that segment will not be loaded.\n");
			send("NOTE: It is advised that if ANY user type has a segment loaded, that\n");
			send("you also declare a segment of that filetype (ENV,etc..) to load for EACH\nother user type.\n");
			getsseg("ENV",ENV,uptr);
			getsseg("NDR",NDR,uptr);
			getsseg("RCP",RCP,uptr);
			getsseg("FCP",FCP,uptr);
			getsseg("IOP",IOP,uptr);
			for (i=0; i<10; i++)
				{
				sprintf(buffer,"Is register #%d to be set for this user",i); 
				askyesno(buffer,(char *)(&uptr->regs[i])+1);
				if (uptr->regs[i] & 0xff00)
					asknum("Set to what value (0-255)",
						&uptr->regs[i],0,CHAR);
				}
			get_path(uptr);
			} /* test for zcpr3 */

		}
	} /* for */

}	/* user types */


show_path(uptr)
u_types *uptr;
{
int i;
char c;

printf("Path:  ");
for (i=0; i<16 && (uptr->path[i]!=0); i+=2)
	{
	c=uptr->path[i];
	printf("%c",c=='$' ? '$' : ((c+'A')-1) );
	if (uptr->path[i+1]=='$') printf("$:  ");
	  else printf("%d:  ",(int)(uptr->path[i+1]));
	}
}


get_path(uptr)
 u_types *uptr;
{
char tc[10];
int i;

send("\nEnter each path in DU format with '$' indicating current drive or user area.\nFor example  A0    A$    $15   etc..  Enter each DU combo alone on a line.\n");

send("\nCurrent "); show_path(uptr);  send("\n\n");

for (i=0; i<16; i+=2)
	{
	sprintf(buffer,"Enter DU path element #%d (enter 0 to end path)? ",(i/2)+1);
  yuck: ask(buffer,tc,3,UP);
	if ( !strcmp(tc,"0") )
		{	/* must flush all rest of paths just in case.. */
		for (; i<16; i++) uptr->path[i]='\0';
		break;
		}
	if ( *tc=='\0' )
		{
		if ( !(uptr->path[i]) ) break;	/* last in list.. */
		  else continue;    /* get next if something already there */
		}
	if ( (!isdigit(tc[1]) && tc[1]!='$')
	     || ( (*tc>'P' || *tc<'A') && *tc!='$') )
		{
		send("[ ** Invalid Entry, RETYPE ** ]\n");
		goto yuck;
		}
	if (*tc=='$') uptr->path[i]='$';
	  else uptr->path[i]=*tc-'@';
	if (tc[1]=='$') uptr->path[i+1]='$';
	  else uptr->path[i+1] = (31 & atoi(tc+1));
	}  /* for loop */

} /* get_path */
	


getsseg(seg,num,uptr)
 char *seg;
 int num;
 u_types *uptr;
{
char *cp;
sprintf(buffer,"Enter name of %s segment to load ('/' if none)",seg);
askstr(buffer,&uptr->sysseg[num],12);
if (*(uptr->sysseg[num])=='/') *(uptr->sysseg[num])='\0';
if (cp=index(uptr->sysseg[num],'.')) *cp='\0';	/* terminate at typ if given */
}


/************************
 * Private system stuff *
 ************************/

privatesys()
{
send("Make system PRIVATE/PUBLIC.\n\n");

printf("System is now %s.  Password is %s\n(applies only if PRIVATE system).\n",
	O.PRIVATE ? "PRIVATE" : "PUBLIC",O.PRIVPASS);

askyesno("Make system Private",&O.PRIVATE);
if (O.PRIVATE) askstr("System Password",O.PRIVPASS,PASSLEN);
upcase(O.PRIVPASS);
}


/*********************************
 * Alter file names/drives/users *
 *********************************/

mfiles()
{
register int ind;

send("Alter filenames of BBS files.\n\n\
Current name\n\
    |  |\n\
     \\/\n");

for (ind=0; O.files[ind][0]!='\0'; ind++)
	{
	putchar('\n');

/*	sprintf(buffer,"\nFile %s :: new name (<return> if no change) ",
		O.files[ind]);	*/

	askstr("  Enter new name\n (<return> if no change) --> ",O.files[ind],17);
	}
}


/***********************************
 * Get max # of tries till hang-up *
 ***********************************/

maxtry()
{
printf("Maximum tries before logout=%d.\n",O.MAXTRIES);

asknum("New value (0-255)",&O.MAXTRIES,255,CHAR);
}


/**********************
 * Change clock setup *
 **********************/

clock()
{
char *filename=NULL;
char *clkins=0x204;		/* flag for clock installed */
char **clockname=0x0205;	/* pointer to pointer of name */

send("Change clock setup.\n\n");

if (O.RTC==NOCLOCK) send("There is currently NO clock code installed.\n");
 else printf("%s \nclock routine currently installed.\n",*clockname);

askyesno("\nIs a clock to be installed on this system\n",&O.RTC);

if (O.RTC)
  filename=getfile("Enter name of clock code file to install\n (any .CLK file)");

if (filename!=NULL)
	{
	FILE *fil;

	if ( !index(filename,'.') ) strcat(filename,".CLK");
	if ( (fil=open(filename,0))!=(FILE *)0)
		{
		loadclock(fil);
		close(fil);
		send("\n[Routine loaded]\n");
		}
	  else
		{
		send("\nFile not found, check directory for .CLK files.\n");
		if (*clkins==0) O.RTC=NOCLOCK;
		}
	}
  else send("\n[Current settings unchanged]\n");

}


loadclock(fil)
 FILE *fil;
{
read(fil,1);		/* skip to start of next record */
movmem(bufloc(fil),0x0204,128);
read(fil,1);		/* skip to start of next record */
movmem(bufloc(fil),0x0284,128);
read(fil,1);		/* skip to start of next record */
movmem(bufloc(fil),0x0304,128);
}


/*********************************
 * BYE stuff... if ask for nulls *
 *********************************/

byestuff()
{

send("Setup for BYE.\n\n");

printf("Current setting:\n\tBYE %s ask for NULLS.\n",
		O.ASKNULLS ? "DOES" : "DOES NOT" );

askyesno("Is BYE set to ask for NULLS\n when you login",&O.ASKNULLS);

}


/*********************************
 * ZCPR setup, WHEEL LOC/No ZCPR *
 *********************************/

zcprstuff()
{
send("Operating System setup.\n\n");

#ifndef MULTI_USER

printf("Currently setup%s to use ZCPR%s.\n",O.ZCPR ? "" : " NOT",O.ZCPR==3 ? "3" : O.ZCPR ? "(1 or 2)" : "(1,2 or 3)");

asknum("Enter the MAJOR version of ZCPR to be used\
\n (1,2 or 3), or 0 if ZCPR is not to be used",&O.ZCPR,3,CHAR);

if (O.ZCPR && O.ZCPR!=3)
	{
	printf("Wheel byte currently at %xH\n",O.SECURELOC);
	asknum("New location (IN HEX!)",&O.SECURELOC,0,HEX|INT);
	}

if (O.ZCPR==3)
	send("\nREMEMBER to configure the main BBS COM file with the ZCPR3 environment\
\ninstallation utility (Z3INS).\n");

#else

#ifndef MPM
  printf("Location of 4 char id string currently at %xH\n",O.id_loc);
  asknum("New location (IN HEX!)",&O.id_loc);
#endif

#endif
}


/************************************
 * Location change.. up to 80 chars *
 ************************************/

location()
{

send("Change Metal site location (sign-on msg).\n\n");

/* send(O.WHERE); send("\n");	*/

askstr("<-- Current name.\n\nEnter new location/phone (up to 80 chars)\n--> ",O.WHERE,80);
}


/*****************
 * Printer log ? *
 *****************/

printer()
{
send("Change printer log option.\n\n");
printf("Printer log is %s.\n",O.PRTLOG ? "ON" : "OFF");
askyesno("Log callers to printer",&O.PRTLOG);
}


/**************************
 * 25th status line stuff *
 **************************/

statline()
{
register int n;		/* temp loop variable */
char tbuf[MAXLINE];

send("Setup for 25th status line.\n\n");

printf("Currently 25th line %s setup.",O.STATUSLINE ? "IS" : "IS NOT");

if (O.STATUSLINE)
	{
	printf("\nOutput STATUS port=%xH\nOutput DATA port=%xH\nOutput status mask=%xH\n",O.OSTAT,O.ODATA,O.OSMASK);
	printf("Hex values to move cursor to 25th line:\n");
	for (n=0; O.TO25[n] && n<15; ++n)
		printf("%2xH ",O.TO25[n]);
	printf("\nHex values to return cursor to where it was before it got to the 25th line:\n");
	for (n=0; O.FROM25[n] && n<15; ++n)
		printf("%2xH ",O.FROM25[n]);
	}

askyesno("\n\nDo you have a 25th status line on your terminal",&O.STATUSLINE);

if (O.STATUSLINE)	/* only do this if he has one, else it doesn't apply */
	{
	send("\nNote: If you have a non-I/O mapped screen with 25th line capability\n\
you may enter the address of your BIOS output routine in place of the\n");
send("Output Data port below.  Make sure the Status port, and Status mask are set\nto Zero in this case!\n\n"); 
	asknum("Output Status port (IN HEX!)",&O.OSTAT,0,HEX|INT);
	asknum("Output Data port (IN HEX!)",&O.ODATA,0,HEX|INT);
	asknum("Output status ready mask (IN HEX!)",&O.OSMASK,255,HEX|CHAR);

	send("String to get TO 25th line. (Up to 15 chars. 0 for end of string).\n");
	for (n=0; n<15; n++)
		{
		sprintf(tbuf,"Hex Byte %2d (was %2xH): New value (IN HEX!)",
			n+1,O.TO25[n]);
		asknum(tbuf,&O.TO25[n],255,HEX|CHAR);
		if (!O.TO25[n]) break;	/* done */
		}
	O.TO25[15]='\0';	/* make sure it's terminated */

	send("String to get FROM 25th line. (Up to 15 chars. 0 for end of string).\n");
	for (n=0; n<15; n++)
		{
		sprintf(tbuf,"Hex Byte %2d (was %2xH): New value (IN HEX!)",
			n+1,O.FROM25[n]);
		asknum(tbuf,&O.FROM25[n],255,HEX|CHAR);
		if (!O.FROM25[n]) break;	/* done */
		}
	O.FROM25[15]='\0';	/* make sure it's terminated */
	}	/* block for status line check */

}	/* statusline */


/*******************************************************************
 * Message-base options..  MAXMSGS, MAXTOTMSGS, MLINES, MAXMSGLINE *
 *******************************************************************/

msgstuff()
{
send("Message-base options.\n\n");
printf("Currently:\n\tMaximum active messages allowed is %d\n\
\tMaximum TOTAL messages allowed\n\t\t(killed+active) is %d\n\
\tMaximum lines per message is %d\n\
\tMaximum message line length is %d\n\
\n",O.MAXMSGS,O.MAXTOTMSGS,O.MLINES,O.MAXMSGLINE);
printf("Initial default terminal width is %d\n\n",O.INITLENGTH);

while (1) {
 asknum("Maximum active messages allowed",&O.MAXMSGS,2000,INT);
 asknum("Maxumum TOTAL active and killed msgs allowed",&O.MAXTOTMSGS,3000,INT);
 if (O.MAXMSGS>O.MAXTOTMSGS)
	{
	send("\nMaximum TOTAL messages MUST BE >= Maximum active msgs!!!\n");
	continue;
	}
	else break;
   } 

asknum("Maxumum lines per message",&O.MLINES,MAXMLINES,INT);
asknum("Maximum characters per message line",&O.MAXMSGLINE,MAXLINE,CHAR);
asknum("Initial default terminal width",&O.INITLENGTH,MAXLINE,CHAR);
}


/*********************
 * Sysop name, etc.. *
 *********************/

sysopstuff()
{
send("Change sysop name/password.\n\n");
printf("Sysop's name is %s %s, and password is %s\n\n",
	O.SOFIRST,O.SOLAST,O.SOPASS);

sepstr=' ';
askstr("New Sysop name",O.SOFIRST,FNAMELEN);
sepstr='\0';
capstr(O.SOFIRST);
askstr("New Last name",O.SOLAST,LNAMELEN);
capstr(O.SOLAST);
askstr("New Password",O.SOPASS,PASSLEN);
upcase(O.SOPASS);
}


/* EOF  MECONFIG.C */


