/********************************************************************
 * Kill message overlay for Metal
 *
 * 	File: MEKILL.C
 *
 *  Copyright (c) 1984, 1985, 1986  Tim Gary
 *	       All Rights Reserved.
 *
 ********************************************************************
 *
 *  1.50xx 03/06/86  Update message function put here..
 *  1.50xx 03/04/86  Some things are slower again..
 *  1.40xx 02/28/86  msg[].reply gone.. makes things faster..
 *  1.40xx 01/26/86  Fixed for new formats of things..
 *  1.31a  10/13/85  Release version.
 *  1.31xx 08/17/85  New include files..
 *  1.20b  01/06/84  Message changes fixed, and unkill to public
 *		   disallowed for users who can't leave msgs.
 *  1.20a  11/04/84  Version change.
 *  1.10e  11/03/84  Fixed for new put/get counters routine.
 *  1.10e  11/02/84  Msg number=parent in dead msgs deleted.
 *  1.10e  10/31/84  Unkill added.
 *  1.10b  10/02/84  Novice users bug when 'r;100;102;300' and wants
 *		    to kill a message addressed to them.
 *  1.10a   9/01/84  Created from MS.C, for overlay version of metal.
 *
 ********************************************************************/

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"


ovmain(func,parm)
 int func;
 unsigned parm;
{
switch (func)
	{
	case KILL:
		return kill(parm);
	case UNKILL:
		return unkill(parm);
	default:
		send("\nUnknown Overlay function called for.\n");
		return ERROR;
	}
}


/*********************************************************
 * kill(delete) a message.... first ask for confirmation *
 *********************************************************/

kill(mn)
 register unsigned mn;
{
char msearch();
char temp[51],tpass,killok[3];
register unsigned msgnum;
register int a;
msg_record *mptr;	/* for summary/message file stuff */
unsigned t_num;
int n,lns;
int sreq=0;
int flag=FALSE;

#ifdef MULTI_USER
    mu_update();	/* if multi user, check for new messages */
#endif

if (!msgcount)
	{
	send("\nNo messages.\n");
	return;
	}

if (!mn){
	sprintf(buffer,"\nKill which msg (%u-%u)? ",fmsg,lmsg);
	ask(buffer,temp,50,UP);
	msgnum=atoi(temp);
	if (!(sreq=msearch(temp)) && !msgnum) return;
	} else msgnum=mn;

if ( (a=getindex(msgnum))==ERROR && msgnum && !sreq) {
			send("[Message NOT found]");
			return;
	   		}
if (a==ERROR) a=0;	/* fix for loop, and search request */

*killok='Y';	/* simulte always Yes to confirm.... for later */

do {	/* massive do loop */
   messages=open(MESSAGES,F_RW | F_UNLOCK);
   setarec(messages,msg[a].seek);	/* absolute seek to that pos */
   if ((lns=msgheader(messages,msgnum,3))==ERROR) break;
   if (!sreq && lns==0)
	{
	send("\n[Message private, or not found]");
	break;		/* say what happened, and leave */
	}
     else if (lns!=0 && !(user.flags&EXPERT))
		{
		send("\nConfirm (y/n)? ");
		if (mn) {
			*killok=toupper(getd());
			if (*killok=='Y') send("[yes]\n");
			  else send("[no]");
			}
		  else ask("",killok,2,UP);
		}

/* printf("\nlns=%d, msg[a].number=%u, a=%d, mn=%u, msgnum=%u, sreq=%d\n",lns,
	msg[a].number,a,mn,msgnum,sreq);	*/

   if (lns && msg[a].number)
	{
	if (*killok=='Y')
		{
		sprintf(temp,"\n[Deleting message #%u]",msg[a].number);
		if (send(temp)==ERROR || breakkey()) {
			printf("\n[*** Aborted ***]\n");
			break;	/* exit and close file */
			}
		mptr=bufloc(messages);
		mptr->parent=0;				/* mptr->reply=0; */
		if (mptr->status==PRIVMSG) privmsgs--;
		mptr->status=DEADMSG;
		setrrec(messages,-1);	/* backup */
		write(messages,0);
		close(messages);

		/* now to fix summary file */
		summary=open(SUMMARY,F_RW | F_UNLOCK);
		sprintf(bufloc(summary),"%5u",--msgcount);
		write(summary,1);
 
		mptr=bufloc(summary);
		setarec(summary,((msg[a].flags&SUMSEEK)<<5));  /* approx loc */

		do  n=read(summary,1);
	 	  while (n==128 && mptr->number!=msg[a].number);

		setrrec(summary,-1);	/* seek relative to current */
		mptr->parent=0;		/* mptr->reply=0; */
		mptr->status=DEADMSG;	/* will be used later	*/
		write(summary,0);	/* to kill message	*/
		close(summary);

/* The following loop is for special reply handling... it's be slower
 *	than killing msgs without replys since several added disk operations
 *	are needed for killing of messages with replies!
 */

		while (t_num=msg_reply(msg[a].number,msgnum))	/* while reply list */
			{
			msgnum=t_num;			/* find all replies */

			t_num=getindex(t_num);
			msg[t_num].parent=0;		/* clear for now  */
			updatemsg(t_num);		/* rewrite parent */
			}

		flag=TRUE;
		msg[a].parent=0;		/* msg[a].reply=0; */
		}  /* successfull *temp=='Y' */
	}  /* if lns.. */

	if (!sreq || mn) break;	/* stop here if no search request */

   messages=close(messages);	/* close this each time through	  */

   } while (++a<mindex);	/* for duration of search (if any) */

close(messages);

if (flag) pcounters(0);

}


/* Restore a killed message */

unkill(mn)
 register unsigned mn;
{
char msearch();
char temp[81],tpass,unkillok[3];
register unsigned msgnum;
register int a;
msg_record *mptr;	/* for summary/message file stuff */
int n,lns,newstat;
int sreq=0;
int flag=FALSE;

#ifdef MULTI_USER
    mu_update();	/* if multi user, check for new messages */
#endif

if (!mindex) {
	send("\No messages.\n");
	return;
	}

if (!mn){
	sprintf(buffer,"\nRestore which msg (%u-%u)? ",fmsg,lmsg);
	ask(buffer,temp,50,UP);
	msgnum=atoi(temp);
	if (!(sreq=msearch(temp)) && !msgnum) return;
	} else msgnum=mn;

if ( (a=getindex(msgnum))==ERROR && msgnum && !sreq) {
			send("[Message NOT found]");
			return;
	   		}
if (a==ERROR) a=0;	/* fix for loop, and search request */

*unkillok='Y';	/* simulte always Yes to confirm.... for later */

do {	/* massive do loop */
   messages=open(MESSAGES,F_RW | F_UNLOCK);
   setarec(messages,msg[a].seek);	/* absolute seek to that pos */
   if ((lns=msgheader(messages,msgnum,4))==ERROR) break;
   if (!sreq && lns==0)
	{
	send("\n[Message not addressed to, or by you]");
	break;		/* say what happened, and leave */
	}
     else if (lns!=0 && !(user.flags&EXPERT) )
		{
		send("\nRestore this message (y/n)? ");
		if (mn) {
			*unkillok=toupper(getd());
			if (*unkillok=='Y') send("[yes]\n");
			  else send("[no]");
			}
		  else ask("",unkillok,2,UP);
		}
   if (lns && msg[a].number)
	{
	if (*unkillok=='Y')
		{
		if (!(user.type_ptr->privflags & POSTMSG)) *temp='P';
		  else do {
		   sprintf(temp,"\n\nMessage %d - Restore as Normal or Private (n/p)? ",
msg[a].number);
		   ask(temp,temp,2,UP);
		   } while (*temp!='N' && *temp!='P');
		if (*temp=='P')
			{
			newstat=PRIVMSG;
			privmsgs++;
			}
		  else newstat=NORMMSG;
		sprintf(temp,"\n[Restoring message #%u]",msg[a].number);
		send(temp);
		mptr=bufloc(messages);
		mptr->parent=0;			/* mptr->reply=0; */
		mptr->status=newstat;
		setrrec(messages,-1);	/* backup */
		write(messages,0);
		close(messages);

		/* now to fix summary file */
		summary=open(SUMMARY,F_RW | F_UNLOCK);
		sprintf(bufloc(summary),"%5u",++msgcount);
		write(summary,1);
 
		mptr=bufloc(summary);
		do  n=read(summary,1);
	 	  while (n==128 && mptr->number!=msg[a].number);

		setrrec(summary,-1);	/* seek relative to current */
		mptr->parent=0;		/* mptr->reply=0; */
		mptr->status=newstat;	/* will be used later	*/
		write(summary,0);	/* to kill message	*/
		close(summary);

		flag=TRUE;
		msg[a].parent=0;		/* msg[a].reply=0; */
		}  /* successfull *unkillok=='Y' */
	}  /* if lns.. */
	if (!sreq || mn) break;	/* stop here if no search request */
   messages=close(messages);
   } while (++a<mindex);	/* for duration of search (if any) */
close(messages);

if (flag) pcounters(0);

}


/* update message and summary file with the new reply/parent of the msg at
 * the index (into msg array) passed to it 
 */

updatemsg(a)
 register unsigned a;
{
register msg_record *b;
int t;

messages=open(MESSAGES,F_RW | F_UNLOCK);
summary=open(SUMMARY,F_RW | F_UNLOCK);
b=bufloc(summary);
setrrec(summary,((msg[a].flags&SUMSEEK)<<5));	/* faster lookup */
if (!(getrec(summary))) setarec(summary,1);

do t=read(summary,1);		/* position to right place in sum. */
   while (t==128 && b->number!=msg[a].number);

if (t==128)
	{
	setrrec(summary,-1);		/* back up one record */
	setarec(messages,msg[a].seek);	/* seek to message loc */

	b->number=msg[a].number;
	b->seek=msg[a].seek;
	b->group=msg[a].group;
	b->parent=msg[a].parent;

	movmem(bufloc(summary),bufloc(messages),128);	/* as message hdr  */

	write(summary,0);
	close(summary);

	write(messages,0);
	close(messages);
	}
   else	{
	send("\n[No Summary record found!!  Skipping..]\n");
	close(summary);
	close(messages);
	}

}	/* update msg */


/* End of File */

