; 
; MECLKHDR.ASM
; 
; This file is for use with Metal and Z-Msg versions 1.31 and later.
;
; This file is used to adapt BYE3 clock routines (B3C-xxxx files)
; for use under the bbs.  To setup a new clock file:
;	* Customize (port addresses, etc...) the B3C-xxxxx.INS routine
;	  so that it's setup to work on your system (this may also
;	  be done imediately following inserting the code into this
;	  file).
;	* Make a copy of this file and give it a name that has
;	  something to do with the type of clock the routine will be
;	  for with .ASM type (eg. PIP MET-SS1.ASM=CLKHDR.ASM).
;	* Put the name (clock type name, like 'System Support 1') of the
;	  clock that you'll be installing where it tells you to below.
;	* Insert the B3C-xxxx.INS routine where it tells you to below.
;	* Save this file.
;	* Assemble the new version of this file using ASM or MAC
;	  (eg. ASM MET-SS1.AAZ  or MAC MET-SS1 $PZ SZ ).
;	* Use DDT, DCON or other debugger to load the file as follows:
;		DDT			; run ddt
;		IMET-SS1.HEX		; set file to read
;		R			; read file
;		M204,384,100		; copy to 100h
;		^C			; exit
;		SAVE 2 MET-SS1.CLK	; save it (Metal .CLK file)
;	NOTE: This routine must NOT be over 384 bytes (including this
;	      header file...)
;	* Run MECONFIG (or ZMCONFIG for Z-MSG) and select the clock
;	  installation in the main menu.  Enter the name of the newly
;	  created clock routine ( MET-SS1.CLK in the example ).
;	* Select the save perm. option from the main menu to save
;	  the routine in the main com file..
;
;	That should be it, you may use the .CLK routine for any Metal/Z-Msg
;	bbs (1.31 and higher) and new clock routines are always welcome!
;

NO	equ	0
YES	equ	NOT NO

RTC	equ	YES		; Signal clock to be used
CLOCK	equ	YES

; You may change the following if your clock routines require them..

BCD2BIN	equ	YES		; YES = include BCD->BIN routine "BCDBIN"
BIN2BCD	equ	NO		; YES = include BIN->BCD routine "BINBCD"

	org	0204h		; fixed location start
	db	0ffh		; clock installed flag
	dw	clkname		; ptr to name of clock installed (see below)
	dw	0000		; space for later...
rtcbuf:	db	0,0,0,19h,0,0,0	; hh,mm,ss,yy,yy,mm,dd
cchour:	db	0		; current hour	(these values aren't needed)
ccmin:	db	0		; current min   (by the bbs..)

	push	h		; save registers
	push	d
	push	b
	push	psw
	call	time
	pop	psw
	pop	b
	pop	d
	pop	h
	ret
;
;  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
; *** Change the text below to indicate the type of clock to be installed ***
;
clkname: db	'Put clock name here!!'
;
	 db	0	; Leave this alone
	 dw	0000	; for future use from bbs
;
;
;  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
; ***********************************************************************
; 	 + + +  Insert your B3C-xxxx.INS clock routine here  + + +
;
; ***********************************************************************
;  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
; These routines are from BYE.... 
;
;  BCD to Binary converter
;  -----------------------
;  This routine will convert an 8 bit BCD number (0-99) to binary.
;
; Two subroutines are availble if you set the "xxx2yyy" equates:
;	BINBCD - converts binary to BCD 	-- set BIN2BCD = YES
;	BCDBIN - converts BCD to binary		-- set BCD2BIN = YES
;
; Make sure you also store the full time and date in RTCBUF so your BBS
; and XMODEM can get the time and date.
;
;	Entry:	BCD number in A
;	Exit:   binary number in A
;
	 IF	RTC AND BCD2BIN	; Include this code only if we need it
BCDBIN:	PUSH	B
	PUSH	PSW		; Save the registers
	ANI	0FH		; Save the low nibble
	MOV	C,A		; In the C register
	POP	PSW		; Get original number back
	ANI	0F0H		; Get high nibble
	RRC
	RRC
	RRC
	RRC			; Rotate high nibble to low nibble
	MOV	B,A		; And put it in B as a x10 counter
	XRA	A		; Clear A
BCDBIN1:ADI	10		; Start x10 conversion
	DCR	B		; See if
	JNZ	BCDBIN1		; Conversion is complete
BCDBIN2:ADD	C		; Yes, add low nibble
	POP	B		; Restore BC
	RET			; And we're done
	 ENDIF	;RTC AND BCD2BIN
;
;
; BINBCD will convert a 0-99 binary number to 0-99 BCD number.
;	Entry:	A = number (0-99) BCD
;	Exit:   A = number (0-99) binary
;
	 IF	RTC AND BIN2BCD
BINBCD:	ADI	100		; Make it a 3 digit number
	PUSH	PSW
	XRA	A
	STA	BCDBUF+1	; Clear work buffer
	STA	BCDBUF+2
	POP	PSW
	LXI	H,BCDBUF	; Store ascii here
	CALL	DEC8		; Will convert to 100-199 ascii
	LDA	BCDBUF+1	; MSN of number
	SBI	'0'		; Subtract ascii
	RLC
	RLC
	RLC
	RLC			; Rotate to high nibble
	MOV	B,A		; Save in B
	LDA	BCDBUF+2	; LSN of number
	SUI	'0'		; Subtract ascii
	ORA	B		; Merge high nibble
	RET
;
BCDBUF:	DB	0,0,0		; Three byte buffer

;
;-----------------------------------------------------------------------
;
; DEC8 will convert an 8 bit binary number in A to 3 ASCII bytes.
; HL points to the MSB location where the ASCII bytes will be stored.
; Leading zeros are suppressed, so store spaces in your buffer before calling.
;
DEC8:	PUSH	B
	PUSH	D
	MVI	E,0		; Leading zero flag
	MVI	D,100
DEC81:	MVI	C,'0'-1
DEC82:	INR	C
	SUB	D		; 100 or 10
	JNC	DEC82		; Still +
	ADD	D		; Now add it back
	MOV	B,A		; Remainder
	MOV	A,C		; Get 100/10
	CPI	'1'		; Zero?
	JNC	DEC84		; Yes
	MOV	A,E		; Check flag
	ORA	A		; Reset?
	MOV	A,C		; Restore byte
	JZ	DEC85		; Leading zeros are skipped
DEC84:	MOV	M,A		; Store it in buffer pointed at by HL
	INX	H		; Increment storage location
	MVI	E,0FFH		; Set zero flag
DEC85:	MOV	A,D
	SUI	90		; 100 to 10
	MOV	D,A
	MOV	A,B		; Remainder
	JNC	DEC81		; Do it again
	ADI	'0'		; Make ascii
	MOV	M,A		; And store it
	POP	D
	POP	B
	RET

	 ENDIF			; RTC AND BIN2BCD

; That's it...

