/**************************************************************************
 *
 *	General define Header file for METAL/Z-MSG
 *
 *
 *	FILE: MEGEN.H
 *
 *		    Copyright (c) 1984,1985,1986  Tim Gary
 *			    All rights reserved.
 *
 **************************************************************************
 *
 * 1.50xx 04/07/86  Bit flags for privflags added...
 * 1.50xx 03/08/86  N_GROUPS..
 * 1.50xx 03/06/86  Defines for speedier summary file lookup (enter,kill).
 * 1.50xx 03/01/86  READ_xxx defines for read routines added, TOPICLEN+=15
 * 1.40xx 02/04/86  Added stuff for hashed user file method..
 * 1.40xx 02/01/86  NOTOS flag for ask() added..
 * 1.40xx 01/25/86  Added user.flags bit masks..
 * 1.40xx 01/19/86  Changes to filename handling, and msg/user structures
 * 1.31a  10/13/85  Release version.
 * 1.31xx 08/16/85  File created from hmh.h
 *
 *************************************************************************/

#define Z3			/* set this to be used */

/*****************
 * flag stuff... *
 *****************/

#define TRUE 1
#define FALSE 0
#define ON 1
#define OFF 0
#define YES 1
#define NO 0
#define NULL 0

#define MAXLINE	128	/* max line length */

#define PRINT	1	/* flag print operation */
#define NOPRINT	0	/* flag no print op	*/

/**************************
 * user parameter lengths *
 **************************/

#define NAMELEN 26	/* Maximum length of name is 26 chars (add 1 for \0) */
#define PASSLEN 8	/* up to 8 char password     */
#define CITYLEN	26	/* length of city/state info */

/*****************************
 * message base length stuff *
 *****************************/

#define TOPICLEN 40	/* 40 char topic for msgs (was 26) */

/*********************
 * ask routine flags *
 *********************/

#define UPLOW	0	/* no modification of input	*/
#define UP	1	/* convert input to upper case	*/
#define NOECHO	2	/* don't echo input		*/
#define NUMBER	4	/* number input as is comes in	*/
/* #define NOWAIT	8	*/	/* <<not implemented yet>>	*/
#define MSGLINE	16	/* flag for getl, to get max of MAXMSGLINE chars */
#define NOTOS	32	/* flag for NOT printing time on sys */

#define PRIVMSG	'p'	/* Private message stat char	*/
#define NORMMSG	'n'	/* Normal message status	*/
#define	DEADMSG	'x'	/* Dead/Killed message		*/

#define MAXMLINES 250	/* absolute maximum lines per msg */

#define SYSOP	'+'
#define	SPECIAL	's'	/* special user */
#define	NORMAL	'n'
#define NOCPM	'x'	/* no access to cpm	*/
#define TWIT	'X'	/* logout now !		*/

#define	EXPERT	0x03	/* 2 bit expert flag  (user.flags) */
#define	BELL	0x04	/* Bell on/off flag mask	*/
#define	READNEW	0x08	/* read new messages bitmask	*/

/* defines by user type.... */

#define	KILLFLAG 1	/* can this user type kill messages?	*/
#define	READPRIV 2	/* can user read private msgs?		*/
#define	POSTMSG  4	/* can user post messages?		*/
#define	ZCPRFLAG 8	/* does user have zcpr WHEEL privs?	*/
#define	POSTPRIV 16	/* can this user post private msgs?	*/

#define	READ_NEW 1	/* read new messages mode bit	*/
#define	READ_ONE 2	/* read only one message flag	*/
#define	READ_REV 4	/* read reverse direction bit	*/
#define	READ_TAG 8	/* read tagged messages		*/
#define	READ_MAI 0x10	/* read mail (messages to you)	*/
#define	READ_SEL 0x40	/* read selectively		*/
#define	READ_KIL 0x80	/* read dead messages too	*/
#define	READ_Q   0x100	/* read without prompts		*/

#define	SUMSEEK	0x1f	/* bottom 5 bits==mask for summary seek << 5 */
#define	TAGGED	0x40	/* char mask for msg->group flags and tags.. */
#define	MAIL	0x80	/* " """"""  set during initial message scan */

#define OSCOM	"OSNONE.COM"		/* these just get shoved into O */
#define BYECOM	"BYENONE.COM"		/* DON'T USE THESE MACROS ELSEWHERE */

#define	MOREHASH 1	/* bit mask for user.file_info.. more hash recs? */
#define	DEADUSER 2	/* bit mask for killed/not killed user */

#define	HFSIZE	1024	/* # of entries in hash table (*2 for file size) */
#define	HASHEMPTY (-2)	/* signal no user at hash index */

#define	N_GROUPS 32	/* max number of groups to begin with	*/

/*********************************
 * clock stuff, don't change!!!! *
 *********************************/

#define NOCLOCK  0	/* no clock board at all flag */

/* ZCPR3 file indexes.. */

#define ENV 0
#define NDR 1
#define RCP 2
#define FCP 3
#define IOP 4


/* EOF (MEGEN.H) */

