; A better patch for avoiding the floppy diskette timeout problems on ATs
; running xtals >15MHz...
;
; Change Diskette Parameter Table's motor startup delay
; by Glenn Connery, BNR, January 1986.
;
; The Diskette Parameter Table is pointed to by interrupt vector 1E at
; address 78H.  The table consists of 11 bytes (0..A) the last of which
; is the motor start up time, in 1/8ths of a second (normal clock).  By
; modifying this value you can correct for the faster crystal installed
; in your PC-AT.
;
; The normal value is 8 (is 1 second).  Running a 9MHz machine instead of
; a 6MHz machine means that 0C (or 1.5 seconds normal time) should be used.
;
; No warranty is made of the suitability of this program for any purpose
; nor any guarantee that it will function as specified.  Use it at your
; own risk.
;
code          segment   public
	      assume    cs:code,ds:nothing
	      org       100h
;
start:        mov       ax,0
	      mov       ds,ax
;
	      mov       bx,ds:[78h]     ;offset
	      mov       es,ds:[7Ah]     ;segment
;
; and finally, stuff the new delay period into the appropriate place in the
; table... this is the byte to change for different crystal speeds
;
	      mov       byte ptr es:[bx+0Ah],0CH
;
exit:         mov       al,0
	      mov       ah,4ch
	      int       21h
;
code          ends
	      end       start

