
/**********************************************************
 *							  *
 *                  TKO -- The Boxing Game		  *
 *							  *
 **********************************************************/

/*
Copyright (c) 1979  Mike Gancarz
Permission is hereby granted to freely distribute, copy, modify and otherwise
use this software for nonprofit purposes as long as this copyright appears
in the file and remains intact.
*/


#include "def.h"


/** boxer table **/
struct boxer{
	char	fname[NAMSIZ];	/* boxer's first name */
	char	mname[NAMSIZ];	/* boxer's middle name */
	char	lname[NAMSIZ];	/* boxer's last name */
	byte	rating;		/* overall rating */
	char	style;		/* style */
	byte	weight;		/* weight class */
	byte	cfb;		/* control factor against a boxer */
	byte	cfs;		/* control factor against a slugger */
	byte	hp;		/* hit power */
	byte	ki;		/* killer instinct */
	byte	kdr1;		/* knockdown rating 1 */
	byte	kdr2;		/* knockdown rating 2 */
	byte	kor;		/* knockout rating */
	byte	co;		/* cut opponent rating */
	byte	ch;		/* cut himself rating */
	byte	tko;		/* technical knockout rating */
	byte	agg;		/* aggressiveness rating */
	byte	end;		/* 10-round endurance */
	byte	def;		/* defense rating */
	byte	fi;		/* fighting inside strategy available */
	byte	fo;		/* fighting outside strategy available */
	byte	cu;		/* cover-up strategy available */
	byte	ko;		/* knockout strategy available */
	byte	pl;		/* punches landed upper limit */
	byte	pm;		/* punches missed upper limit */
	byte	cl;		/* clinching upper limit */
	byte	foul;		/* foul rating */
	byte	jab3;		/* 3-point jab upper limit */
	byte	jab2;		/* 2-point jab upper limit */
	byte	hook3;		/* 3-point hook upper limit */
	byte	hook2;		/* 2-point hook upper limit */
	byte	cross3;		/* 3-point cross upper limit */
	byte	cross2;		/* 2-point cross upper limit */
	byte	combo3;		/* 3-point combination upper limit */
	byte	combo2;		/* 2-point combination upper limit */
	byte	upper3;		/* 3-point uppercut upper limit */
	byte	icor;		/* in corner/on ropes adjustment factor */
} bx[] = {
	"Muhammad",	/* boxer's first name */
	"\0",		/* boxer's middle name */
	"Ali",		/* boxer's last name */
	12,		/* overall rating */
	'b',		/* style */
	1,		/* weight class */
	12,		/* control factor against a boxer */
	12,		/* control factor against a slugger */
	7,		/* hit power */
	6,		/* killer instinct */
	1,		/* knockdown rating 1 */
	0,		/* knockdown rating 2 */
	1,		/* knockout rating */
	7,		/* cut opponent rating */
	1,		/* cut himself rating */
	2,		/* technical knockout rating */
	6,		/* aggressiveness rating */
	110,		/* 10-round endurance */
	-6,		/* defense rating */
	1,		/* fighting inside strategy available */
	4,		/* fighting outside strategy available */
	2,		/* cover-up strategy available */
	2,		/* knockout strategy available */
	46,		/* punches landed upper limit */
	60,		/* punches missed upper limit */
	67,		/* clinching upper limit */
	0,		/* foul rating */
	19,		/* 3-point jab upper limit */
	24,		/* 2-point jab upper limit */
	33,		/* 3-point hook upper limit */
	35,		/* 2-point hook upper limit */
	44,		/* 3-point cross upper limit */
	46,		/* 2-point cross upper limit */
	64,		/* 3-point combination upper limit */
	69,		/* 2-point combination upper limit */
	78,		/* 3-point uppercut upper limit */
	0,		/* in corner/on ropes adjustment factor */

	"Vito",
	"\0",
	"Antuofermo",
	8,
	'e',
	3,
	10,
	10,
	8,
	7,
	3,
	2,
	2,
	5,
	6,
	3,
	8,
	80,
	2,
	2,
	1,
	2,
	3,
	39,
	62,
	70,
	1,
	5,
	13,
	21,
	33,
	41,
	53,
	61,
	73,
	76,
	2,

	"Art",
	"\0",
	"Aragon",
	7,
	'b',
	5,
	10,
	9,
	6,
	6,
	3,
	2,
	2,
	5,
	5,
	3,
	7,
	85,
	0,
	2,
	2,
	2,
	2,
	41,
	61,
	69,
	0,
	8,
	20,
	28,
	40,
	45,
	53,
	61,
	73,
	76,
	2,

	"Joey",
	"\0",
	"Archer",
	7,
	'b',
	3,
	9,
	10,
	6,
	4,
	3,
	2,
	2,
	6,
	3,
	3,
	7,
	85,
	-4,
	1,
	2,
	3,
	1,
	41,
	61,
	69,
	1,
	4,
	21,
	24,
	36,
	39,
	51,
	56,
	73,
	74,
	2,

	"Alexis",
	"\0",
	"Arguello",
	10,
	'e',
	8,
	11,
	10,
	9,
	8,
	3,
	2,
	2,
	6,
	3,
	2,
	9,
	90,
	2,
	2,
	2,
	2,
	3,
	41,
	63,
	70,
	1,
	14,
	17,
	30,
	33,
	47,
	50,
	64,
	67,
	76,
	2,

	"Henry",
	"\0",
	"Armstrong",
	11,
	's',
	5,
	10,
	11,
	9,
	9,
	3,
	1,
	1,
	6,
	4,
	2,
	10,
	100,
	0,
	2,
	2,
	2,
	3,
	39,
	61,
	69,
	1,
	8,
	10,
	24,
	28,
	42,
	46,
	60,
	63,
	77,
	0,

	"Mike",
	"\0",
	"Ayala",
	7,
	's',
	10,
	9,
	9,
	8,
	6,
	3,
	1,
	3,
	6,
	3,
	3,
	8,
	80,
	0,
	3,
	3,
	1,
	1,
	41,
	62,
	70,
	1,
	8,
	20,
	25,
	33,
	42,
	54,
	59,
	67,
	72,
	2,

	"Billy",
	"\0",
	"Backus",
	4,
	'e',
	4,
	8,
	7,
	7,
	6,
	3,
	3,
	4,
	5,
	6,
	3,
	8,
	80,
	2,
	2,
	1,
	2,
	2,
	37,
	61,
	69,
	1,
	4,
	22,
	23,
	29,
	34,
	51,
	52,
	58,
	63,
	2,

	"Buddy",
	"\0",
	"Baer",
	7,
	's',
	1,
	9,
	8,
	9,
	7,
	3,
	2,
	2,
	5,
	4,
	4,
	9,
	75,
	5,
	2,
	2,
	2,
	2,
	38,
	65,
	72,
	2,
	7,
	12,
	24,
	31,
	42,
	50,
	57,
	62,
	73,
	3,

	"Max",
	"\0",
	"Baer",
	9,
	's',
	1,
	9,
	11,
	10,
	8,
	2,
	3,
	2,
	6,
	3,
	3,
	8,
	90,
	0,
	2,
	3,
	1,
	3,
	39,
	65,
	71,
	1,
	7,
	12,
	23,
	30,
	45,
	56,
	67,
	74,
	78,
	3,

	"Carmen",
	"\0",
	"Basilio",
	9,
	'e',
	5,
	10,
	10,
	8,
	8,
	3,
	1,
	2,
	6,
	4,
	2,
	9,
	90,
	-2,
	3,
	2,
	2,
	2,
	41,
	61,
	69,
	1,
	12,
	19,
	26,
	31,
	42,
	50,
	57,
	62,
	73,
	1,

	"Wilfredo",
	"\0",
	"Benitez",
	10,
	'b',
	5,
	10,
	10,
	7,
	5,
	3,
	1,
	1,
	6,
	3,
	2,
	8,
	90,
	-4,
	2,
	4,
	2,
	2,
	43,
	60,
	68,
	0,
	11,
	27,
	32,
	40,
	45,
	53,
	61,
	73,
	76,
	1,

	"Willie",
	"\0",
	"Besmanoff",
	1,
	'b',
	1,
	7,
	7,
	5,
	3,
	7,
	3,
	5,
	4,
	6,
	4,
	6,
	75,
	4,
	1,
	3,
	2,
	0,
	38,
	63,
	70,
	1,
	0,
	24,
	24,
	40,
	40,
	48,
	48,
	72,
	72,
	3,

	"Jurgin",
	"\0",
	"Blin",
	4,
	'b',
	1,
	9,
	8,
	5,
	4,
	5,
	3,
	4,
	4,
	5,
	4,
	7,
	75,
	0,
	1,
	2,
	3,
	1,
	39,
	62,
	70,
	1,
	0,
	16,
	16,
	32,
	32,
	48,
	48,
	72,
	72,
	2,

	"Duane",
	"\0",
	"Bobick",
	4,
	's',
	1,
	8,
	8,
	8,
	6,
	6,
	3,
	5,
	5,
	6,
	4,
	8,
	80,
	6,
	2,
	2,
	1,
	3,
	38,
	63,
	70,
	1,
	3,
	7,
	15,
	27,
	32,
	40,
	48,
	60,
	68,
	3,

	"Oscar",
	"\0",
	"Bonavena",
	8,
	's',
	1,
	9,
	10,
	8,
	7,
	2,
	3,
	1,
	5,
	3,
	1,
	9,
	95,
	4,
	3,
	1,
	1,
	3,
	38,
	63,
	71,
	1,
	3,
	7,
	18,
	34,
	42,
	54,
	59,
	67,
	72,
	3,

	"Johnny",
	"\0",
	"Boudreaux",
	1,
	'b',
	1,
	7,
	7,
	5,
	4,
	6,
	4,
	5,
	4,
	6,
	4,
	6,
	75,
	4,
	1,
	3,
	2,
	1,
	38,
	62,
	69,
	0,
	0,
	16,
	16,
	32,
	32,
	48,
	48,
	72,
	72,
	2,

	"James",
	"\0",
	"Braddock",
	6,
	'b',
	1,
	9,
	8,
	6,
	4,
	2,
	2,
	2,
	5,
	4,
	3,
	7,
	85,
	-4,
	1,
	3,
	3,
	1,
	38,
	60,
	68,
	0,
	0,
	16,
	0,
	32,
	0,
	48,
	0,
	64,
	0,
	1,

	"Primo",
	"\0",
	"Carnera",
	3,
	's',
	1,
	8,
	8,
	7,
	5,
	6,
	4,
	5,
	4,
	5,
	2,
	7,
	85,
	5,
	2,
	2,
	1,
	2,
	37,
	64,
	72,
	2,
	4,
	21,
	24,
	36,
	39,
	51,
	52,
	58,
	63,
	4,

	"Rubin",
	"\0",
	"Carter",
	8,
	's',
	3,
	8,
	10,
	10,
	8,
	3,
	1,
	2,
	5,
	5,
	2,
	9,
	85,
	4,
	2,
	2,
	1,
	3,
	37,
	62,
	70,
	1,
	7,
	12,
	23,
	30,
	45,
	56,
	67,
	74,
	78,
	2,

	"Roberto",
	"\0",
	"Castanon",
	7,
	's',
	10,
	8,
	9,
	8,
	5,
	3,
	1,
	2,
	5,
	5,
	3,
	9,
	85,
	2,
	2,
	2,
	2,
	2,
	39,
	63,
	70,
	1,
	8,
	20,
	25,
	33,
	44,
	60,
	65,
	73,
	76,
	3,

	"Ruben",
	"\0",
	"Castillo",
	7,
	's',
	10,
	9,
	9,
	9,
	8,
	5,
	2,
	4,
	5,
	4,
	3,
	9,
	80,
	2,
	2,
	2,
	2,
	3,
	39,
	62,
	70,
	1,
	9,
	11,
	30,
	35,
	53,
	58,
	67,
	69,
	78,
	3,

	"Marcel",
	"\0",
	"Cerdan",
	11,
	'e',
	3,
	10,
	10,
	10,
	8,
	2,
	1,
	2,
	6,
	3,
	2,
	9,
	95,
	-2,
	2,
	3,
	1,
	3,
	43,
	61,
	69,
	2,
	14,
	17,
	30,
	33,
	47,
	50,
	64,
	67,
	76,
	2,

	"Antonio",
	"\0",
	"Cervantes",
	9,
	'e',
	6,
	10,
	11,
	8,
	8,
	2,
	1,
	1,
	6,
	3,
	2,
	9,
	90,
	-2,
	2,
	2,
	2,
	3,
	43,
	61,
	69,
	1,
	11,
	18,
	29,
	36,
	47,
	54,
	65,
	72,
	76,
	2,

	"Ezzard",
	"\0",
	"Charles",
	10,
	'b',
	1,
	10,
	10,
	7,
	6,
	3,
	2,
	5,
	7,
	2,
	2,
	9,
	110,
	-4,
	1,
	4,
	1,
	2,
	46,
	60,
	68,
	0,
	14,
	17,
	30,
	33,
	47,
	50,
	64,
	67,
	76,
	1,

	"George",
	"\0",
	"Chuvalo",
	8,
	's',
	1,
	8,
	9,
	8,
	8,
	1,
	0,
	1,
	4,
	6,
	1,
	9,
	110,
	6,
	2,
	2,
	1,
	2,
	37,
	62,
	70,
	2,
	5,
	22,
	25,
	37,
	41,
	58,
	59,
	65,
	68,
	3,

	"Don",
	"\0",
	"Cockell",
	4,
	'e',
	1,
	8,
	8,
	6,
	4,
	4,
	3,
	4,
	4,
	6,
	3,
	7,
	85,
	0,
	2,
	2,
	2,
	2,
	39,
	61,
	69,
	1,
	5,
	22,
	25,
	37,
	40,
	52,
	56,
	73,
	74,
	1,

	"Gerrie",
	"\0",
	"Coetzee",
	6,
	's',
	1,
	8,
	8,
	8,
	5,
	3,
	2,
	2,
	5,
	4,
	3,
	8,
	85,
	2,
	2,
	2,
	1,
	2,
	38,
	63,
	70,
	1,
	1,
	7,
	12,
	29,
	34,
	51,
	55,
	73,
	74,
	2,

	"Henry",
	"\0",
	"Cooper",
	6,
	's',
	1,
	8,
	8,
	8,
	7,
	3,
	2,
	4,
	5,
	9,
	3,
	8,
	85,
	2,
	2,
	2,
	2,
	2,
	41,
	61,
	69,
	1,
	3,
	7,
	18,
	34,
	42,
	54,
	59,
	67,
	72,
	2,

	"Jim",
	"\0",
	"Corbett",
	9,
	'b',
	1,
	10,
	11,
	5,
	5,
	2,
	1,
	2,
	6,
	4,
	3,
	7,
	100,
	-5,
	2,
	3,
	2,
	1,
	45,
	60,
	68,
	0,
	4,
	21,
	26,
	43,
	46,
	58,
	59,
	65,
	68,
	0,

	"Pipino",
	"\0",
	"Cuevas",
	10,
	's',
	5,
	10,
	10,
	10,
	9,
	2,
	1,
	2,
	6,
	3,
	2,
	10,
	85,
	4,
	2,
	2,
	2,
	3,
	38,
	61,
	69,
	0,
	9,
	11,
	29,
	34,
	52,
	57,
	66,
	68,
	78,
	2,

	"Bruce",
	"\0",
	"Curry",
	7,
	'e',
	6,
	9,
	9,
	8,
	7,
	3,
	1,
	2,
	5,
	3,
	2,
	8,
	80,
	0,
	2,
	2,
	2,
	3,
	39,
	61,
	69,
	1,
	8,
	20,
	28,
	40,
	48,
	60,
	65,
	73,
	76,
	1,

	"Terry",
	"\0",
	"Daniels",
	4,
	'b',
	1,
	8,
	7,
	6,
	4,
	6,
	1,
	4,
	5,
	5,
	2,
	7,
	85,
	4,
	2,
	2,
	3,
	1,
	39,
	61,
	69,
	1,
	0,
	16,
	16,
	32,
	32,
	48,
	48,
	64,
	64,
	2,

	"Les",
	"\0",
	"Darcy",
	11,
	'e',
	3,
	10,
	11,
	8,
	7,
	1,
	1,
	1,
	6,
	3,
	2,
	8,
	95,
	-4,
	2,
	3,
	2,
	2,
	43,
	61,
	69,
	1,
	11,
	18,
	29,
	37,
	49,
	56,
	63,
	68,
	75,
	2,

	"Alberto",
	"\0",
	"Davila",
	8,
	'e',
	9,
	10,
	9,
	7,
	4,
	2,
	1,
	3,
	6,
	3,
	2,
	8,
	85,
	-2,
	2,
	3,
	2,
	1,
	43,
	62,
	69,
	0,
	10,
	26,
	34,
	46,
	49,
	53,
	61,
	73,
	76,
	2,

	"Howard",
	"\0",
	"Davis",
	6,
	'b',
	7,
	9,
	9,
	5,
	4,
	4,
	1,
	2,
	5,
	4,
	3,
	7,
	80,
	-2,
	2,
	2,
	2,
	2,
	39,
	61,
	69,
	1,
	0,
	16,
	16,
	40,
	40,
	48,
	48,
	72,
	72,
	1,

	"Esteban",
	"\0",
	"DeJesus",
	8,
	'b',
	7,
	10,
	10,
	8,
	6,
	3,
	1,
	2,
	5,
	4,
	3,
	9,
	85,
	0,
	2,
	2,
	2,
	2,
	41,
	62,
	70,
	1,
	5,
	13,
	22,
	34,
	39,
	47,
	55,
	67,
	72,
	2,

	"Mike",
	"\0",
	"DeJohn",
	5,
	's',
	1,
	8,
	8,
	9,
	6,
	5,
	3,
	4,
	5,
	6,
	3,
	9,
	80,
	2,
	1,
	2,
	2,
	4,
	39,
	62,
	70,
	0,
	1,
	7,
	12,
	29,
	34,
	51,
	55,
	73,
	74,
	2,

	"Tony",
	"\0",
	"DeMarco",
	7,
	'e',
	5,
	10,
	9,
	8,
	7,
	4,
	2,
	4,
	6,
	4,
	3,
	9,
	85,
	0,
	3,
	2,
	2,
	2,
	41,
	61,
	69,
	1,
	3,
	7,
	12,
	20,
	28,
	40,
	48,
	60,
	68,
	2,

	"Jack",
	"\0",
	"Dempsey",
	12,
	's',
	1,
	11,
	11,
	9,
	10,
	2,
	0,
	2,
	6,
	3,
	1,
	10,
	100,
	0,
	2,
	2,
	2,
	3,
	41,
	63,
	70,
	2,
	9,
	11,
	25,
	28,
	46,
	52,
	61,
	63,
	77,
	1,

	"Joe",
	"\0",
	"Dundee",
	6,
	'b',
	5,
	9,
	8,
	6,
	3,
	3,
	1,
	2,
	5,
	4,
	3,
	7,
	85,
	-2,
	2,
	2,
	2,
	1,
	41,
	61,
	69,
	0,
	5,
	22,
	25,
	37,
	40,
	52,
	56,
	73,
	74,
	1,

	"Roberto",
	"\0",
	"Duran",
	11,
	's',
	7,
	10,
	12,
	10,
	10,
	2,
	1,
	1,
	6,
	4,
	2,
	10,
	90,
	2,
	2,
	2,
	2,
	3,
	41,
	62,
	70,
	2,
	5,
	7,
	20,
	23,
	41,
	46,
	60,
	63,
	77,
	2,

	"Frank",
	"\0",
	"Durate",
	5,
	'e',
	9,
	8,
	8,
	8,
	6,
	3,
	3,
	3,
	5,
	5,
	3,
	8,
	75,
	0,
	2,
	2,
	1,
	3,
	38,
	63,
	70,
	1,
	3,
	15,
	20,
	37,
	41,
	58,
	61,
	73,
	74,
	3,

	"Jimmy",
	"\0",
	"Ellis",
	7,
	'b',
	1,
	10,
	8,
	6,
	4,
	2,
	2,
	4,
	6,
	2,
	3,
	7,
	95,
	-4,
	2,
	2,
	2,
	1,
	43,
	61,
	68,
	0,
	5,
	22,
	25,
	37,
	40,
	52,
	56,
	73,
	74,
	1,

	"Alfredo",
	"\0",
	"Evangelista",
	4,
	's',
	1,
	8,
	8,
	7,
	4,
	3,
	3,
	3,
	4,
	6,
	4,
	7,
	80,
	4,
	2,
	1,
	2,
	3,
	38,
	61,
	69,
	0,
	3,
	15,
	20,
	37,
	41,
	58,
	61,
	73,
	74,
	2,

	"Jackie",
	"\0",
	"Fields",
	9,
	'e',
	5,
	10,
	10,
	8,
	6,
	2,
	1,
	1,
	6,
	4,
	2,
	8,
	90,
	2,
	2,
	2,
	2,
	2,
	41,
	61,
	69,
	0,
	5,
	13,
	22,
	34,
	39,
	47,
	55,
	67,
	72,
	2,

	"Bob",
	"\0",
	"Fitzsimmons",
	10,
	'e',
	1,
	10,
	10,
	9,
	8,
	3,
	1,
	2,
	6,
	4,
	2,
	8,
	95,
	-2,
	3,
	3,
	0,
	3,
	43,
	62,
	70,
	1,
	15,
	25,
	32,
	37,
	44,
	49,
	64,
	74,
	78,
	1,

	"Tiger",
	"\0",
	"Flowers",
	8,
	'b',
	3,
	10,
	10,
	7,
	6,
	3,
	2,
	4,
	6,
	3,
	3,
	8,
	90,
	-4,
	2,
	2,
	2,
	2,
	41,
	60,
	69,
	2,
	8,
	20,
	28,
	40,
	45,
	53,
	61,
	73,
	76,
	1,

	"Zora",
	"\0",
	"Folley",
	6,
	'b',
	1,
	10,
	9,
	6,
	4,
	3,
	3,
	4,
	6,
	4,
	3,
	7,
	80,
	0,
	2,
	3,
	2,
	1,
	41,
	61,
	69,
	0,
	3,
	15,
	18,
	30,
	33,
	45,
	51,
	74,
	75,
	2,

	"George",
	"\0",
	"Foreman",
	9,
	's',
	1,
	9,
	11,
	10,
	9,
	3,
	1,
	3,
	6,
	2,
	2,
	10,
	70,
	4,
	2,
	3,
	1,
	3,
	41,
	63,
	70,
	0,
	5,
	7,
	20,
	23,
	41,
	46,
	60,
	63,
	77,
	2,

	"Mac",
	"\0",
	"Foster",
	7,
	's',
	1,
	8,
	10,
	9,
	7,
	3,
	3,
	3,
	6,
	4,
	2,
	9,
	95,
	4,
	2,
	2,
	1,
	3,
	39,
	64,
	70,
	0,
	8,
	20,
	22,
	26,
	37,
	53,
	61,
	73,
	76,
	2,

	"Joe",
	"\0",
	"Frazier",
	11,
	's',
	1,
	11,
	10,
	10,
	10,
	3,
	1,
	2,
	6,
	2,
	1,
	10,
	100,
	2,
	4,
	1,
	1,
	4,
	45,
	61,
	69,
	0,
	5,
	6,
	24,
	29,
	43,
	46,
	64,
	69,
	78,
	2,

	"Tony",
	"\0",
	"Galento",
	8,
	's',
	1,
	9,
	10,
	9,
	8,
	3,
	3,
	3,
	5,
	5,
	3,
	9,
	90,
	4,
	2,
	2,
	2,
	2,
	39,
	63,
	71,
	2,
	7,
	12,
	28,
	38,
	49,
	56,
	63,
	68,
	75,
	3,

	"Andy",
	"\0",
	"Ganigan",
	8,
	's',
	7,
	9,
	9,
	9,
	7,
	3,
	2,
	2,
	5,
	4,
	3,
	9,
	85,
	2,
	2,
	1,
	2,
	3,
	38,
	62,
	70,
	1,
	7,
	12,
	24,
	31,
	42,
	50,
	57,
	62,
	73,
	2,

	"Joe",
	"\0",
	"Gans",
	10,
	'e',
	7,
	11,
	11,
	8,
	6,
	2,
	1,
	3,
	6,
	4,
	2,
	8,
	95,
	-5,
	2,
	3,
	2,
	2,
	45,
	60,
	68,
	0,
	8,
	20,
	29,
	41,
	46,
	54,
	59,
	67,
	72,
	1,

	"Kid",
	"\0",
	"Gavilan",
	10,
	'e',
	5,
	10,
	10,
	8,
	8,
	2,
	1,
	1,
	6,
	3,
	2,
	9,
	95,
	0,
	2,
	2,
	2,
	3,
	43,
	61,
	69,
	1,
	7,
	12,
	19,
	24,
	40,
	50,
	57,
	62,
	73,
	1,

	"Mike",
	"\0",
	"Gibbons",
	10,
	'b',
	5,
	11,
	10,
	7,
	5,
	2,
	1,
	1,
	6,
	3,
	2,
	7,
	90,
	-6,
	2,
	3,
	2,
	1,
	43,
	59,
	67,
	0,
	10,
	26,
	34,
	46,
	49,
	53,
	61,
	73,
	76,
	0,

	"Tommy",
	"\0",
	"Gibbons",
	9,
	'b',
	3,
	10,
	10,
	7,
	6,
	2,
	1,
	1,
	6,
	2,
	2,
	8,
	95,
	-5,
	2,
	3,
	3,
	1,
	41,
	59,
	68,
	1,
	8,
	20,
	28,
	40,
	43,
	47,
	55,
	67,
	72,
	1,

	"Wilfredo",
	"\0",
	"Gomez",
	11,
	's',
	9,
	11,
	11,
	10,
	8,
	2,
	1,
	2,
	5,
	3,
	2,
	9,
	85,
	2,
	2,
	2,
	2,
	3,
	43,
	63,
	70,
	0,
	13,
	18,
	32,
	35,
	49,
	52,
	66,
	69,
	78,
	2,

	"Billy",
	"\0",
	"Graham",
	10,
	'e',
	5,
	10,
	10,
	8,
	7,
	2,
	1,
	1,
	6,
	2,
	2,
	8,
	90,
	-2,
	3,
	2,
	2,
	2,
	41,
	61,
	69,
	1,
	5,
	13,
	21,
	33,
	41,
	53,
	61,
	73,
	76,
	1,

	"Clyde",
	"\0",
	"Gray",
	6,
	'e',
	5,
	9,
	8,
	8,
	7,
	5,
	3,
	4,
	5,
	5,
	3,
	9,
	85,
	2,
	2,
	2,
	1,
	3,
	39,
	63,
	70,
	1,
	8,
	20,
	27,
	40,
	43,
	53,
	59,
	73,
	75,
	2,

	"Rocky",
	"\0",
	"Graziano",
	9,
	's',
	3,
	10,
	9,
	10,
	10,
	3,
	1,
	2,
	6,
	4,
	2,
	10,
	90,
	4,
	2,
	2,
	1,
	3,
	39,
	63,
	70,
	1,
	7,
	12,
	23,
	30,
	45,
	55,
	63,
	68,
	75,
	2,

	"Harry",
	"\0",
	"Greb",
	12,
	'e',
	3,
	11,
	11,
	8,
	9,
	1,
	1,
	1,
	6,
	3,
	2,
	10,
	95,
	-2,
	3,
	3,
	2,
	1,
	39,
	60,
	69,
	2,
	8,
	10,
	24,
	28,
	42,
	46,
	60,
	63,
	77,
	2,

	"Dave",
	"\0",
	"Green",
	9,
	's',
	5,
	10,
	9,
	8,
	8,
	3,
	2,
	3,
	6,
	4,
	2,
	9,
	85,
	0,
	2,
	2,
	2,
	3,
	41,
	61,
	69,
	0,
	7,
	12,
	23,
	30,
	45,
	55,
	63,
	68,
	75,
	2,

	"Emile",
	"\0",
	"Griffith",
	10,
	'b',
	3,
	11,
	11,
	6,
	6,
	3,
	1,
	2,
	6,
	3,
	2,
	8,
	90,
	-4,
	3,
	2,
	2,
	2,
	45,
	60,
	68,
	1,
	8,
	20,
	28,
	40,
	42,
	46,
	57,
	73,
	76,
	1,

	"Marvin",
	"\0",
	"Hagler",
	9,
	's',
	3,
	9,
	10,
	9,
	8,
	3,
	1,
	2,
	6,
	4,
	3,
	9,
	85,
	0,
	3,
	1,
	1,
	3,
	39,
	62,
	70,
	1,
	7,
	12,
	27,
	37,
	52,
	62,
	69,
	74,
	78,
	2,

	"Thomas",
	"\0",
	"Hearns",
	8,
	's',
	5,
	9,
	9,
	10,
	8,
	2,
	1,
	2,
	5,
	2,
	2,
	8,
	90,
	0,
	2,
	2,
	1,
	3,
	38,
	62,
	69,
	0,
	11,
	18,
	29,
	36,
	44,
	49,
	60,
	67,
	74,
	1,

	"Larry",
	"\0",
	"Holmes",
	8,
	'b',
	1,
	10,
	10,
	7,
	7,
	2,
	1,
	2,
	5,
	3,
	3,
	8,
	90,
	-2,
	1,
	3,
	3,
	1,
	43,
	61,
	69,
	0,
	11,
	27,
	32,
	40,
	48,
	60,
	65,
	73,
	76,
	1,

	"Maurice",
	"\0",
	"Hope",
	8,
	'e',
	4,
	9,
	10,
	8,
	8,
	4,
	2,
	2,
	5,
	4,
	3,
	9,
	85,
	0,
	2,
	2,
	2,
	2,
	41,
	62,
	70,
	1,
	11,
	18,
	29,
	36,
	47,
	54,
	65,
	72,
	76,
	1,

	"Beau",
	"\0",
	"Jack",
	9,
	'e',
	7,
	10,
	10,
	8,
	7,
	3,
	1,
	3,
	6,
	3,
	2,
	8,
	90,
	2,
	2,
	2,
	2,
	2,
	41,
	61,
	69,
	0,
	8,
	20,
	28,
	40,
	45,
	53,
	61,
	73,
	76,
	2,

	"Peter",
	"\0",
	"Jackson",
	11,
	'b',
	1,
	10,
	11,
	8,
	7,
	1,
	1,
	1,
	5,
	4,
	2,
	9,
	110,
	-5,
	2,
	3,
	2,
	2,
	45,
	60,
	69,
	0,
	12,
	19,
	26,
	31,
	42,
	50,
	57,
	62,
	73,
	1,

	"Joe",
	"\0",
	"Jeannette",
	11,
	'e',
	1,
	11,
	10,
	9,
	6,
	3,
	0,
	2,
	5,
	2,
	1,
	9,
	110,
	-4,
	3,
	2,
	3,
	1,
	43,
	60,
	69,
	0,
	7,
	12,
	24,
	31,
	42,
	50,
	57,
	62,
	73,
	1,

	"James",
	"\0",
	"Jeffries",
	11,
	's',
	1,
	10,
	11,
	9,
	8,
	1,
	1,
	1,
	5,
	2,
	1,
	9,
	110,
	4,
	3,
	3,
	0,
	3,
	43,
	62,
	70,
	0,
	7,
	12,
	23,
	30,
	45,
	56,
	60,
	62,
	73,
	2,

	"Ingemar",
	"\0",
	"Johannsson",
	7,
	's',
	1,
	9,
	9,
	9,
	7,
	3,
	3,
	4,
	5,
	3,
	3,
	9,
	85,
	2,
	2,
	2,
	2,
	2,
	43,
	61,
	69,
	0,
	8,
	20,
	22,
	26,
	37,
	53,
	61,
	73,
	76,
	1,

	"Jack",
	"\0",
	"Johnson",
	12,
	'b',
	1,
	12,
	12,
	7,
	6,
	2,
	0,
	2,
	5,
	1,
	3,
	7,
	95,
	-6,
	2,
	4,
	2,
	1,
	46,
	58,
	68,
	0,
	11,
	18,
	25,
	30,
	41,
	48,
	52,
	54,
	69,
	0,

	"Leroy",
	"\0",
	"Jones",
	6,
	's',
	1,
	9,
	8,
	8,
	7,
	3,
	2,
	3,
	5,
	4,
	3,
	9,
	85,
	6,
	2,
	2,
	1,
	3,
	38,
	64,
	71,
	1,
	5,
	13,
	21,
	33,
	44,
	60,
	65,
	73,
	76,
	4,

	"Ayub",
	"\0",
	"Kalule",
	7,
	'e',
	4,
	9,
	10,
	8,
	8,
	3,
	2,
	2,
	5,
	5,
	3,
	9,
	85,
	2,
	3,
	2,
	1,
	2,
	41,
	62,
	69,
	1,
	5,
	13,
	22,
	34,
	39,
	47,
	52,
	60,
	68,
	2,

	"Stanley",
	"\0",
	"Ketchel",
	11,
	's',
	3,
	11,
	11,
	10,
	10,
	3,
	1,
	2,
	6,
	4,
	2,
	10,
	95,
	0,
	2,
	2,
	2,
	3,
	41,
	61,
	69,
	2,
	7,
	12,
	23,
	30,
	45,
	55,
	63,
	68,
	75,
	2,

	"Mashashi",
	"\0",
	"Kudo",
	7,
	'b',
	4,
	10,
	10,
	7,
	5,
	3,
	2,
	3,
	5,
	3,
	3,
	8,
	85,
	-2,
	2,
	2,
	2,
	1,
	41,
	60,
	70,
	0,
	4,
	21,
	24,
	36,
	40,
	57,
	60,
	72,
	74,
	1,

	"Jake",
	"\0",
	"LaMotta",
	10,
	's',
	3,
	10,
	10,
	7,
	9,
	1,
	1,
	2,
	6,
	4,
	2,
	10,
	90,
	0,
	3,
	2,
	1,
	3,
	41,
	60,
	69,
	2,
	3,
	5,
	20,
	31,
	42,
	49,
	53,
	55,
	70,
	2,

	"Scott",
	"\0",
	"LeDoux",
	3,
	'e',
	1,
	9,
	7,
	7,
	4,
	5,
	4,
	4,
	4,
	5,
	3,
	7,
	75,
	6,
	3,
	0,
	2,
	2,
	37,
	65,
	71,
	1,
	0,
	16,
	16,
	32,
	32,
	48,
	48,
	72,
	72,
	3,

	"Benny",
	"\0",
	"Leonard",
	11,
	'e',
	7,
	11,
	12,
	8,
	7,
	3,
	1,
	1,
	6,
	3,
	2,
	8,
	90,
	-5,
	3,
	3,
	2,
	1,
	45,
	60,
	69,
	1,
	7,
	12,
	23,
	30,
	41,
	48,
	63,
	74,
	76,
	0,

	"Sugar",
	"Ray",
	"Leonard",
	7,
	'b',
	5,
	10,
	9,
	7,
	4,
	3,
	2,
	2,
	5,
	2,
	3,
	7,
	85,
	-2,
	1,
	3,
	2,
	1,
	41,
	61,
	69,
	1,
	6,
	21,
	27,
	36,
	41,
	51,
	57,
	73,
	75,
	1,

	"Sonny",
	"\0",
	"Liston",
	11,
	's',
	1,
	9,
	11,
	10,
	10,
	2,
	1,
	2,
	5,
	4,
	1,
	10,
	110,
	4,
	3,
	3,
	0,
	3,
	41,
	61,
	69,
	0,
	9,
	11,
	29,
	34,
	52,
	57,
	71,
	74,
	79,
	2,

	"Brian",
	"\0",
	"London",
	2,
	'e',
	1,
	8,
	7,
	7,
	3,
	6,
	4,
	5,
	4,
	8,
	5,
	7,
	70,
	4,
	2,
	2,
	2,
	2,
	39,
	61,
	69,
	1,
	0,
	16,
	16,
	40,
	40,
	56,
	56,
	72,
	72,
	2,

	"Joe",
	"\0",
	"Louis",
	12,
	'e',
	1,
	10,
	12,
	10,
	10,
	3,
	0,
	1,
	6,
	2,
	2,
	10,
	100,
	0,
	3,
	3,
	1,
	3,
	46,
	62,
	70,
	0,
	13,
	18,
	32,
	35,
	49,
	52,
	66,
	69,
	78,
	2,

	"Rudi",
	"\0",
	"Lubbers",
	2,
	'e',
	1,
	8,
	7,
	7,
	3,
	4,
	3,
	4,
	4,
	6,
	3,
	7,
	80,
	5,
	2,
	0,
	2,
	2,
	38,
	64,
	71,
	1,
	0,
	16,
	16,
	32,
	32,
	48,
	48,
	64,
	64,
	3,

	"Eddie",
	"\0",
	"Machen",
	8,
	'e',
	1,
	10,
	10,
	8,
	6,
	2,
	1,
	2,
	3,
	4,
	3,
	8,
	85,
	0,
	2,
	2,
	3,
	2,
	43,
	61,
	69,
	0,
	8,
	20,
	25,
	33,
	42,
	54,
	59,
	67,
	72,
	1,

	"Rocky",
	"\0",
	"Marciano",
	12,
	's',
	1,
	10,
	12,
	10,
	10,
	2,
	0,
	1,
	6,
	5,
	1,
	10,
	110,
	4,
	3,
	2,
	1,
	3,
	43,
	62,
	70,
	1,
	9,
	11,
	25,
	28,
	46,
	52,
	66,
	69,
	78,
	2,

	"Jeff",
	"\0",
	"Merritt",
	6,
	's',
	1,
	8,
	8,
	10,
	8,
	5,
	2,
	5,
	5,
	4,
	3,
	9,
	70,
	5,
	2,
	2,
	1,
	2,
	41,
	63,
	70,
	0,
	7,
	12,
	27,
	37,
	52,
	62,
	69,
	74,
	76,
	3,

	"Larry",
	"\0",
	"Middleton",
	5,
	'b',
	1,
	9,
	10,
	6,
	4,
	5,
	4,
	4,
	5,
	4,
	4,
	7,
	80,
	-4,
	2,
	3,
	2,
	1,
	39,
	59,
	68,
	0,
	5,
	22,
	25,
	37,
	40,
	52,
	56,
	73,
	74,
	1,

	"Carlos",
	"\0",
	"Monzon",
	12,
	's',
	3,
	11,
	11,
	9,
	8,
	1,
	1,
	1,
	6,
	3,
	2,
	9,
	100,
	-2,
	2,
	3,
	1,
	3,
	41,
	61,
	69,
	0,
	9,
	11,
	29,
	34,
	52,
	57,
	66,
	68,
	78,
	2,

	"Archie",
	"\0",
	"Moore",
	8,
	'e',
	1,
	9,
	10,
	6,
	8,
	5,
	0,
	4,
	5,
	2,
	2,
	8,
	85,
	-4,
	3,
	2,
	3,
	2,
	43,
	60,
	69,
	0,
	7,
	12,
	24,
	31,
	42,
	50,
	57,
	62,
	73,
	1,

	"Armando",
	"\0",
	"Muniz",
	7,
	'e',
	5,
	8,
	9,
	7,
	6,
	3,
	1,
	2,
	5,
	4,
	2,
	9,
	85,
	5,
	3,
	2,
	2,
	2,
	37,
	61,
	69,
	1,
	3,
	7,
	15,
	27,
	35,
	47,
	55,
	67,
	72,
	1,

	"Randy",
	"\0",
	"Neuman",
	4,
	'b',
	1,
	9,
	8,
	6,
	3,
	4,
	3,
	4,
	5,
	6,
	3,
	7,
	80,
	4,
	1,
	2,
	2,
	2,
	39,
	63,
	70,
	1,
	5,
	22,
	27,
	44,
	48,
	66,
	67,
	73,
	74,
	2,

	"Ken",
	"\0",
	"Norton",
	7,
	'e',
	1,
	9,
	8,
	8,
	6,
	3,
	3,
	3,
	6,
	4,
	3,
	8,
	90,
	0,
	2,
	3,
	1,
	2,
	41,
	62,
	70,
	1,
	9,
	24,
	29,
	41,
	46,
	54,
	59,
	67,
	72,
	2,

	"Lou",
	"\0",
	"Nova",
	7,
	'e',
	1,
	9,
	10,
	8,
	6,
	4,
	3,
	4,
	6,
	5,
	2,
	9,
	85,
	2,
	3,
	3,
	1,
	1,
	39,
	61,
	69,
	0,
	5,
	13,
	22,
	34,
	42,
	54,
	59,
	67,
	72,
	2,

	"Ossie",
	"\0",
	"Ocasio",
	6,
	's',
	1,
	9,
	9,
	7,
	6,
	3,
	2,
	2,
	5,
	2,
	2,
	9,
	85,
	4,
	3,
	1,
	1,
	1,
	37,
	63,
	70,
	1,
	3,
	7,
	15,
	27,
	35,
	47,
	55,
	67,
	72,
	2,

	"Bobo",
	"\0",
	"Olson",
	4,
	'e',
	3,
	8,
	8,
	7,
	5,
	6,
	3,
	4,
	4,
	5,
	3,
	7,
	85,
	2,
	2,
	2,
	2,
	2,
	38,
	63,
	70,
	1,
	2,
	8,
	12,
	29,
	33,
	50,
	53,
	66,
	69,
	2,

	"Sean",
	"\0",
	"O'Grady",
	7,
	's',
	10,
	9,
	9,
	8,
	7,
	4,
	2,
	3,
	5,
	5,
	3,
	9,
	80,
	0,
	1,
	2,
	2,
	3,
	38,
	63,
	70,
	1,
	7,
	12,
	27,
	37,
	52,
	62,
	69,
	74,
	78,
	3,

	"Jose",
	"\0",
	"Palacios",
	4,
	's',
	5,
	7,
	8,
	8,
	6,
	6,
	1,
	4,
	5,
	5,
	3,
	8,
	80,
	6,
	3,
	1,
	1,
	3,
	37,
	64,
	71,
	1,
	0,
	8,
	8,
	32,
	32,
	48,
	48,
	64,
	64,
	3,

	"Carlos",
	"\0",
	"Palomino",
	9,
	'e',
	5,
	10,
	10,
	8,
	7,
	2,
	2,
	1,
	6,
	4,
	2,
	8,
	90,
	0,
	3,
	2,
	1,
	2,
	43,
	62,
	69,
	1,
	11,
	18,
	29,
	36,
	44,
	49,
	60,
	67,
	74,
	2,

	"Billy",
	"\0",
	"Papke",
	10,
	's',
	3,
	11,
	11,
	8,
	8,
	3,
	1,
	2,
	6,
	4,
	2,
	9,
	90,
	0,
	2,
	2,
	2,
	3,
	41,
	61,
	69,
	2,
	2,
	6,
	14,
	26,
	37,
	53,
	56,
	60,
	68,
	2,

	"Bob",
	"\0",
	"Pastor",
	7,
	'b',
	1,
	9,
	10,
	6,
	3,
	2,
	1,
	2,
	6,
	3,
	2,
	7,
	90,
	-2,
	1,
	3,
	3,
	1,
	43,
	59,
	68,
	0,
	5,
	22,
	25,
	37,
	40,
	52,
	56,
	73,
	74,
	2,

	"Floyd",
	"\0",
	"Patterson",
	7,
	'e',
	1,
	10,
	8,
	7,
	6,
	5,
	3,
	3,
	6,
	2,
	5,
	9,
	95,
	-2,
	2,
	2,
	2,
	2,
	43,
	61,
	69,
	0,
	5,
	13,
	21,
	33,
	41,
	53,
	61,
	73,
	76,
	2,

	"Jean",
	"Baptiste",
	"Piedvache",
	4,
	'b',
	6,
	8,
	8,
	6,
	3,
	4,
	2,
	3,
	4,
	5,
	3,
	7,
	75,
	0,
	1,
	2,
	3,
	1,
	38,
	63,
	70,
	0,
	0,
	24,
	24,
	40,
	40,
	56,
	56,
	72,
	72,
	3,

	"Jerry",
	"\0",
	"Quarry",
	7,
	'e',
	1,
	9,
	10,
	8,
	7,
	3,
	2,
	3,
	5,
	7,
	3,
	9,
	85,
	4,
	2,
	2,
	2,
	2,
	39,
	62,
	70,
	1,
	5,
	13,
	22,
	34,
	42,
	54,
	59,
	67,
	72,
	2,

	"Armando",
	"\0",
	"Ramos",
	6,
	'e',
	7,
	9,
	10,
	8,
	7,
	6,
	3,
	5,
	5,
	4,
	2,
	9,
	80,
	4,
	2,
	1,
	2,
	3,
	38,
	62,
	70,
	1,
	5,
	13,
	18,
	26,
	38,
	54,
	59,
	67,
	72,
	2,

	"Sugar",
	"Ray",
	"Robinson",
	12,
	'b',
	3,
	11,
	12,
	8,
	7,
	2,
	1,
	1,
	6,
	3,
	2,
	9,
	90,
	-4,
	2,
	3,
	2,
	2,
	45,
	58,
	68,
	1,
	14,
	17,
	31,
	34,
	48,
	51,
	69,
	75,
	79,
	1,

	"Sugar",
	"Ray",
	"Robinson",
	12,
	'e',
	5,
	11,
	11,
	8,
	7,
	2,
	1,
	1,
	6,
	2,
	2,
	8,
	90,
	-4,
	2,
	3,
	2,
	2,
	46,
	59,
	67,
	0,
	18,
	23,
	37,
	40,
	49,
	51,
	69,
	74,
	79,
	0,

	"Vincente",
	"\0",
	"Rondon",
	5,
	'e',
	2,
	9,
	8,
	7,
	5,
	5,
	2,
	4,
	5,
	4,
	3,
	6,
	80,
	0,
	2,
	2,
	2,
	2,
	38,
	64,
	70,
	0,
	4,
	21,
	24,
	35,
	38,
	50,
	53,
	65,
	68,
	2,

	"Maxie",
	"\0",
	"Rosenbloom",
	7,
	'b',
	2,
	11,
	11,
	5,
	3,
	3,
	2,
	2,
	5,
	3,
	3,
	7,
	85,
	-5,
	3,
	3,
	2,
	0,
	41,
	60,
	69,
	1,
	5,
	22,
	27,
	44,
	45,
	51,
	55,
	73,
	74,
	1,

	"Lauro",
	"\0",
	"Salas",
	4,
	'b',
	7,
	9,
	8,
	6,
	4,
	6,
	3,
	5,
	5,
	6,
	4,
	7,
	75,
	0,
	2,
	3,
	3,
	0,
	39,
	62,
	69,
	1,
	5,
	22,
	26,
	43,
	46,
	58,
	61,
	73,
	74,
	2,

	"Max",
	"\0",
	"Schmeling",
	10,
	'e',
	1,
	10,
	10,
	8,
	8,
	2,
	2,
	2,
	5,
	2,
	3,
	8,
	100,
	-4,
	2,
	3,
	2,
	2,
	45,
	59,
	68,
	0,
	7,
	12,
	19,
	24,
	40,
	50,
	61,
	68,
	75,
	2,

	"Jack",
	"\0",
	"Sharkey",
	9,
	'e',
	1,
	10,
	10,
	8,
	6,
	3,
	1,
	2,
	6,
	3,
	2,
	8,
	90,
	0,
	3,
	2,
	2,
	2,
	43,
	60,
	69,
	0,
	12,
	19,
	26,
	31,
	42,
	50,
	57,
	62,
	73,
	2,

	"Earnie",
	"\0",
	"Shavers",
	8,
	's',
	1,
	8,
	10,
	10,
	8,
	3,
	1,
	3,
	6,
	3,
	2,
	9,
	80,
	6,
	3,
	1,
	2,
	3,
	39,
	62,
	70,
	1,
	14,
	17,
	31,
	34,
	48,
	51,
	55,
	56,
	74,
	2,

	"Battling",
	"\0",
	"Siki",
	9,
	's',
	2,
	10,
	9,
	8,
	9,
	3,
	1,
	2,
	6,
	3,
	2,
	10,
	85,
	0,
	2,
	2,
	2,
	2,
	41,
	61,
	69,
	1,
	4,
	6,
	17,
	25,
	36,
	44,
	55,
	62,
	73,
	2,

	"Al",
	"\0",
	"Singer",
	7,
	'e',
	7,
	9,
	9,
	8,
	7,
	3,
	3,
	4,
	5,
	5,
	3,
	8,
	85,
	0,
	2,
	2,
	2,
	2,
	39,
	61,
	69,
	0,
	5,
	13,
	18,
	26,
	38,
	54,
	59,
	67,
	68,
	2,

	"Jimmy",
	"\0",
	"Slattery",
	7,
	'b',
	2,
	9,
	10,
	6,
	3,
	3,
	3,
	2,
	5,
	4,
	4,
	7,
	85,
	-5,
	1,
	4,
	3,
	0,
	43,
	59,
	67,
	1,
	6,
	29,
	32,
	44,
	47,
	59,
	62,
	74,
	75,
	1,

	"Howard",
	"\0",
	"Smith",
	4,
	's',
	1,
	8,
	8,
	8,
	6,
	5,
	3,
	4,
	4,
	6,
	3,
	8,
	75,
	6,
	1,
	1,
	2,
	3,
	37,
	63,
	71,
	1,
	1,
	7,
	12,
	29,
	33,
	50,
	53,
	65,
	68,
	4,

	"Jeff",
	"\0",
	"Smith",
	9,
	'e',
	3,
	10,
	10,
	8,
	7,
	2,
	1,
	1,
	5,
	3,
	2,
	8,
	95,
	-2,
	3,
	2,
	2,
	2,
	41,
	60,
	69,
	1,
	8,
	20,
	23,
	27,
	35,
	47,
	52,
	60,
	68,
	1,

	"Ryu",
	"\0",
	"Sorimachi",
	4,
	'e',
	5,
	9,
	7,
	7,
	6,
	6,
	3,
	4,
	5,
	6,
	3,
	8,
	85,
	4,
	2,
	1,
	3,
	1,
	37,
	62,
	69,
	1,
	4,
	21,
	25,
	37,
	38,
	44,
	50,
	73,
	74,
	3,

	"Leon",
	"\0",
	"Spinks",
	7,
	'e',
	1,
	9,
	9,
	8,
	6,
	2,
	2,
	2,
	5,
	4,
	2,
	9,
	90,
	4,
	2,
	2,
	2,
	2,
	37,
	61,
	69,
	0,
	3,
	15,
	19,
	36,
	39,
	51,
	55,
	72,
	74,
	1,

	"Michael",
	"\0",
	"Spinks",
	7,
	'e',
	2,
	8,
	9,
	8,
	7,
	3,
	1,
	2,
	5,
	4,
	3,
	8,
	85,
	4,
	2,
	2,
	2,
	2,
	39,
	61,
	69,
	1,
	8,
	20,
	25,
	33,
	41,
	53,
	61,
	73,
	76,
	2,

	"Young",
	"\0",
	"Stribling",
	8,
	'e',
	1,
	10,
	10,
	6,
	4,
	2,
	1,
	1,
	6,
	4,
	2,
	7,
	90,
	-5,
	2,
	2,
	3,
	2,
	45,
	60,
	68,
	2,
	3,
	15,
	18,
	29,
	32,
	44,
	48,
	65,
	68,
	1,

	"John",
	"L.",
	"Sullivan",
	7,
	's',
	1,
	7,
	10,
	9,
	10,
	5,
	1,
	4,
	6,
	4,
	2,
	10,
	100,
	6,
	2,
	2,
	1,
	4,
	39,
	62,
	71,
	2,
	2,
	6,
	14,
	26,
	37,
	53,
	56,
	60,
	68,
	3,

	"John",
	"\0",
	"Tate",
	6,
	's',
	1,
	8,
	9,
	8,
	5,
	4,
	2,
	3,
	5,
	4,
	2,
	8,
	80,
	4,
	3,
	1,
	2,
	2,
	39,
	62,
	71,
	1,
	4,
	8,
	24,
	40,
	50,
	56,
	61,
	64,
	74,
	3,

	"Lew",
	"\0",
	"Tendler",
	9,
	'b',
	7,
	10,
	10,
	8,
	7,
	2,
	1,
	1,
	5,
	3,
	2,
	8,
	90,
	-2,
	2,
	3,
	2,
	1,
	41,
	61,
	69,
	2,
	9,
	21,
	26,
	34,
	42,
	54,
	59,
	67,
	68,
	2,

	"Ernie",
	"\0",
	"Terrell",
	8,
	'e',
	1,
	10,
	9,
	8,
	6,
	2,
	3,
	3,
	5,
	3,
	3,
	7,
	85,
	-2,
	2,
	2,
	2,
	2,
	41,
	60,
	69,
	1,
	9,
	21,
	29,
	41,
	46,
	54,
	59,
	67,
	72,
	2,

	"Hector",
	"\0",
	"Thompson",
	2,
	's',
	6,
	8,
	7,
	6,
	4,
	6,
	4,
	6,
	5,
	7,
	4,
	7,
	80,
	4,
	1,
	2,
	3,
	1,
	37,
	63,
	70,
	1,
	5,
	22,
	27,
	44,
	45,
	51,
	55,
	73,
	74,
	2,

	"Dick",
	"\0",
	"Tiger",
	10,
	'e',
	3,
	10,
	11,
	9,
	8,
	3,
	1,
	2,
	6,
	3,
	2,
	9,
	95,
	2,
	3,
	3,
	1,
	2,
	43,
	62,
	70,
	0,
	4,
	6,
	17,
	25,
	36,
	44,
	55,
	62,
	73,
	2,

	"Gene",
	"\0",
	"Tunney",
	11,
	'b',
	1,
	11,
	11,
	6,
	7,
	1,
	0,
	1,
	6,
	4,
	2,
	8,
	95,
	-6,
	2,
	3,
	2,
	2,
	45,
	59,
	68,
	1,
	15,
	25,
	32,
	37,
	44,
	49,
	64,
	74,
	78,
	1,

	"Gene",
	"\0",
	"Tunney",
	11,
	'b',
	2,
	11,
	11,
	7,
	5,
	1,
	1,
	1,
	6,
	4,
	2,
	8,
	90,
	-6,
	2,
	2,
	2,
	2,
	43,
	60,
	68,
	0,
	18,
	24,
	33,
	35,
	49,
	52,
	66,
	69,
	78,
	1,

	"Mel",
	"\0",
	"Turnbow",
	1,
	's',
	1,
	7,
	7,
	7,
	6,
	7,
	4,
	7,
	4,
	7,
	5,
	7,
	60,
	6,
	2,
	0,
	2,
	2,
	34,
	65,
	72,
	1,
	0,
	16,
	16,
	32,
	32,
	56,
	56,
	72,
	72,
	4,

	"Joe",
	"\0",
	"Walcott",
	11,
	'e',
	5,
	11,
	11,
	9,
	8,
	3,
	1,
	2,
	6,
	3,
	2,
	9,
	95,
	0,
	3,
	2,
	3,
	1,
	41,
	61,
	70,
	2,
	7,
	12,
	24,
	31,
	42,
	50,
	57,
	62,
	73,
	1,

	"Mickey",
	"\0",
	"Walker",
	11,
	'e',
	3,
	11,
	11,
	9,
	9,
	3,
	0,
	2,
	6,
	3,
	2,
	10,
	95,
	0,
	3,
	2,
	2,
	2,
	41,
	61,
	69,
	1,
	14,
	17,
	26,
	30,
	43,
	46,
	60,
	64,
	78,
	2,

	"Jim",
	"\0",
	"Watt",
	8,
	'e',
	7,
	9,
	9,
	8,
	7,
	3,
	1,
	2,
	6,
	5,
	2,
	9,
	85,
	0,
	2,
	2,
	2,
	2,
	39,
	61,
	69,
	1,
	5,
	13,
	21,
	33,
	41,
	53,
	61,
	73,
	76,
	2,

	"Freddie",
	"\0",
	"Welsh",
	8,
	'b',
	7,
	10,
	10,
	6,
	4,
	3,
	1,
	1,
	5,
	4,
	2,
	7,
	90,
	-4,
	2,
	3,
	3,
	0,
	41,
	60,
	68,
	0,
	7,
	30,
	34,
	51,
	52,
	58,
	61,
	73,
	74,
	1,

	"Jimmy",
	"\0",
	"Young",
	7,
	'b',
	1,
	9,
	9,
	6,
	5,
	3,
	1,
	2,
	5,
	4,
	2,
	6,
	80,
	-2,
	1,
	3,
	3,
	1,
	39,
	60,
	68,
	1,
	6,
	29,
	32,
	44,
	47,
	59,
	62,
	74,
	75,
	2,

	"Tony",
	"\0",
	"Zale",
	10,
	's',
	3,
	10,
	10,
	8,
	8,
	3,
	1,
	2,
	6,
	3,
	1,
	9,
	100,
	-2,
	3,
	2,
	2,
	2,
	43,
	61,
	69,
	0,
	7,
	12,
	24,
	31,
	42,
	50,
	57,
	62,
	73,
	2,

	"Fritzie",
	"\0",
	"Zivic",
	10,
	'e',
	5,
	10,
	10,
	8,
	8,
	3,
	1,
	2,
	7,
	3,
	2,
	9,
	90,
	-2,
	2,
	2,
	2,
	2,
	41,
	61,
	69,
	2,
	11,
	18,
	29,
	36,
	47,
	54,
	65,
	72,
	76,
	1,

	"Rocky",	/* boxer's first name */
	"\0",		/* boxer's middle name */
	"Balboa",	/* boxer's last name */
	11,		/* overall rating */
	'e',		/* style */
	1,		/* weight class */
	10,		/* control factor against a boxer */
	11,		/* control factor against a slugger */
	10,		/* hit power */
	6,		/* killer instinct */
	2,		/* knockdown rating 1 */
	1,		/* knockdown rating 2 */
	1,		/* knockout rating */
	5,		/* cut opponent rating */
	4,		/* cut himself rating */
	1,		/* technical knockout rating */
	9,		/* aggressiveness rating */
	100,		/* 10-round endurance */
	0,		/* defense rating */
	4,		/* fighting inside strategy available */
	2,		/* fighting outside strategy available */
	0,		/* cover-up strategy available */
	3,		/* knockout strategy available */
	42,		/* punches landed upper limit */
	60,		/* punches missed upper limit */
	69,		/* clinching upper limit */
	1,		/* foul rating */
	12,		/* 3-point jab upper limit */
	15,		/* 2-point jab upper limit */
	30,		/* 3-point hook upper limit */
	35,		/* 2-point hook upper limit */
	51,		/* 3-point cross upper limit */
	56,		/* 2-point cross upper limit */
	60,		/* 3-point combination upper limit */
	63,		/* 2-point combination upper limit */
	78,		/* 3-point uppercut upper limit */
	1,		/* in corner/on ropes adjustment factor */

	"Apollo",	/* boxer's first name */
	"\0",		/* boxer's middle name */
	"Creed",	/* boxer's last name */
	9,		/* overall rating */
	'b',		/* style */
	1,		/* weight class */
	10,		/* control factor against a boxer */
	9,		/* control factor against a slugger */
	7,		/* hit power */
	6,		/* killer instinct */
	3,		/* knockdown rating 1 */
	2,		/* knockdown rating 2 */
	2,		/* knockout rating */
	6,		/* cut opponent rating */
	1,		/* cut himself rating */
	2,		/* technical knockout rating */
	8,		/* aggressiveness rating */
	95,		/* 10-round endurance */
	-4,		/* defense rating */
	1,		/* fighting inside strategy available */
	3,		/* fighting outside strategy available */
	2,		/* cover-up strategy available */
	0,		/* knockout strategy available */
	45,		/* punches landed upper limit */
	60,		/* punches missed upper limit */
	68,		/* clinching upper limit */
	0,		/* foul rating */
	16,		/* 3-point jab upper limit */
	28,		/* 2-point jab upper limit */
	31,		/* 3-point hook upper limit */
	37,		/* 2-point hook upper limit */
	46,		/* 3-point cross upper limit */
	53,		/* 2-point cross upper limit */
	64,		/* 3-point combination upper limit */
	69,		/* 2-point combination upper limit */
	72,		/* 3-point uppercut upper limit */
	0,		/* in corner/on ropes adjustment factor */

	"Mr.",		/* boxer's first name */
	"\0",		/* boxer's middle name */
	"T",		/* boxer's last name */
	10,		/* overall rating */
	's',		/* style */
	1,		/* weight class */
	9,		/* control factor against a boxer */
	11,		/* control factor against a slugger */
	10,		/* hit power */
	10,		/* killer instinct */
	3,		/* knockdown rating 1 */
	0,		/* knockdown rating 2 */
	1,		/* knockout rating */
	5,		/* cut opponent rating */
	1,		/* cut himself rating */
	1,		/* technical knockout rating */
	10,		/* aggressiveness rating */
	110,		/* 10-round endurance */
	2,		/* defense rating */
	3,		/* fighting inside strategy available */
	0,		/* fighting outside strategy available */
	2,		/* cover-up strategy available */
	3,		/* knockout strategy available */
	42,		/* punches landed upper limit */
	60,		/* punches missed upper limit */
	71,		/* clinching upper limit */
	2,		/* foul rating */
	5,		/* 3-point jab upper limit */
	8,		/* 2-point jab upper limit */
	33,		/* 3-point hook upper limit */
	39,		/* 2-point hook upper limit */
	48,		/* 3-point cross upper limit */
	52,		/* 2-point cross upper limit */
	55,		/* 3-point combination upper limit */
	62,		/* 2-point combination upper limit */
	74,		/* 3-point uppercut upper limit */
	1,		/* in corner/on ropes adjustment factor */

	"null",
	"\0",
	"null",
	0,
	'n',
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0
};
