REM ****************************************************************
REM *         NOTICE:  DO NOT REMOVE THIS NOTICE                   *
REM *         BLED - (C) 1985,1986 by Ken Goosens                  *
REM *       5020 Portsmouth Road, Fairfax, VA 22032                *
REM ****************************************************************
REM 8 April 1986 enhanced to add comments to bled merge
REM 13 April 1986 fixed bug so could embed source code in comments
REM 1 June 1986 Added buffered output & increased default max lines

REM *******************   DRIVER MODULE   **************************

DEFINT A-Z

NCNFG = 12
DIM CWRDS$(10),FROW(3),FCOL(3),FPROMPT$(3),FFLDSIZE(3),FFLDTYPE$(3),_
    FFLDVAL$(3),FHLP$(3),CROW(NCNFG),CCOL(NCNFG),CPRO$(NCNFG),_
    CFLDSIZE(NCNFG),CFLDTYPE$(NCNFG),CFLDVAL$(NCNFG),CHLP$(NCNFG)

GOSUB DOCMDLINE
GOSUB SETCONSTANTS
GOSUB GETCONFIG
LBLK = LEN(ENDBLK$)
TRANSBLK$ = SPACE$(LBLK)
OPEN "O",#4,WARNFILE$
MAXBTWLINES = VAL(MAXBTWLINES$)
REDIM MBUF$(MAXBTWLINES),TBUF$(MAXBTWLINES)
IF RUN.BATCH=0 THEN GOSUB ASKMERGE

WHILE ANS$ <> "Q"
   X = INSTR(CMVAL$,ANS$)
   IF X>1 THEN PRINT #4,"--[WARNINGS FOR FUNCTION ";ANS$;"]--
   FILE.COMPARE = (ANS$ = "F")
   ON INSTR (CMVAL$,ANS$) GOSUB SETCONFIG,FILECOMPARE,DOLINEMERGE,DOMERGE
   NWRITE = -1
   CALL WRITENEW (X$,NWRITE)
   CLOSE #3
   COLOR 7,0
   ANS$ = "Q"
   IF RUN.BATCH=0 THEN GOSUB ASKMERGE
WEND
CLOSE #4
      
END

REM  *********************    GOSUBS    **************************

ASKMERGE:

   LOCATE CMRO,1
   PRINT SPACE$(79)
   CALL GETCHAR (CMRO,CMCO,CMPRO$,CMVAL$,ANS$)

RETURN

REM  ****              PREPATORY SUBROUTINES                  ****
REM  **********  DOCMDLINE, SETCONSTANTS, GETCONFIG **************

REM -----------------------[ DOCMDLINE ]------------------------------------------------

DOCMDLINE:

REM PROCESSES COMMAND LINE ARGUMENTS FROM DOS

  RUN.BATCH  = INSTR(COMMAND$,"/B")
  LINE.MERGE = INSTR(COMMAND$,"/L")
  REG.MERGE  = INSTR(COMMAND$,"/M")
  FILE.COMPARE = INSTR(COMMAND$,"/F")

  IF (LINE.MERGE OR REG.MERGE OR FILE.COMPARE)  THEN_
  IF (LINE.MERGE AND REG.MERGE) OR (LINE.MERGE AND FILE.COMPARE) OR_
     (REG.MERGE AND FILE.COMPARE) THEN_
       X$="Can not use more than one of /F /L /M.":GOSUB DOABORT
  IF REG.MERGE THEN ANS$="M" ELSE_
     IF LINE.MERGE THEN ANS$="L" ELSE_
     IF FILE.COMPARE THEN ANS$="F" ELSE ANS$=""
  IF RUN.BATCH AND ANS$="" THEN_
     X$="Must specify one of /F /L /M to run batch.":GOSUB DOABORT
  CALL BRKWORDS (COMMAND$,CWRDS$())
  NON.OPT = 1
  WHILE INSTR(CWRDS$(NON.OPT),"/") > 0
    NON.OPT = NON.OPT + 1
  WEND
  IF RUN.BATCH AND CWRDS$(NON.OPT+2)="" THEN_
    X$="Must specify all three file arguments to run batch.":GOSUB DOABORT
  IF COMMAND$="" THEN CALL CREDITS

  IF CWRDS$(NON.OPT+4)<>"" THEN_
     CONFIGFILE$ = CWRDS$(NON.OPT+4)_
  ELSE_
     CONFIGFILE$ = "BLED.CFG"
  IF CWRDS$(NON.OPT+3)<>"" THEN_
     WARNFILE$ = CWRDS$(NON.OPT+3)_
  ELSE_
     WARNFILE$ = ""
  IF CWRDS$(NON.OPT+2)<>"" THEN_
     NEWFILE$=CWRDS$(NON.OPT+2) _
  ELSE_
     NEWFILE$="SC"
  IF CWRDS$(NON.OPT+1)<>"" THEN_
     BTCHCMDS$=CWRDS$(NON.OPT+1) _
  ELSE_
     BTCHCMDS$="SC"
  IF CWRDS$(NON.OPT)<>"" THEN_
     ORIGFILE$=CWRDS$(NON.OPT) _
  ELSE_
     ORIGFILE$="SC"

  LIMIT.RUN = INSTR(COMMAND$,"/T=")
  IF LIMIT.RUN=0 THEN RETURN
  LIMIT.RUN = LIMIT.RUN + 1
  LAST.CHAR = INSTR(LIMIT.RUN,COMMAND$,"/")
  IF LAST.CHAR=0 THEN LAST.CHAR = INSTR(LIMIT.RUN,COMMAND$," ")
  IF LAST.CHAR=0 THEN LAST.CHAR = LEN(COMMAND$)+1
  MAX.LL = VAL(MID$(COMMAND$,LIMIT.RUN+2,LAST.CHAR-LIMIT.RUN-2))
REM  PRINT "MAX.LL=";MAX.LL;" GOT FROM ";COMMAND$;" starting at ";LIMIT.RUN+2;_
REM    " and grabbing ";LAST.CHAR-LIMIT.RUN-2;" chars"
REM   PRINT "Last char=";last.char: input xx$
RETURN

DOABORT:

REM PREMATURELY TERMINATE WITH CENTERED ERROR MESSAGE AND HELP

  BEEP
  X = LEN(X$)+17
  IF X<78 THEN K = (78-X)/2 ELSE K=0
  PRINT SPACE$(K);X$;"  Aborting."
  CALL PRTHELP
  END

RETURN

REM --------------------------[ SETCONSTANTS ]-----------------------------

SETCONSTANTS:

REM ASSIGNS CONSTANTS USED IN PROGRAM

  HI.VALUE# = 99999999
  ONE = 1
  TWO = 2
  SEVENTYTWO = 72

  INSERTING$ = "* INSERTING new line(s)"
  DELETING$ = "* DELETING old line(s)"
  REPLACING$ = "* REPLACING old line(s) by new"
  FIRSTDIF$ = "* ------[ first line different ]------"

  CMPRO$ = "C)onfigure, F)ile compare, L)ine# merge, M)erge, Q)uit (C,L,M,Q): "
  CMRO = 21
  CMCO = 5
  CMVAL$ = "CFLMQ"

  EDPRO$ = "E)dit, R)un, Q)uit (E,R,Q): "
  EDRO = 23
  EDCO = 18
  EDVAL$= "ERQ"

  CFRO = 23
  CFCO = 20
  CFPRO$ = "E)dit, S)ave, Q)uit (E,S,Q): "
  CFVAL$ = "ESQ"

  THREE = 3
  FOUR = 4
  FROW(1) = 7
  FROW(2) = 9
  FROW(3) = 11
  FCOL(1) = 10
  FCOL(2) = 10
  FCOL(3) = 10
  FFLDSIZE(1) = 40
  FFLDSIZE(2) = 40
  FFLDSIZE(3) = 40
  FFLDTYPE$(1) = "S"
  FFLDTYPE$(2) = "S"
  FFLDTYPE$(3) = "S"

  FOR I = 1 TO NCNFG
    READ CROW(I),CCOL(I),CPRO$(I),CFLDSIZE(I),CFLDTYPE$(I),CFLDVAL$(I),CHLP$(I)
  NEXT

DATA  01,18,"BATCH LINE EDITOR - CONFIGURATION   Ver 1.4",00,L,   ,
DATA  03,12,"Source EXTENSION:"                  ,03,S,BAS,"Default extension for source file to be edited (e.g. BAS)"
DATA  04,12,"Merge EXTENSION:"                   ,03,S,MRG,"Default extension for file of changes to source (e.g. MRG)"
DATA  05,12,"Source remarks begin with:"         ,03,S,"'","Logically ignore rest of physical line beyond this"
DATA  06,12,"END OF BLOCK Phrase:"               ,20,S,ENDBLOCK,"Phrase used in BLED for the end of a block"
DATA  07,12,"Documentation BEGINS with: "        ,01,S,*  ,"Character that documentation lines begin with in BLED merge file"
DATA  08,12,"Alphanumeric LABELS END with:"      ,01,S,":","Character on end of an alphanumeric label (e.g. ':' in 'GETOUT:')"
DATA  09,12,"BLED COMMANDS BEGIN with:"          ,01,S,   ,"Character starting BLED commands in merge file (default none)"
DATA  10,12,"IGNORE CASE in Labels?"             ,01,S,Y  ,"Lower/upper case are same in labels (e.g. 'LABEL1' and 'label1')"
DATA  11,12,"CONTINUED LINES END with:"          ,01,S,_  ,"Character used to continue logical line onto next line"
DATA  12,12,"Write WARNINGS to:"                 ,30,S,WARNING,"File to write warning messages to"
DATA  13,12,"Max # physical lines btw line #'s:" ,04,N,400,"In file compare, max # physical lines between two line numbers"

RETURN

REM -------------------------[ GETCONFIG ]---------------------------------

GETCONFIG:

REM   GETS CONFIGURATION PARAMETERS

   ON ERROR GOTO NOCONFIG
   OPEN "I",#1,CONFIGFILE$

   READIN:
     ON ERROR GOTO 0
     LINE INPUT #1,DESOURCE$
     LINE INPUT #1,DEMERGES$
     LINE INPUT #1,REMCHAR$
     LINE INPUT #1,ENDBLK$
     LINE INPUT #1,DOCCHAR$
     LINE INPUT #1,END.LABEL$
     LINE INPUT #1,BLEDCMD$
     LINE INPUT #1,IGNORECASE$
     LINE INPUT #1,LINEON$
     LINE INPUT #1,X$
     IF WARNFILE$ = "" THEN WARNFILE$ = X$
     LINE INPUT #1,MAXBTWLINES$
     CLOSE #1
   RETURN

   USEDEFAULTS:
     ON ERROR GOTO 0
     DESOURCE$ = "BAS"
     DEMERGES$ = "MRG"
     REMCHAR$  = "'"
     ENDBLK$     = "ENDBLOCK"
     DOCCHAR$    = "*"
     END.LABEL$  = ":"
     BLEDCMD$    = ""
     IGNORECASE$ = "Y"
     LINEON$     = "_"
     IF WARNFILE$ = "" THEN WARNFILE$ = "WARNING"
     MAXBTWLINES$ = "400"
   RETURN

NOCONFIG:
   X$ = "Config file "+CONFIGFILE$+" missing/bad.  Using QuickBASIC defaults."
   CALL EXPLAIN(X$)
   RESUME USEDEFAULTS

REM -----------------------------------------------------------------------

REM *****                MAIN   ROUTINES                       ****
REM **********  SETCONFIG,FILECOMPARE,DOLINEMERGE,DOMERGE      ****

REM -----------------------[ SETCONFIG ]-----------------------------------

SETCONFIG:

REM      ALLOWS USER TO RECONFIGURE

   CFLDVAL$(2) = DESOURCE$
   CFLDVAL$(3) = DEMERGES$
   CFLDVAL$(4) = REMCHAR$
   CFLDVAL$(5) = ENDBLK$
   CFLDVAL$(6) = DOCCHAR$
   CFLDVAL$(7) = END.LABEL$
   CFLDVAL$(8) = BLEDCMD$
   CFLDVAL$(9) = IGNORECASE$
   CFLDVAL$(10)= LINEON$
   CFLDVAL$(11)= WARNFILE$
   OLDWARN$    = WARNFILE$
   CFLDVAL$(12)= MAXBTWLINES$

   CALL PRTSCRN (NCNFG,CROW(),CCOL(),CPRO$(),CFLDSIZE(),CFLDTYPE$(),_
                 CFLDVAL$(),CHLP$())
   CO=1:CALL QPRINT (SPACE$(79),FRO,CO)
   RESETCNFG:
     ANS$="E"
     CALL GETCHAR(CFRO,CFCO,CFPRO$,CFVAL$,ANS$)
     WHILE ANS$ = "E"
       CALL GETSCRN (NCNFG,CROW(),CCOL(),CPRO$(),CFLDSIZE(),CFLDTYPE$(),_
                 CFLDVAL$(),CHLP$())
       LOCATE CFRO,1:PRINT SPACE$(79)
       ANS$="":CALL GETCHAR (CFRO,CFCO,CFPRO$,CFVAL$,ANS$)
     WEND

 DESOURCE$ = CFLDVAL$(2)
 BTCHCMDS$ = CFLDVAL$(3)
 NEWFILE$  = CFLDVAL$(4)
 ENDBLK$   = CFLDVAL$(5)
 DOCCHAR$  = CFLDVAL$(6)
 END.LABEL$ = CFLDVAL$(7)
 BLEDCMD$   = CFLDVAL$(8)
 IGNORECASE$ = CFLDVAL$(9)
 LINEON$     = CFLDVAL$(10)
 WARNFILE$   = CFLDVAL$(11)

 IF WARNFILE$ <> OLDWARN$ THEN_
   CLOSE #4:OPEN "O",#4,WARNFILE$
 IF ANS$ = "Q" THEN RETURN  
 IF ANS$ <> "S" THEN RETURN
     OPEN "O",#1,CONFIGFILE$
     FOR I = 1 TO NCNFG
       IF CFLDTYPE$(I) <> "L" THEN PRINT #1,CFLDVAL$(I)
     NEXT
     CLOSE #1
     GOTO RESETCNFG

RETURN

REM -----------------------[ FILECOMPARE ]---------------------------------

FILECOMPARE:

REM     COMPARES TWO FILES, PRODUCES MERGE FILE FOR LINE MERGING

  FPROMPT$(1)= "OLD VERSION:"
  FPROMPT$(2)= "NEW VERSION:"
  FPROMPT$(3)= "MERGES (to OLD to make NEW):"
  FHLP$(1)   = "Old version of file that has been changed"
  FHLP$(2)   = "New, modified version of file"
  FHLP$(3)   = "Create file of changes to old version needed to make new version"
  TOPTITLE$ = "COMPARING FILES - Generating Merge"
  GOSUB GETFILES
  IF FANS$ = "Q" THEN RETURN

   HEADER$ = DOCCHAR$ + " ------------[ BLED merge (c) Ken Goosens ]-------------"
   CALL WRITENEW (HEADER$,NWRITE)
   HEADER$ = DOCCHAR$ + " Merge this against " + ORIGFILE$ + _
             " to produce " + BTCHCMDS$
   CALL WRITENEW (HEADER$,NWRITE)
   HEADER$ = DOCCHAR$ + "-------------[ Created "+DATE$+" "+TIME$+" ]------------"
   CALL WRITENEW (HEADER$,NWRITE)

   TRANS# = 0
   MAST#  = 0
   GOSUB READLINETRANS
   GOSUB READLINEOLD
   WHILE MAST# < HI.VALUE# OR TRANS# < HI.VALUE#
      IF TRANS# < MAST# THEN _
         CALL WRITENEW (INSERTING$,NWRITE) : _
         WHILE TRANS# < MAST#: _
           CALL WRITENEW (NUTRANS$,NWRITE) : _
           GOSUB READLINETRANS : _
         WEND
      IF MAST# < TRANS# THEN _
         CALL WRITENEW (DELETING$,NWRITE) : _
         WHILE MAST# < TRANS# : _
           PREV# = MAST# : _
           FW$ = MID$(STR$(MAST#),2) : _
           CALL WRITENEW (FW$,NWRITE) : _
           WHILE PREV# = MAST# : _
             GOSUB READLINEOLD : _
           WEND: _
         WEND
      IF TRANS# = MAST# AND MAST# < HI.VALUE# THEN_
         PREV# = TRANS#:J=0:_
         WHILE PREV# = TRANS# AND J<UBOUND(TBUF$):_
           J=J+1:TBUF$(J)=NUTRANS$:_
           GOSUB READLINETRANS:_
         WEND:_
         I=0:_
         WHILE PREV# = MAST# AND I<UBOUND(MBUF$):_
           I=I+1:MBUF$(I)=TRANS$:_
           GOSUB READLINEOLD:_
         WEND:_
         GOSUB CHKEXCEED:_
         IF M$<>"" THEN_
           N$="Logical line exceeds maximum physical lines.  Reconfigure":_
           CALL WRMIS (M$,N$)_
         ELSE_
           GOSUB CHKDIF:_
           IF ARE.DIFF THEN_
             CALL WRITENEW (REPLACING$,NWRITE) : _
             FOR I=1 TO K-1:CALL WRITENEW (TBUF$(I),NWRITE):NEXT :_
             GOSUB WRITEDIF : _
             FOR I=K TO MAX:CALL WRITENEW (TBUF$(I),NWRITE):NEXT :_
             FOR I=MAX+1 TO MAXMAX:CALL WRITENEW (TBUF$(I),NWRITE):NEXT
   WEND
   CLOSE #1,#2

RETURN

WRITEDIF:

   IF MAXMAX > 1 THEN _
      CALL WRITENEW (FIRSTDIF$,NWRITE)

   RETURN

CHKEXCEED:

   M$ = ""
   IF I=UBOUND(MBUF$) THEN_
     M$="[File "+ORIGFILE$+"]"_
   ELSE IF J = UBOUND(TBUF$) THEN_
     M$="[File "+BTCHCMDS$+"]"

RETURN

CHKDIF:


IF I = J THEN _
  ARE.DIFF = 0 _
ELSE _
  ARE.DIFF = -1
IF I<=J THEN _
   MAX = I _
ELSE _
   MAX = J 
MAXMAX = J
K=0
CHKAG:
  K=K+1:IF K<=MAX THEN IF TBUF$(K)=MBUF$(K) THEN GOTO CHKAG ELSE ARE.DIFF=-1
GETOUTCHKDIF:

RETURN

REM -----------------------[ DOLINEMERGE ]---------------------------------

DOLINEMERGE:

REM               MERGES BASED ON LINE NUMBER LABELS

  TOPTITLE$ = "MERGING using Line Number Labels"
  GOSUB STANDARDFILES
  IF FANS$ = "Q" THEN RETURN

   TRANS# = 0
   MAST#  = 0
   GOSUB READLINETRANS
   GOSUB READLINEOLD
   WHILE TRANS# < HI.VALUE# OR MAST# < HI.VALUE#
      WHILE TRANS# < MAST#
        PREV# = TRANS#
        WHILE PREV# = TRANS#
         IF ONLY.LINENO THEN_
           M$=TRANS$:_
           N$="Line number to be deleted not found.":_
           CALL WRMIS (M$,N$)_
         ELSE_
           CALL WRITENEW (NUTRANS$,NWRITE)
         GOSUB READLINETRANS
        WEND
      WEND
      WHILE MAST# < TRANS#
         PREV# = MAST#
         WHILE PREV# = MAST#
           CALL WRITENEW (TRANS$,NWRITE)
           GOSUB READLINEOLD
         WEND
      WEND
      IF TRANS# = MAST# AND MAST# < HI.VALUE# THEN_
         PREV# = TRANS#:_
         WHILE PREV# = TRANS#:_
           GOSUB CHKWRITE:_
           GOSUB READLINETRANS:_
         WEND:_
         WHILE PREV# = MAST#:_
           GOSUB READLINEOLD:_
         WEND
   WEND
   CLOSE #1,#2

RETURN

CHKWRITE:

IF NOT ONLY.LINENO THEN CALL WRITENEW (NUTRANS$,NWRITE)

RETURN

READLINEOLD:

   IF EOF(1) THEN_
     MAST# = HI.VALUE#_
   ELSE_
     GOSUB READOLDREC:_
     CALL FIRSTWORD (TRANS$,FW$):_
     IF FW$="" THEN PREV.MAST=0:RETURN_
     ELSE_
       CONTINUED.MAST = PREV.MAST:_
       CALL CHKCONT (TRANS$,LINEON$,REMCHAR$,PREV.MAST):_
       IF CONTINUED.MAST=0 THEN_
         CALL NUMERIC (FW$,NATNO):_
         IF NATNO THEN_
           PREV# = MAST#:_
           MAST# = VAL(FW$):_
           IF MAST# <= PREV# THEN_
             N$ = "Source line "+FW$+" occurs after line#"+STR$(PREV#):_
             CALL WRMIS (TRANS$,N$)_
           ELSE_
             LOG.LINES = LOG.LINES + 1 : _
             IF MAX.LL > 0 THEN _
                IF LOG.LINES > MAX.LL THEN _
                   COLOR 7,0 : _
                   PRINT : _
                   PRINT "              Sample MERGE created from ";MAX.LL;" lines":_
                   END
rem IF (MAST# >= 9000 AND MAST# <= 9600) THEN_
rem   X$="mast-out="+STR$(mast#)+" continued="+STR$(continued.mast)+" curr cont="+STR$(prev.mast)+" numeric="+STR$(natno):_
rem    Y$="":CALL WRMIS (X$,Y$)
RETURN

READLINETRANS:

    ONLY.LINENO = 0
    IF EOF(2) THEN_
      TRANS# = HI.VALUE#_
    ELSE_
      CALL GETTRANS (NUTRANS$,NTRANS):_
      CALL FIRSTWORD (NUTRANS$,FW$):_
      IF FW$="" THEN PREV.CONT=0:RETURN_
      ELSE IF LEFT$(FW$,1)=DOCCHAR$ THEN GOTO READLINETRANS_
             ELSE CONTINUED.LINE = PREV.CONT:_
                  CALL CHKCONT (NUTRANS$,LINEON$,REMCHAR$,PREV.CONT):_
                  IF CONTINUED.LINE=0 THEN_
                    CALL NUMERIC (FW$,NATNO):_
                    IF NATNO THEN_
                      PREV# = TRANS#:_
                      TRANS# = VAL(FW$):_
                      IF TRANS# <= PREV# THEN_
                        N$ = "Merge line# "+FW$+" occurs after line#"+STR$(PREV#):_
                        CALL WRMIS (NUTRANS$,N$)_
                      ELSE_
                        X$ = NUTRANS$:_
                        CALL TRIM (X$):_
                        IF X$ = FW$ THEN ONLY.LINENO = -1
RETURN

REM -----------------------[ DOMERGE ]-------------------------------------

DOMERGE:

REM        GENERAL BLED MERGE BASED ON BLOCK and BLOCK DISPOSITION

  TOPTITLE$ = "MERGING - General BLED"
  GOSUB STANDARDFILES
  IF FANS$ = "Q" THEN RETURN
  
  CALL GETNXTCMD (CMD$,DOCCHAR$,STBLKTYPE$,ENDBLKTYPE$,STDES.NO%,ENDDES.NO%,_
                 STTARGET$,ENDTARGET$,INCREMENT%,PTR%,CMD.TYPE$,_
                 INS.BLKTYPE$,FIXED.NO%,BLK.DISP$)
  
  WHILE CMD.TYPE$ <> ""
REM     PRINT "domerge: CMD$=";CMD$;" TYPE=";CMD.TYPE$;" INS BLKTYPE=";INS.BLKTYPE$
     IF CMD.TYPE$ = "I" THEN_
        IF INS.BLKTYPE$ = "L" THEN_
            GOSUB WRNTIMES_
        ELSE_
            GOSUB WRTBLOCK_
     ELSE_
        LINE.DISP$ = "K":_
        PTR.INCREMENT% = 1:_
        TARGET$ = STTARGET$:_
        BLOCK.TYPE$ = STBLKTYPE$:_
        DESIRED.PTR = STDES.NO%:_
        GOSUB ADVANCE:_
        LINE.DISP$ = BLK.DISP$:_
        BLOCK.TYPE$ = ENDBLKTYPE$:_
        DESIRED.PTR = ENDDES.NO%:_
        TARGET$ = ENDTARGET$:_
        PTR.INCREMENT% = INCREMENT%:_
        GOSUB ADVANCE
     CALL GETNXTCMD (CMD$,DOCCHAR$,STBLKTYPE$,ENDBLKTYPE$,STDES.NO%,ENDDES.NO%,_
                 STTARGET$,ENDTARGET$,INCREMENT%,PTR%,CMD.TYPE$,_
                 INS.BLKTYPE$,FIXED.NO%,BLK.DISP$)

  WEND
  CLOSE #1,#2
  
RETURN

ADVANCE:
      REM DECIDES HOW TO ADVANCE THROUGH OLD FILE
      REM PASS BLOCK.TYPE$

      IF BLOCK.TYPE$ = "L" THEN_
          GOSUB READTOLINE_
      ELSE IF BLOCK.TYPE$ = "S" THEN_
          GOSUB READTOSTRING_
      ELSE IF BLOCK.TYPE$ = "LABEL" OR BLOCK.TYPE$="LABEL#" THEN_
          GOSUB READTOLABEL_
      ELSE_
          M$="WARNING: ILLEGAL BLOCK TYPE ":_
          W$=BLOCK.TYPE$:_
          CALL WRMIS (M$,W$)
RETURN
         
READTOLINE:

   REM READS UPTO LINE DESIRED.PTR IN OLD

   WHILE PTR% < DESIRED.PTR AND NOT EOF(1)
      GOSUB READOLD
      PTR% = PTR% + PTR.INCREMENT%
      IF LINE.DISP$ = "K" THEN CALL WRITENEW (TRANS$,NWRITE)
   WEND
RETURN

READTOSTRING:

   REM READS UPTO A STRING IN OLD

   TRANS$ = TARGET$
   IF NOT EOF(1) THEN GOSUB READOLD
   WHILE INSTR(TRANS$,TARGET$) = 0
      PTR% = PTR% + 1
      IF LINE.DISP$ = "K" THEN CALL WRITENEW (TRANS$,NWRITE)
      IF NOT EOF(1) THEN_
         GOSUB READOLD_
      ELSE_
         M$ = "WARNING: STRING "+TARGET$+" NOT FOUND":_
         W$ = "":_
         CALL WRMIS (M$,W$):_
         TRANS$ = TARGET$
   WEND
   PREV.OLD$ = TRANS$

RETURN

READTOLABEL:

   REM READS UPTO A LABEL IN OLD
 
   IF IGNORECASE THEN CALL UPCASE (TARGET$)
   IF BLOCK.TYPE$ = "LABEL" AND RIGHT$(TARGET$,1) <> END.LABEL$ THEN_
      TARGET$ = TARGET$ + END.LABEL$
   IF NOT EOF(1) THEN_
      GOSUB READOLD:_
      GOSUB GETFIRSTWORD_
   ELSE_
      FIRST.WORD$ = TARGET$:_
      TRANS$ = ""
   WHILE FIRST.WORD$ <> TARGET$
      PTR% = PTR% + 1
      IF LINE.DISP$ = "K" THEN CALL WRITENEW (TRANS$,NWRITE)
      IF NOT EOF(1) THEN_
         GOSUB READOLD:_
         GOSUB GETFIRSTWORD_
      ELSE_
         M$ = "WARNING: LABEL "+TARGET$+" NOT FOUND":_
         W$ = "":_
         CALL WRMIS (M$,W$):_
         FIRST.WORD$ = TARGET$
   WEND
   PREV.OLD$ = TRANS$

RETURN

GETFIRSTWORD:

   CALL FIRSTWORD (TRANS$,FIRST.WORD$)
   IF IGNORECASE THEN CALL UPCASE (FIRST.WORD$)

RETURN

READOLD:

   REM FETCHES NEXT UNPROCESSED RECORD FROM OLD

   IF PTR% <= NREAD THEN_
      TRANS$ = PREV.OLD$_
   ELSE_
      GOSUB READOLDREC

RETURN

READOLDREC:

   LINE INPUT #1,TRANS$
   NREAD = NREAD+1
   LOCATE MROW,MCOL:PRINT NREAD;

RETURN

WRNTIMES:
   REM WRITES EXACTLY N RECORDS FROM TRANSACTION FILE

   WHILE FIXED.NO% > 0 AND NOT EOF(2)
      GOSUB READTRANS
      FIXED.NO% = FIXED.NO% - 1
      CALL WRITENEW (NUTRANS$,NWRITE)
   WEND
RETURN

READTRANS:

   REM FETCHES NEXT DATA (NON-COMMAND) RECORD FROM TRANSACTION FILE
   REM NOTE: WILL NOT SKIP OVER ANY LINES

   CALL GETTRANS (NUTRANS$,NTRANS)
   CALL FIRSTNB (NUTRANS$,ONE,BS):IF BS<1 THEN BS=1
   LSET TRANSBLK$ = MID$(NUTRANS$,BS,LBLK)
REM   print "RT BS=";BS;" trans=";trans$;" transblk=<";transblk$;"> endblk=<";endblk$;">"

RETURN

WRTBLOCK:

   REM INSERT ROUTINE WHEN BLOCK

   IF NOT EOF(2) THEN GOSUB READTRANS
   WHILE TRANSBLK$ <> ENDBLK$ AND NOT EOF(2)
      CALL WRITENEW (NUTRANS$,NWRITE)
      GOSUB READTRANS
   WEND

RETURN

REM --------------------[ SHARED ROUTINES ]-----------------------------

GETFILES:

REM PROMPTS FOR 3 FILE NAMES NEEDED

   GOSUB CHKEXTENSIONS
   FFLDVAL$(1) = ORIGFILE$
   FFLDVAL$(2) = BTCHCMDS$
   FFLDVAL$(3) = NEWFILE$
   CALL PRTSCRN (THREE,FROW(),FCOL(),FPROMPT$(),FFLDSIZE(),FFLDTYPE$(),_
                 FFLDVAL$(),FHLP$())
   CALL CENTERBEG (TOPTITLE$,SEVENTYTWO,BEG)
   CALL QPRINT (TOPTITLE$,FOUR,BEG)
   IF RUN.BATCH THEN FANS$="R":GOTO GOTFILES

     CO=1:CALL QPRINT (SPACE$(79),FRO,CO)
     FANS$="E"
     CALL GETCHAR(EDRO,EDCO,EDPRO$,EDVAL$,FANS$)
     WHILE FANS$ = "E"
       CALL GETSCRN (THREE,FROW(),FCOL(),FPROMPT$(),FFLDSIZE(),FFLDTYPE$(),_
               FFLDVAL$(),FHLP$())
       LOCATE EDRO,1:PRINT SPACE$(79)
       FANS$="":CALL GETCHAR (EDRO,EDCO,EDPRO$,EDVAL$,FANS$)
     WEND

   GOTFILES:  
   IF FANS$<>"Q" THEN_
     GOSUB PREPARECOUNTS:_
     ORIGFILE$ = FFLDVAL$(1):_
     BTCHCMDS$ = FFLDVAL$(2):_
     NEWFILE$  = FFLDVAL$(3):_
     GOSUB OPENFILES:_
     PRINT #4,"--[USING FILES ";ORIGFILE$;" ";BTCHCMDS$;" ";NEWFILE$;"]--"

RETURN

CHKEXTENSIONS:

   IF INSTR(ORIGFILE$,".")=0 THEN ORIGFILE$=ORIGFILE$+"."+DESOURCE$
   IF INSTR(BTCHCMDS$,".")=0 THEN_
     IF FILE.COMPARE THEN_
       BTCHCMDS$=BTCHCMDS$+"."+DESOURCE$_
     ELSE_
       BTCHCMDS$=BTCHCMDS$+"."+DEMERGES$
   IF INSTR(NEWFILE$,".")=0 THEN_
     IF FILE.COMPARE THEN_
       NEWFILE$=NEWFILE$+"."+DEMERGES$_
     ELSE_
       NEWFILE$=NEWFILE$+"."+DESOURCE$

RETURN

PREPARECOUNTS:

  COLOR 0,7
  LOCATE 24,1
  PRINT SPACE$(79);
  LOCATE 24,04:PRINT "SOURCE:";
  LOCATE 24,23:PRINT "CHANGES:";
  LOCATE 24,42:PRINT "NEW:";
  LOCATE 24,60:PRINT "WARNINGS:";

  TROW = 24
  TCOL = 31
  WROW = 24
  WCOL = 46
  MROW = 24
  MCOL = 11
  WROW = 24
  WCOL = 69

RETURN

STANDARDFILES:

  FHLP$(1) = "Text file to be edited (e.g. source code in TEST.BAS)"
  FHLP$(2) = "Merges (edits, changes) to be applied (e.g. TEST.MRG)"
  FHLP$(3) = "Save changes made in this file (e.g. old + merges -> TESTNEW.BAS)"
  FPROMPT$(1)= "SOURCE FILE:"
  FPROMPT$(2)= " MERGE FILE:"
  FPROMPT$(3)= "   NEW FILE:"
  GOSUB GETFILES

RETURN

OPENFILES:

  ON ERROR GOTO ERROPEN
  FF$ = ORIGFILE$
  OPEN "I",#1,FF$
  FF$ = BTCHCMDS$
  OPEN "I",#2,FF$
  FF$ = NEWFILE$
  OPEN "O",#3,FF$
  ON ERROR GOTO 0

  NREAD = 0
  NWRITE = 0
  NTRANS = 0
  PTR% = 1

RETURN

ERROPEN:
   X$ = "Error"+STR$(ERR)+" opening file "+FF$
   CALL EXPLAIN(X$)
   FLDSIZ = 30
   RO = 23:CO = 1:CALL QPRINT (SPACE$(79),RO,CO)
   CO=13:PROMPT$ = "Enter file name (<rtn> quits): "
   FFF$ = ""
   CALL GETSTR (RO,CO,PROMPT$,FLDSIZ,FFF$)
   IF FFF$ = "" THEN RESUME QUITMERGE ELSE FF$=FFF$:RESUME
QUITMERGE: FANS$="Q":RETURN

REM *****************   SHARED CALLED SUBROUTINES   *****************

SUB WRITENEW (NEWOUT$,NWRITE%) STATIC

REM WRITES NEWOUT$ TO NEW FILE

   DEFINT A-Z
   DIM OBUF$(100)
   IF NWRITE% < 0 THEN _
     FOR I=1 TO NUM.IN.BUF: _
       PRINT #3,OBUF$(I):_
     NEXT:_
     NUM.IN.BUF = 0:_
     EXIT SUB
   IF NUM.IN.BUF = 100 THEN _
     FOR I=1 TO 100:_
       PRINT #3,OBUF$(I):_ 
     NEXT:_
     NUM.IN.BUF = 0
   NUM.IN.BUF = NUM.IN.BUF + 1
   OBUF$(NUM.IN.BUF) = NEWOUT$
   NWRITE% = NWRITE% + 1
   LOCATE 24,46:PRINT NWRITE;

END SUB

SUB CHKCONT (STRNG$,LINEON$,REMCHAR$,CONTINUED%) STATIC

REM CHECKS WHETHER LINE STRNG$ CONTINUES LOGICALLY TO NEXT LINE

DEFINT A-Z
rem IF DEB=0 THEN DEB = INSTR(STRNG$,"9150 IF")
rem IF DEB>0 THEN IF INSTR(STRNG$,"9510 US") THEN DEB = 0
CONTINUED%=0
ONE = 1
BS = 1
LS = LEN(STRNG$)
LCO = INSTR(STRNG$,LINEON$)
IF LCO=0 THEN GOTO GETOUTCHKCONT
  CHKREM:
    X = INSTR(BS,STRNG$,REMCHAR$)
    IF X=0 THEN_
       X$=STRNG$:GOTO ALLSTRNG_
    ELSE_
       CALL FIRSTNB (STRNG$,ONE,XX):_
       IF X=XX THEN GOTO GETOUTCHKCONT
    CALL INQUOTES (STRNG$,X,INQUO)
    IF INQUO>0 THEN BS=INQUO+1:IF BS<=LS THEN GOTO CHKREM
    X$ = LEFT$(STRNG$,X-1)
  ALLSTRNG:
    CALL ENDNB (X$,ES)
    CONTINUED% = (MID$(X$,ES,1) = LINEON$)
REM    IF CONTINUED% <> 0 THEN PRINT "es=";es;" checking char <";MID$(X$,ES,1);">  CONT?=";CONTINUED%
GETOUTCHKCONT:
rem IF DEB>0 THEN_
rem   PRINT "CONT?=";CONTINUED%;" for >";STRNG$;"<":_
rem   PRINT "LCO=";LCO;" REM POS =";X;" INQUO=";INQUO;" BS= ";BS;" ES=";ES;:INPUT XX$:PRINT
END SUB

SUB INQUOTES (STRNG$,BS%,INQUO%) STATIC

REM CHECKS WHETHER CHARACTER AT POSITION BS% IN STRNG$
REM        IS INSIDE A PAIR OF QUOTES.  RETURNS POSITION OF RIGHT QUOTE
REM        IF INSIDE, 0 IF NOT INSIDE

DEFINT A-Z
QUOTE$=CHR$(34)
BEG = 1
INQUO% = 0
CHKQAGAIN:
  FQUO = INSTR(BEG,STRNG$,QUOTE$)
  IF FQUO=0 THEN GOTO GETOUTINQUOTES
  IF BS%<=FQUO THEN GOTO GETOUTINQUOTES
  SQUO = INSTR(FQUO+1,STRNG$,QUOTE$)
  IF SQUO=0 THEN GOTO GETOUTINQUOTES
  IF BS% < SQUO THEN_
    INQUO%=SQUO:GOTO GETOUTINQUOTES
  BEG = SQUO+1
GOTO CHKQAGAIN
  
GETOUTINQUOTES:
REM PRINT "INQUOTES: LOOKING AT POS ";BS%;"<";MID$(STRNG$,BS%,1);"> SENDING INQUO=";INQUO%
END SUB

