           TITLE     'Wolfware Sample Program','Key Reassignment'

;-------------------------------------------------------;
;               DOS 2.0 Key Reassignment                ;
;                                                       ;
; Reassign any string to any key via DOS 2.0.  The      ;
; ANSI.SYS device driver must be included into the      ;
; operating system (see your DOS manual).  Once         ;
; assembled, to reassign a key, type:                   ;
;                                                       ;
; KEY <key code> <string>                               ;
;                                                       ;
; The parameters must be separated by a single space.   ;
; Each parameter may consist of any combination of      ;
; strings in double quotes and decimal ASCII codes,     ;
; seperated by semicolons.                              ;
;                                                       ;
; The key to reset (first parameter) should be the      ;
; key's character code (one or two bytes).  The new     ;
; assignment (second parameter) can be any combination  ;
; of strings and ASCII values.                          ;
;                                                       ;
; Examples:                                             ;
;                                                       ;
; KEY "g" "h"                                           ;
;   Assign lower-case h to the lower-case g key.        ;
;                                                       ;
; KEY 0;59 19                                           ;
;   Assigns ^S to the F1 key.  0;59 is the key code for ;
;   F1.  Makes F1 act like Ctl NumLock when you are,    ;
;   for instance, TYPEing out a file.                   ;
;                                                       ;
; KEY 0;68 "DIR";13                                     ;
;   Assign DIR plus a carriage return to the F10 key.   ;
;                                                       ;
; The extended codes for all applicable keys can be     ;
; found in the BASIC manual right after the ASCII       ;
; character table.  Most application programs by-pass   ;
; the DOS keyboard routines (i.e. the reassignments     ;
; won't work for them).  Keyboard reaasignment by this  ;
; method is probably best used for setting up the       ;
; function keys to use from the DOS command level.      ;
;-------------------------------------------------------;

           PROC      FAR
INPUT      EQU       [80H]          ;parameter location

;----- print message

           MOV       DX,OFFSET KEYMESS ;message location
           CALL      STR_DISPLAY    ;string display

;----- number of characters

           MOV       CL,BYTE INPUT  ;number of characters
           SUB       CH,CH
           CMP       CL,1           ;check if too few
           JB        KEYERROR       ;jump if so

;----- print input and end CR

           PUSH      CX
           MOV       SI,OFFSET INPUT + 2 ;start after space
           PUSH      SI

           MOV       DX,OFFSET KEYMESS2 ;message location
           CALL      STR_DISPLAY    ;string display

KEYILOOP   LODSB                    ;load next byte
           CALL      DISPLAY        ;display
           LOOP      KEYILOOP       ;loop CX times

;----- move a line down

           MOV       AL,10          ;byte to display, LF
           CALL      DISPLAY        ;display

           POP       DI
           POP       BX

;----- scan for space

           DEC       BX             ;do not count initial space
           MOV       CX,BX          ;number of characters to search
           MOV       AL,' '         ;look for space

           REPNE
           SCASB                    ;scan until found or no more

;----- add semicolon

           JNE       KEYERROR       ;jump if not found
           MOV       BYTE [DI-1],59 ;save semicolon to location

;----- add start code

           MOV       AX,CTL_START   ;load starting control
           MOV       WORD INPUT,AX  ;save

;----- add end code

           MOV       AX,CTL_END     ;load end control
           MOV       [INPUT+BX+2],AX ;save

;----- reset key

           MOV       DX,OFFSET INPUT ;control string location
           CALL      STR_DISPLAY    ;string display
           INT       20H            ;exit

;----- error in parameters

KEYERROR   MOV       DX,OFFSET KEYEMESS ;error message location
           CALL      STR_DISPLAY    ;string display
           INT       20H            ;exit

;-----------------------;
;        DISPLAY        ;
; Display the character ;
; in AL to the screen.  ;
;-----------------------;

DISPLAY    PROC      NEAR
           MOV       DL,AL          ;byte to display
           MOV       AH,2           ;display byte function
           INT       21H            ;execute
           RET
           ENDP                     ;DISPLAY

;-------------------------------------;
;             STR_DISPLAY             ;
; Display the string at DX terminated ;
; by a dollar sign to the screen      ;
;-------------------------------------;

STR_DISPLAY PROC     NEAR
           MOV       AH,9           ;string output function
           INT       21H            ;execute
           RET
           ENDP                     ;STR_DISPLAY

;-------------------------------------;
;            Program Data             ;
;-------------------------------------;

CTL_START  LABEL     WORD
           DB        27,'['         ;start of reassignment sequence
CTL_END    LABEL     WORD
           DB        'p$'           ;end of reassignment sequence

KEYMESS    DB        10,'Key Reassignment',13,10,'$'
KEYMESS2   DB           '--> $'

KEYEMESS   DB  10,'Error in parameters: <key code> <output>',13,10
           DB     '  Each parameter may consist of any combination of',13,10
           DB     '  strings in double quotes and decimal ASCII codes,',13,10
           DB     '  seperated by semicolons.',13,10,'$'
           ENDP

