' Epson Bar Code printing program
' for use with Epson Graphics Printer
'
' Written in Microsoft QuickBASIC V. 2.0
' By Kent Walker, Ford Aerospace & Communications Corporation
' March, 1987

'With thanks to James H. Todd, Westinghouse Electric Corp.
' (modified from his program appearing in Industrial Engineering
' magazine, September, 1986)

' TRON

'INITIALIZE PRINTER WIDTH
WIDTH "LPT1:", 255

'DIMENSION ARRAY VARIABLES
DIM AA$(100), E$(15), P$(20)

'CREATE INTRODUCTION SCREEN

LOCATE 3, 28
PRINT "Epson Graphics Printer"
LOCATE 15, 27
PRINT "CODE 39 BAR CODE PRINTING"
LOCATE 23, 1
PRINT "HIT ANY KEY TO CONTINUE.....:

LOOP1:
GO$ = INKEY$
IF GO$ = "" THEN GOTO LOOP1

DENS.SCREEN:

'   CREATE SELECT CODE DENSITY SCREEN
CLS
PRINT STRING$( 79, "*" )

PRINT TAB(24) "CODE DENSITY SELECTION SCREEN"

PRINT STRING$( 79, "*" )

LOCATE 9,6
PRINT "PLEASE SELECT CODE PRINTING DENSITY:
LOCATE 12, 10: PRINT "1.  LOW DENSITY PRINTING"
LOCATE 14, 10: PRINT "2.  HIGH DENSITY PRINTING"
LOCATE 23,1 :  PRINT "( EXIT PROGRAM - *E )"

LOOP2:

LOCATE 17,12 : PRINT "PLEASE ENTER "1" OR "2" AND STRIKE ENTER...";
INPUT DE$

IF DE$ = "*E" THEN

PROGRAM.EXIT:

	CLS
	END
END IF

IF VAL( DE$ ) = 1 THEN GOSUB LOW.DENS _
				  ELSE GOSUB HIGH.DENS

'   USER DIDN'T INPUT A PROPER NUMBER

IF VAL( DE$ ) <> 1 AND VAL( DE$ ) <> 2 THEN

	LOCATE 17, 57
	PRINT STRING$( 22, " " )
	GOTO LOOP2

END IF

GOSUB MAKE.CODES        ' BUILD THE GRAPHICS CHAR TABLE

INPUT.SCREEN:

'CREATE INFORMATION ENTRY SCREEN

CLS

PRINT STRING$( 79, "*" )
PRINT TAB(27) "INFORMATION ENTRY SCREEN"
PRINT STRING$( 79, "*" )

LOCATE 8, 15

PRINT "BAR CODE MESSAGES ARE LIMITED TO "; LA; " CHARACTERS"
LOCATE 10,23
PRINT "PLEASE ENTER CAPITAL LETTERS ONLY"
LOCATE 23,1
PRINT "( EXIT PROGRAM - *E ) ( DENSITY SCREEN - *D )"

LOOP3:

LOCATE 16, 1

LINE INPUT "PLEASE ENTER CHARACTERS TO BE BAR CODED     "; IN$

IF IN$ = "" THEN GOTO LOOP3
IF IN$ = "*D" THEN GOTO DENS.SCREEN
IF IN$ = "*E" THEN GOTO PROGRAM.EXIT

L% = LEN( IN$ )

IF L% > LA THEN GOTO TOO.MANY.CHARS

GOSUB CHAR.TO.BAR           '   BUILD BAR CODE PIXEL ARRAY

LOOP4:

'   REMOVE ANY INPUT ERROR MESSAGE

LOCATE 17,1
PRINT STRING$( 80, " " )

LOCATE 18, 1
INPUT "NUMBER REQUIRED        "; N$

IF VAL( N$ ) < 1 THEN GOTO LOOP4    '   ERROR - BAD NUMERIC INPUT

N% = VAL( N$ )

GOSUB PRINT.BARS:

'   LOOP

GOTO INPUT.SCREEN

'==========================================================

TOO.MANY.CHARS:

'   ERROR MESSAGE

LOCATE 17, 4
PRINT "MESSAGE EXCEEDS "; LA; " CHARACTERS -- RE-ENTER"

LOCATE 16, 1
PRINT STRING$( 79, " " )
GOTO LOOP3

'==========================================================

BAD.CHARS:

'   BAD CHAR MESSAGE

LOCATE 17, 4
PRINT "MESSAGE CONTAINS ILLEGAL CHARACTERS -- RE-ENTER"
LOCATE 16, 1
PRINT STRING$( 79, " " )
GOTO LOOP3

'==========================================================

LOW.DENS:

'   LOW DENSITY CHARACTERS

A$ = CHR$(127) + CHR$(127)
B$ = CHR$(127) + CHR$(127) + CHR$(127) + CHR$(127) + CHR$(127) + CHR$(127)
C$ = CHR$( 0 ) + CHR$( 0 )
D$ = CHR$( 0 ) + CHR$( 0 ) + CHR$( 0 ) + CHR$( 0 ) + CHR$( 0 ) + CHR$( 0 )

AC$ = A$ + C$
AD$ = A$ + D$
BC$ = B$ + C$
BD$ = B$ + D$

C  = 23
LA =  9

RETURN

'==========================================================

HIGH.DENS:

'   HIGH DENSITY CHARACTERS

A$ = CHR$(127) + CHR$(127)
B$ = CHR$(127) + CHR$(127) + CHR$(127) + CHR$(127)
C$ = CHR$( 0 ) + CHR$( 0 )
D$ = CHR$( 0 ) + CHR$( 0 ) + CHR$( 0 ) + CHR$( 0 )

AC$ = A$ + C$
AD$ = A$ + D$
BC$ = B$ + C$
BD$ = B$ + D$

C  = 26
LA = 12

RETURN

'==========================================================

MAKE.CODES:

' ALPHABET ARRAY WITH INDEX BEING ASCII EQUIVALENT

AA$( 0) = AD$ + AC$ + BC$ + BC$ + AC$   '   * (SPECIAL START-STOP CHAR)
AA$(32) = AD$ + BC$ + AC$ + BC$ + AC$   '   SPACE
AA$(36) = AD$ + AD$ + AD$ + AC$ + AC$   '   $
AA$(37) = AC$ + AD$ + AD$ + AD$ + AC$   '   %
AA$(43) = AD$ + AC$ + AD$ + AD$ + AC$   '   +
AA$(45) = AD$ + AC$ + AC$ + BC$ + BC$   '   -
AA$(46) = BD$ + AC$ + AC$ + BC$ + AC$   '   .
AA$(47) = AD$ + AD$ + AC$ + AD$ + AC$   '   /
AA$(48) = AC$ + AD$ + BC$ + BC$ + AC$   '   0
AA$(49) = BC$ + AD$ + AC$ + AC$ + BC$   '   1
AA$(50) = AC$ + BD$ + AC$ + AC$ + BC$   '   2
AA$(51) = BC$ + BD$ + AC$ + AC$ + AC$   '   3
AA$(52) = AC$ + AD$ + BC$ + AC$ + BC$   '   4
AA$(53) = BC$ + AD$ + BC$ + AC$ + AC$   '   5
AA$(54) = AC$ + BD$ + BC$ + AC$ + AC$   '   6
AA$(55) = AC$ + AD$ + AC$ + BC$ + BC$   '   7
AA$(56) = BC$ + AD$ + AC$ + BC$ + AC$   '   8
AA$(57) = AC$ + BD$ + AC$ + BC$ + AC$   '   9
AA$(65) = BC$ + AC$ + AD$ + AC$ + BC$   '   A
AA$(66) = AC$ + BC$ + AD$ + AC$ + BC$   '   B
AA$(67) = BC$ + BC$ + AD$ + AC$ + AC$   '   C
AA$(68) = AC$ + AC$ + BD$ + AC$ + BC$   '   D
AA$(69) = BC$ + AC$ + BD$ + AC$ + AC$   '   E
AA$(70) = AC$ + BC$ + BD$ + AC$ + AC$   '   F
AA$(71) = AC$ + AC$ + AD$ + BC$ + BC$   '   G
AA$(72) = BC$ + AC$ + AD$ + BC$ + AC$   '   H
AA$(73) = AC$ + BC$ + AD$ + BC$ + AC$   '   I
AA$(74) = AC$ + AC$ + BD$ + BC$ + AC$   '   J
AA$(75) = BC$ + AC$ + AC$ + AD$ + BC$   '   K
AA$(76) = AC$ + BC$ + AC$ + AD$ + BC$   '   L
AA$(77) = BC$ + BC$ + AC$ + AD$ + AC$   '   M
AA$(78) = AC$ + AC$ + BC$ + AD$ + BC$   '   N
AA$(79) = BC$ + AC$ + BC$ + AD$ + AC$   '   O
AA$(80) = AC$ + BC$ + BC$ + AD$ + AC$   '   P
AA$(81) = AC$ + AC$ + AC$ + BD$ + BC$   '   Q
AA$(82) = BC$ + AC$ + AC$ + BD$ + AC$   '   R
AA$(83) = AC$ + BC$ + AC$ + BD$ + AC$   '   S
AA$(84) = AC$ + AC$ + BC$ + BD$ + AC$   '   T
AA$(85) = BD$ + AC$ + AC$ + AC$ + BC$   '   U
AA$(86) = AD$ + BC$ + AC$ + AC$ + BC$   '   V
AA$(87) = BD$ + BC$ + AC$ + AC$ + AC$   '   W
AA$(88) = AD$ + AC$ + BC$ + AC$ + BC$   '   X
AA$(89) = BD$ + AC$ + BC$ + AC$ + AC$   '   Y
AA$(90) = AD$ + BC$ + BC$ + AC$ + AC$   '   Z

RETURN

'==========================================================

CHAR.TO.BAR:

'   ROUTINE TO SEPERATE CHARACTERS FROM IN$ TO E$( I% ) ARRAY

P$( 0 ) = AA$( 0 )          '   START CHAR BEGINS STRING

FOR I% = 1 TO L%

	E$( I% ) = MID$( IN$, I%, 1 )


'   CHECK FOR UNALLOWED CHARACTERS

	X$ = E$( I% )

	IF  NOT ( ( X$ >= "-"  AND X$ <= "9" ) OR _
			  ( X$  = "+"                ) OR _
				X$  = "$"  OR  X$ = "%"  OR X$ = " "  OR _
			  ( X$ >= "A"  AND X$ <= "Z" ) _
			) THEN GOTO BAD.CHARS

'   ASSIGN ALPHA CHAR TO PRINT STRING

	A% = ASC( E$( I% ) )
	P$( I% ) = AA$( A% )

NEXT I%

P$( L% + 1 ) = AA$( 0 )     '   APPEND STOP CHAR TO PRINT STRING

RETURN

'==========================================================

PRINT.BARS:

'   SUBROUTINE TO PRINT BARCODE

'   DETERMINE TOTAL NUMBER OF COLUMNS ( PIXELS ) OF GRAPHIC INFORMATION

A% =   ( L% + 2 ) * C     \ 256
B% = ( ( L% + 2 ) * C ) MOD 256


'LOOP FOR PRINTING LABELS

FOR Z% = 1 TO N%

'   SET LINE FEED TO 20/216 IN.

LPRINT CHR$(27); "3"; CHR$(20)

'   MAIN PRINT ROUTINE
'   PRINT 7 PASSES

	FOR X% = 1 TO 7

		'   GRAPHICS MODE
		LPRINT CHR$(27); "L"; CHR$( B% ); CHR$( A% );

		'   PRINT ASSIGNED BAR-CODE CHAR STRINGS

		FOR Y% = 0 TO L% + 1

			LPRINT P$( Y% );

		NEXT Y%

		LPRINT

	NEXT X%

GOSUB PRINT.CHARS           ' PRINT MAN-READABLE CHARACTERS

NEXT Z%

RETURN

'==========================================================

'   SUBROUTINR TO PRINT MAN-READABLE CHARACTERS

PRINT.CHARS:

'   RESET PRINTER
LPRINT CHR$(27); "@";

'   DOUBLE STRIKE MODE
LPRINT CHR$(27); "G";

'   EMPHASIZED PRINT
LPRINT CHR$(27); "E";

'   DOUBLE WIDTH PRINT
LPRINT CHR$(27); "W"; CHR$(1);

'   PRINT HUMAN-READABLE CHARACTERS
LPRINT IN$

'   SET LINE FEED TO 56/216 IN. FOR TOP OF NEXT LABEL
LPRINT CHR$(27); "3"; CHR$(56)

'   RESET PRINTER
LPRINT CHR$(27); "@";

RETURN

                                           