{
             KNOVICE Procedure call procedures

            Copyright (C) 1987 George F. Wilber.

There routines allow the user to attach procedures to the production
rules.
}
{
***************************************

INSERT PROCEDURES HERE

Enter your procedures below.  There are no direct parameter passing
facilities, all global parameters are objects.  Objects are accessed
as follows:  See the Knovice User Guide for details of these boolean
functions.

   get_object(object_name: t_word; var object_value: t_word)

   get_real_object(objec_name: t_word; var object_value: real)

   store_object(object_name, object_value: t_word)

   store_real_object(object_name: t_word; object_value: real)

All routines return true if they are successful, false otherwise.
T_word is an array[1..15] of char.  Real routines must be called
for and only for real objects.

Example:

This procedure accesses the real object #price and sets its value
to 150% of its current value.
}
procedure calc_markup;
   var
      flag: boolean;
      real_value: real;

   begin

   { The get_real_object will return false if #price is not found }

   if get_real_object('#price', real_value) then
        real_value := real_value * 1.5
   else writeln('#price object not found');

   { store_real_object will return true if it successfully sets
     #price to real_value }

   flag := store_real_object('#price', real_value);
   if not(flag) then writeln('#price not stored');
   end;
{
***************************************
}
procedure knovice_procedures; { (proc: t_word) }
   begin
      {
      *********************************

      INSERT PROCEDURE CASES HERE

      This is one big if-then-else clause each with a test
      on proc value.  The last else is for an illegal entry.

      Example:
      }
      if proc = 'calc_markup' then calc_markup
      {
      *********************************
      }
      else
         writeln('Aborted - unknown procedure: ', proc);
   end;

