	PAGE	,132  ; (CTRL-OH)   IBM PC PRINTER CONDENSED MODE
	TITLE	TEST232 - TEST THE CUSTOM RS-232 (INT 14) DRIVERS
CSEG	SEGMENT PARA PUBLIC 'CODE'
	ASSUME CS:CSEG,DS:CSEG,SS:CSEG,ES:CSEG ;ALREADY SET BY DOS LOADER

	ORG	100H			;SKIP TO END OF THE PSP
ENTPT:	JMP	START			;COM FILE ENTRY ALWAYS AT 100H

COPY	DB	'(C) Copyright 1986 Doctor Debug - All rights reserved',26
;
BAUD	DW	1200			;INIT AT 300 BAUD
PARITY	DB	2			;1=ODD, 2=NONE, 3=EVEN
STOP	DB	1			
WORDLEN	DB	8			;7 OR 8
ECHO	DB	0			;0 = OFF, 1 = ON
LF	DB	0			;ADD LF IF 1, NO IF 0
;
START	PROC	NEAR
;
;	FIRST INITIALIZE THE PORT
;
	MOV	BL,0
	MOV	AX,BAUD			;DETERMINE BAUD RATE
	CMP	AX,300		
	JE	B300
;
	CMP	AX,1200
	JE	B1200
;
	CMP	AX,2400
	JE	B2400
;
	CMP	AX,4800
	JE	B4800
;
B9600:	MOV	BL,0E0H			;BL MUST HAVE PROPER CODE
	JMP	I1
;
B4800:	MOV	BL,0C0H
	JMP	I1
;
B2400:	MOV	BL,0AH
	JMP	I1
;
B1200:	MOV	BL,80H
	JMP	I1
;
B300:	MOV	BL,40H
;
I1:	MOV	AH,PARITY		;NOW CHECK PARITY
	MOV	CL,3
	SAL	AH,CL
	OR	BL,AH			;SET THOSE BITS
;		
	MOV	AH,STOP			;HANDLE STOP BITS
	DEC	AH
	MOV	CL,2
	SAL	AH,CL
	OR	BL,AH			;SET STOP BITS
;
	MOV	AH,WORDLEN		;NOW SET WORD LENGTH
	SUB	AH,5
	OR	BL,AH			;SET THESE BITS
;
	MOV	AL,BL
	MOV	AH,0CH
	MOV	DX,0
	INT	14H			;INITS THE COMM PORT
;
					;NOW LOOP, SENDING WHAT'S
					;PRINTED AND PRINTING WHAT'S
					;SENT...

LOOP:	MOV	AH,8			;FN 8 (RECEIVE CHAR)
	MOV	DX,0
	INT	14H			;SEE IF CHAR EXISTS
;
	CMP	AL,0			;NO CHAR?
	JE	L1	

	MOV	DL,AL
	MOV	AH,2
	INT	21H			;PRINT CHAR
;
	CMP	LF,1			;ADD LFS?
	JNE	L1
;
	CMP	AL,0DH			;CR?
	JNE	L1			;NO, CONTINUE
;
	MOV	DL,0AH			;PRINT LF TOO
	MOV	AH,2
	INT	21H
;
L1:	MOV	AH,1
	INT	16H			;CHAR AVAILABLE?
	JZ	LOOP			;NO, CONTINUE
;
	MOV	AH,0
	INT	16H			;get char into al
	CMP	AL,26			;CTRL-Z?
	JNE	L2			;no
;
	MOV	AH,0DH			;CLOSE PORT
	MOV	DX,0			
	INT	14H			;DO IT
	RET				;EXIT
;
L2:	MOV	AH,1
	MOV	DX,0
	INT	14H			;SEND CHARACTER
;
	CMP	ECHO,1			;ECHO?
	JNE	LOOP			;NO, LOOP BACK
;
	MOV	DL,AL
	MOV	AH,2
	INT	21H
;
	CMP	AL,0DH
	JNE	LOOP
;
	MOV	DL,0AH
	MOV	AH,2
	INT	21H
;
	JMP	LOOP
;
START	ENDP
CSEG	ENDS
	END	ENTPT
