/* an.c (asm_neat) -- converts assembly language source to uniform
   appearance.	three options are available from the menu:

		a - convert comments to all lower case
		b - convert comments to all upper case
		c - convert code to lower case, comments remain
		    unchanged
		d - convert code to upper case, comments remain
		    unchanged.

	note: characters within a single or double quoted string remain
	      unchanged, if in code (label, mnemonic, or operand) area
	      of source.
	usage: >an oldfile newfile

02/21/85 added fourth function - code to lower, comments remain
unchanged.  Rearranged.  Roy Browning.

08/10/83  added three function options from menu.  added error
trapping for usage.  frank gaude'

12/23/82  original program (aspretty.c) written by william meyer.
assembly language version (neat.asm) written by joe wright (05/21/83)
then greatly enchanced by irv hoff (05/27/83) into three neat programs.

compiles with c/80 from software toolworks or manx aztec c ii controlled
by the define below.							*/

#include "stdio.h"

main(argc,argv)
int argc;
char **argv;
	{
	static int byte, comment, cu, f1, f2, lc, onequote, twoquote, uc, cl;
	register int c;

	if (argc != 3)		/* test for correct number of auguments */
		{
		printf("usage: >an <oldfile> <newfile>");
		exit(1);
		}
	if ((f1 = fopen(argv[1],"r")) == NULL)	 /* open file 1 	*/
		{
		printf("Unable to find/open/read %s\n", argv[1]);
		exit(1);
		}
	if ((f2 = fopen(argv[2],"w")) == NULL)	 /* open file 2 	*/
		{
		printf("Unable to write to %s\n", argv[2]);
		exit(1);
		}
	byte = lc = uc = cl = cu = 0;
agn:	cls();
	printf("\n\t\t\tAN -- AsmNeat Program Menu\n\n");
	printf("\t     Enter character then <RETURN> for desired function\n\n");
	printf("\t\t\ta - convert comments to lower case\n");
	printf("\t\t\tb - convert comments to upper case\n");
	printf("\t\t\tc - code to lower case, comments unchanged\n");
	printf("\t\t\td - code to upper case, comments unchanged\n");
	printf("\t\t <ctrl-c> - exit to operating system\n\n");
	printf("\t\t\t	  choice: ");
	if ((byte = getresp()) == EOF)
		exit(0);
	switch(byte)
		{
		case 'a':
			lc = 1;
			break;
		case 'b':
			uc = 1;
			break;
		case 'c':
			cl = 1;
			break;
		case 'd':
			cu = 1;
			break;
		default :
			goto agn;
		}
	printf("\n---> Converting assembly file -- ");
	comment = onequote = twoquote = 0;	 /* initialize		*/
	while ((c = getc(f1)) != EOF)
		{
		switch (c)
			{
			case ';' :
			    comment = 1;
			    break;
			case '\n':
			    comment = onequote = twoquote = 0;
			    break;
			case '"' :
			    twoquote = ~twoquote;	/* toggle	*/
			    break;
			case '\'':
			    onequote = ~onequote;
			    break;
			default  :
			    break;
			}
		if ((onequote != 0 || twoquote != 0) & (comment == 0))
			putc(c,f2);
		else if ((comment == 1) && (lc == 1))
			putc(tolower(c),f2);
		else if ((comment == 1) && (uc == 1))
			putc(toupper(c),f2);
		else if ((comment == 1) && (!(lc || uc)))
			putc(c,f2);
		else if ((comment == 0) && (cl == 1))
			putc(tolower(c),f2);
		else if ((comment == 0) && (cu == 1))
			putc(toupper(c),f2);
		else if ((comment == 0) && (!(cl || cu)))
			putc(c,f2);
		}
	fclose(f1);
	fclose(f2);
	printf("done\n");	/* go home msg				*/
	exit(0);
	}

cls()		/* clear screen function				*/
	{
	static int i;

	for (i = 0; i < 25; i++)
		printf("\n");
	}

getresp()	/* get nonwhite space character from keyboard input	*/
	{
	static int byte;

	for (;;)
		{
		if ((byte = getchar()) == EOF)
			break;
		else if ((byte != ' ') && (byte != '\t') &&
			(byte != '\n'))
			break;
		}
	return(tolower(byte));	
	}
                                                                                                    