/* A flexible routine to construct file names. Both an override and a
   default path name are given and a new file name is constructed.
   Each of the path name components (drive, path, filename, extension)
   is handled separately. A pointer to the new file name is returned.
   Examples:
        OVERRIDE                DEFAULT                 NEW
        test                    .obj                    test.obj
        .obj                    test.asm                test.obj
        c:\asm\.asm             a:test.a                c:\asm\test.asm
*/

/* Copyright 1986 John Navas II, All Rights Reserved.
MKFILNAM is made available for personal, non-commercial use only.  You
are granted a limited license to use MKFILNAM, and to copy it and
distribute it, provided that no fee is charged for such copying and
distribution, and that it is ONLY distributed in its original,
unmodified state. */

/* Language: Microsoft C Version 3.00 */

#include <stdio.h>
#include <string.h>

char *mkfilnam( new, ovr, def )		/* MAKE A FILE/PATH NAME WITH DEFAULTS */
char *new;							/* build new file name here */
char *ovr;							/* overriding file/ext */
char *def;							/* defaults for file/ext name */
{
	register char *p = ovr, *q = def, *r, *n = new;
	int i;

	for ( i = 0; ; ++i ) {
		switch ( i ) {
			case 0:						/* find paths */
				if ( q[ 0 ] && q[ 1 ] == ':' ) q += 2;
				if ( p[ 0 ] && p[ 1 ] == ':' ) p += 2;
				break;
			case 1:						/* find files */
				if ( ( r = strrchr( q, '\\' ) ) != NULL ) q = r + 1;
				if ( ( r = strrchr( p, '\\' ) ) != NULL ) p = r + 1;
				break;
			case 2:						/* find extensions */
				q += strcspn( q, "." );
				p += strcspn( p, "." );
				break;
			default:					/* copy extension */
				strcpy( n, ( *p == '.' ) ? p : q );
				return new;
			}
		strcpy( n, ( p != ovr ) ?		/* copy drive, path or file */
			( r = (char *) ( p - ovr ), ovr ) :
			( r = (char *) ( q - def ), def ) );
		n += (int) r; def = q; ovr = p;	/* update pointers */
		}

	}
