

                 (* ********************************************* *)
                 (*                                               *)
                 (*   Many don't realize that you can use the     *)
                 (*   PCjr 160 x 200 Low Resolution 16 Color      *)
                 (*   mode from within Turbo Pascal. The short    *)
                 (*   procedure SetPCjr16Color actuates this      *)
                 (*   screen mode. Write and writeln work but     *)
                 (*   there is no string length checking. You     *)
                 (*   have text coordinates of 1..20,1..25. The   *)
                 (*   gotoxy statement will work. Plot and Draw   *)
                 (*   will also work, but there's a trick to get  *)
                 (*   them to work. You have to call a graphics   *)
                 (*   mode BEFORE you call SetPCjr16Color. I use  *)
                 (*   GraphMode. The call to a graphics mode      *)
                 (*   initializes the plot and draw routines by   *)
                 (*   (apparently) passing them some necessary    *)
                 (*   parameters.                                 *)
                 (*                Donald L. Pavia                *)
                 (*                Department of Chemistry        *)
                 (*                Western Washington University  *)
                 (*                Bellingham, WA   98225         *)
                 (*                                               *)
                 (*                              January 1986     *)
                 (* ********************************************* *)

     program Junior16Color;

     var  i,j,k,c : integer; Wait : char;

     {----------------------------------------------------------------------}
     procedure SetPCjr16col;        { sets PCjr to 160x200 lo res 16 colors }

     type   RegRec = record AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : integer; end;

     var    Regs : RegRec;

     begin  Regs.AX := $0008;  intr($10,Regs)     end;
     {----------------------------------------------------------------------}
                                              { You must call graphmode to  }
     BEGIN                                    { initialize turbo's plot and }
                                              { draw routines. Without this }
          Clrscr; GraphMode; SetPCjr16Col;    { call they will not work.    }

          draw (0,0,159,0,2);
          TextColor (14); gotoxy (2,2); write ('HELLO');
          TextColor  (2); gotoxy (7,3); write ('THERE');

          j := 36;
          for i := 10 to 50 do begin
             plot (i,j,i mod 16); draw (i+2,j,i+90,j,i mod 16);
             j := j+2;  end;

          TextColor (14); gotoxy (1,17);
          write ('This is a PCjr !!!!'); gotoxy (1,19);

          for i := 1 to 20 do begin
                   k := i mod 16; if k = 0 then k := 7; c := 64 + i;
                   TextColor (k); write (chr(c)); end;

          gotoxy (1,21);
          for i := 1 to 20 do begin
                   K := i mod 16; if k = 0 then k := 7; c := 96 + i;
                   TextColor (k); write (chr(c)); end;

          draw (0,199,159,199,2); gotoxy (1,23);
          read (Kbd,Wait); TextMode (c80);

     END.