'       SCREEN.INC: a set of sample screen formatting routines
'					(C) Copyright 1983 Marty Franz

PROCEDURE INITIALIZE.SCREEN 'Initialize all the screen variables
	BORDER$ = STRING$(80,&HC4)
	LINE.MASK$ = SPACE$(79)
	MSG.MASK$ = SPACE$(20)
ENDPROC

PROCEDURE CLEAR.SCREEN		'Clear the screen, set keys off	
	KEY OFF : CLS : WIDTH 80
ENDPROC

PROCEDURE SET.TITLES		'Redisplay all the titles 
	DO CLEAR.SCREEN
	LOCATE 1,1					 : PRINT L.TITLE$;
	LOCATE 1,80-LEN(R.TITLE$)+1	 : PRINT R.TITLE$;
	LOCATE 3,1					 : PRINT BORDER$
ENDPROC

PROCEDURE SET.FUNCTION.MSG	'Update the function message
	LOCATE 2,1
	PRINT LEFT$(FUNC.MSG$+MSG.MASK$,20);
ENDPROC

PROCEDURE SET.ACTION.MSG	'Update the action message
	LOCATE 2,61
	PRINT RIGHT$(MSG.MASK$+ACT.MSG$,20);
ENDPROC

PROCEDURE CLEAR.AREA		'Clear lines 4 thru 23
	LOCATE 4,1
	FOR CLRA.I = 4 TO 23
		PRINT LINE.MASK$
	NEXT CLRA.I
ENDPROC

PROCEDURE SET.LINE.24		'Put a message on line 24
	LOCATE 24,1
	PRINT LINE.24.MSG$;
ENDPROC

PROCEDURE CLEAR.LINE.24		'Clear the 24th line of the screen
	LINE.24.MSG$ = LINE.MASK$
	DO SET.LINE.24
ENDPROC

PROCEDURE DRAW.BOX			'Draw a box
	LOCATE BOX.ROW,BOX.COL
	PRINT CHR$(&HDA);STRING$(BOX.LEN-2,&HC4);CHR$(&HBF)
	LOCATE ,BOX.COL
	FOR BOX.I=1 TO BOX.HT-2
		PRINT CHR$(&HB3);SPACE$(BOX.LEN-2);CHR$(&HB3)
		LOCATE ,BOX.COL
	NEXT BOX.I
	PRINT CHR$(&HC0);STRING$(BOX.LEN-2,&HC4);CHR$(&HD9)
ENDPROC

PROCEDURE DRAW.FRAME		'Draw a frame (double lines)
	LOCATE FRAME.ROW,FRAME.COL
	PRINT CHR$(&HC9);STRING$(FRAME.LEN-2,&HCD);CHR$(&HBB)
	LOCATE ,FRAME.COL
	FOR FRAME.I = 1 TO FRAME.HT-2
		PRINT CHR$(&HBA);SPACE$(FRAME.LEN-2);CHR$(&HBA)
		LOCATE ,FRAME.COL
	NEXT FRAME.I
	PRINT CHR$(&HC8);STRING$(FRAME.LEN-2,&HCD);CHR$(&HBC)
ENDPROC
