/* LISTING 3 ALIGN.C */

/* align.c - align a buffer so that it does not cross */
/* a 64K physical address boundary */
/* We give it the address of a buffer area */
/* It returns a starting addresss such that the following (size) bytes */
/* do not cross a 64K byte address boundary. */
#include "stdio.h"

unsigned get_ds() ;

char *align(area,size)             /* align buffer address */
 char *area ;                      /* start of buffer area */
 int size ;                /* size required for buffer */
 {                         /* returns an aligned address */
    long begin ;           /* flat address for area */
    unsigned room ;        /* number of bytes to boundary */

                           /* build flat address */
    begin = ((long) get_ds() ) * 16L + (long) area ;
    room = 0x10000 - (begin & 0xffff) ; /* get distance to boundary */
    if( room >= size )
         return( area ) ;
    else return( area + room ) ;
 }
  