/*
    LST_ARCS  --  List/Test/eXtract etc. Archive files

    usage:  lst_arcs cmd [optional path]

    exmpl:  lst_arcs  T              'root directory'        test
            lst_arcs  T .            'current directory'     test
            lst_arcs  C ..           'directory above'       new packing
            lst_arcs  L \tst\able    'some other directory'  list


       The purpose of this program is to search out all of the .ARC files
       on a disk and put their names into a batch file that when executed
       will do some ARC option on them (ie: ARC T XXX.ARC). The results of
       the option on each ARC are put into a file named 'TST_ARCS.ANS' to
       be looked at later, as the test does take some time..


       If the directory is omitted, the tree starts with the root
	    directory.  Use lst_arcs 'arc option' . to start from the current directory.
       You may use any valid character (maybe string in the future) that
       your version of ARC will accept for the 'arc option'.

       MicroSoft 'C' Version 3.0

       Compile: Msc LST_ARCS /Ox;     <optimize>
       Link LST_ARCS /STACK:8192;     <heavy recursion>

       THE SOURCE IS INCLUDED SO THAT YOU MAY MODIFY IT IF YOU PLEASE. THROW
       IT AWAY OR WHAT EVER YOU LIKE. IF EVERYBODY INCLUDED SOURCE IT WOULD
       BE A LOT EASIER WHEN YOU FIRST START LEARNING... AND THERE IS ALWAYS
       SOMETHING TO BE LEARNED, IF NOTHING MORE THAT SOMEONE ELSES MISTAKES.
                                  . 
       By: John W. Kindschi Jr. .   .
           San Jose, Calif.....


       NOTE: for some reason ARC.EXE does not like subdirectories that
             are greater than 8 characters in length even thought it is
             legal to have 13, such as 'abcdefgh.123'. So beware if you
             have any that are...

*/


/*----- the header files ---------------------------------------------------*/

#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <process.h>


/*----- history ------------------------------------------------------------*/

static char *version = "Version 1.05, created on January 14, 1986 at 20:11:53";


/*----- constants ----------------------------------------------------------*/

/*  BDOS CALLS */
#define GETFAT 0x3600   /* GET FAT info */
#define SETDTA 0x1A00   /* SET Disk Transfer Address */
#define FFIRST 0x4E00   /* Find FIRST directory entry */
#define FNEXT  0x4F00   /* Find NEXT directory entry */
#define SUBDIR 0x0010	/* SUB-DIRectory attribute */
#define FIRST 1
#define NEXT 0


/*----- variables ----------------------------------------------------------*/

struct	DIRS			   /* dos directory entry */
{
    char    for_dos[21];      /* DOS use only */
    char    attr;             /* attribute */
    unsigned int time;        /* creation time */
    unsigned int date;        /* creation date */
    long    size;             /* file size */
    char    name[13];         /* file name */
    char    fill[85];         /* filler to make 128 total bytes */
};
char *option;  /* option character or string maybe in the future */              
char arcname[129];             /* arc path and name */
FILE *arc_batch;              /* the archive batch file */


/*----- forward declarations -----------------------------------------------*/

void  pdir();
int   find_dir();


/*----- the program --------------------------------------------------------*/
main(argc, argv)
int	argc;
char	*argv[];
{
    char    *path;
    int i;
    extern int unlink();   /* delete the specified file name */

   if(argc<2) {
      fprintf(stderr,"Usage: lst_arcs cmd [path]\n");
      exit(1);
   } else option=argv[1];
   if(argc>2) path=argv[2];
      else path=""; /* default to root */

    if((arc_batch=fopen("TST_ARCS.BAT","w"))!=NULL) {
        unlink("TST_ARCS.ANS");  /* get rid of any old files */

        printf("\n\n\n\n\nPlease standby.., I'm building the batch file..\n\n");

        /* a little free publicity never hurt... */
        fprintf(arc_batch,"Echo off\n");
        fprintf(arc_batch,"cls\n");
        fprintf(arc_batch,"Echo ͻ\n");
        fprintf(arc_batch,"Echo  Created by: LST_ARCS.EXE, V1.05  \n");
        fprintf(arc_batch,"Echo  Written by: John W. Kindschi Jr. \n");
        fprintf(arc_batch,"Echo  Compiled  : January 14th, 1986   \n");
        fprintf(arc_batch,"Echo ͼ\n");
        fprintf(arc_batch,"Echo on\n");
  
        pdir (path);
        fclose(arc_batch);
        for(i=1;i<22;i++) putchar('\n');
        printf("              NOW YOU MAY DO THE FOLLOWING ͻ\n");
        printf("              Enter   : TST_ARCS (a batch file...)            \n");
        printf("              Purpose : Perform %s option on all .ARC files.   \n",option);
        printf("              Results : Put into file 'TST_ARCS.ANS'.         \n");
        printf("             ͼ\n");
        printf("        ͻ\n");
        printf("         Archive must be in this directory or have a path to it. \n");
        printf("        ͼ\n");
    } 
    else {
        fprintf(stderr,"            ͻ\n");
        fprintf(stderr,"             SORRY BUT COULD NOT OPEN 'TST_ARCS.BAT' FILE !! \007\n");
        fprintf(stderr,"            ͼ\n");
        exit(1); 
    } 
    exit(0);
}


/*----- print directory by path --------------------------------------------*/
void
pdir (path)
char	*path;
{
    char    newpath[129],arcpath[129];
    struct  DIRS buf;
    int r;
    char *dot;

    for (r = find_dir(path, (char *) &buf, FIRST); r == 0; r = find_dir(path, (char *) &buf, NEXT))
    {
        if (*buf.name == '.')
            continue;

        if (buf.attr & SUBDIR)
        {
            sprintf(newpath, "%s\\%s", path, buf.name);
            pdir(newpath);
        }
        else
        {
            if(dot=strpbrk(buf.name,".")){
                if(*++dot=='A' && *++dot=='R' && *++dot=='C') {
                    sprintf(arcpath,"%s\\%s",path, buf.name);
                    fprintf(arc_batch,"Echo   %s >>TST_ARCS.ANS\n",arcpath);
                    fprintf(arc_batch,"ARC %s %s >>TST_ARCS.ANS\n",option,arcpath);
                }
            }
        }
    }
}


/*----- find directory entry -----------------------------------------------*/
int
find_dir(dir, buf, level) 			/* find directory entry */
char	*dir, *buf;
int   level; /* if 1 then find first, else find next */
{
    union  REGS inregs, outregs;
    char    arg[129];

    inregs.x.ax = SETDTA;
    inregs.x.dx = (int) buf; /* assume local data segment */
    (void) intdos(&inregs, &outregs);

    if(level==FIRST) {
    sprintf(arg, "%s\\????????.???", dir);   /* any match is ok */
    inregs.x.ax = FFIRST;
     }
    else {
       sprintf(arg, "%s\\*.*", dir);
       inregs.x.ax = FNEXT;
    }
    inregs.x.cx = SUBDIR;
    inregs.x.dx = (int) (arg);
    (void) intdos(&inregs, &outregs);
    return ((int) outregs.x.ax);

}


