/* xcsubs.c		XCOMM utility subroutines
 */
#include <stdio.h>
#include <ctype.h>
#include "xcomm.h"

sendstr(p)		/* send a string to the port */
register char *p;
{
    while(*p)
	sendbyte(*p++);
}

/* Do the fork call, packaging the error return so that the caller
 * need not have code for it.
 */
forkem()
{
    int i;

    if((i = fork()) < 0){
	printf("XCOMM: Fork failed");
	longjmp(erret, 1);
    }
    return(i);
}

/* Increment a character pointer up to the next non-space character
 */
skipspace(p)
register char **p;
{
    while(isspace(**p))
	(*p)++;
}

/* Increment a character pointer up to the next space character or null.
 */
skipitem(p)
register char **p;
{
    while(**p && !isspace(**p))
	(*p)++;
}

/* Copy non-space characters from q to p,
 * terminating p when a space or null is reached.
 */
copyitem(p, q)
register char *p, *q;
{
    if(*q){
	while(*q && !isspace(*q))
	    *p++ = *q++;
	*p = '\0';
	return(0);
    }
    return(1);
}

/* Convert uppercase characters to lowercase, (without
 * mangling non-uppercase characters), in a portable manner.
 */
mklow(c)
int c;
{
    if(isupper(c))
	return(tolower(c));
    return(c);
}

/* This is an string input routine to be used
 * when the raw terminal mode is in effect.
 */
getsome(s)
char *s;
{
    int c, i;

    i = 0;
    while((c = getchar()) != '\r' && c != '\n'){
	if(c == '\b'){
	    if(i > 0){
		i--;
		printf("\b \b");
	    }
	    else
		putchar(7);
	    continue;
	}
	s[i++] = c;
	putchar(c);
    }
    s[i] = '\0';
    putchar(' ');
}

/* Erase the current line without moving downwards.
 */
erasln()
{
    int i;

    putchar('\r');
    for(i = 0; i < 79; i++)
	putchar(' ');
    putchar('\r');
}

/* Throw away all input characters until no more are sent.
 */
purge()
{
    while(readbyte(3) != -1)
	;
}

