/* 		Revised 14 June 87  -  Homer Arment		*/

#include "screen.h"
#include <dos.h>
#include <bios.h>
#include <conio.h>
#include <stdio.h>

#define VIDEO 0x10

/*
#define DEMO_PROG
*/

#ifdef DEMO_PROG

main()
{
    unsigned int row,col,page;
    static char *sign_off="So Long   Everybody!";
    row = 10;
    col = 16;
    cls();
    printf("\nPress any key to continue...\n");
    cursor_off();
    getch();
    border_color(0x02);
    screen_color(0x2e);
    cursor_pos(row,col);
    printf("You should have your cursor back.\n\n\t\tPress any key to quit.");
    cursor_on();	
    page=getcursor_pos(&row,&col);
    printf("\n\n\nThe active page is %1d, Cursor row was %2d,Column was %2d\n",
              page,row,col);
    cursor_pos(24,70);
    put_str_attr(sign_off,0x1e);
    getch();
    cls();
}

#endif

/**************************************************************************\
|*  void cls()                                                            *|
|*                                                                        *|
|*  Clears the screen to current attribute.  Returns nothing              *|
|*                                                                        *|
|*                 Homer Arment  -  1 June 87                             *|
\**************************************************************************/

void cls(void)
{
    union REGS regs;

    regs.x.bx = get_ch_attr();
    regs.h.ah = 0x06;	/* Set ah =6 for BIOS screen scroll up call	*/
    regs.h.al = 0;	/* and al=0 to blank whole screen		*/
    regs.h.ch=0;	/* start at row 0				*/
    regs.h.cl = 0;	/* and col 0 					*/
    regs.h.dh = 0x18;	/* end at row 24				*/
    regs.h.dl = 0x4f;	/* and col 79					*/
    int86(VIDEO,&regs,&regs);	/* call to interrupt 10H to do work	*/
}

/**************************************************************************\
|* int get_ch_attr()                                                         *|
|*                                                                        *|
|*    returns attribute and character read from current cursor location   *|
|*    of the active screen.  requires function get_vid_mode() to operate  *|
|*    correctly.                                                          *|
|*                                                                        *|
|*                 Homer Arment  -  14 June 87                            *|
\**************************************************************************/


int get_ch_attr(void)
{

    _BX = get_vid_mode();
    _AH = 0x08;	/* bios request for reading char & attrib	*/
    geninterrupt(VIDEO);	/* Call to int 10H to do the work	*/
    return(_AX);		/* return attrib in ah, char in al	*/
}

/**************************************************************************\
|* int get_vid_mode()                                                     *|
|*                                                                        *|
|*    returns the currently active video page to calling value            *|
|*                                                                        *|
|*                 Homer Arment  -  14 June 87                            *|
\**************************************************************************/

int get_vid_mode(void)
{

    _AH = 0x0f;	/* request for current video mode		*/
    geninterrupt(VIDEO);
    return(_BX);
}

/**************************************************************************\
|* void cursor_pos(int row, int col)                                      *|
|*                                                                        *|
|*    Requires values for row and col be passed by calling function       *|
|*    no range checking is done on row and col to assure they are valid   *|
|*    screen locations.                                                   *|
|*                                                                        *|
|*                 Homer Arment  -  14 June 87                            *|
\**************************************************************************/

void cursor_pos(unsigned int row,unsigned int col)
{

    _BX = get_vid_mode(); /* get the active page			*/
    _DH = row;
    _DL = col;
    _AH = 0x02;		/* BIOS service to position cursor	*/
    geninterrupt(VIDEO);	/* Via interrupt 10H			*/
}

/**************************************************************************\
|* void cursor_off()                                                      *|
|*                                                                        *|
|*    Turns the cursor off on CGA system.  May work with other systems    *|
|*    also but has not been tested.  Returns nothing                      *|
|*                                                                        *|
|*                 Homer Arment  -  14 June 87                            *|
\**************************************************************************/

void cursor_off(void)
{

    _AH = 0x01;		/* use BIOS to form cursor shape	*/
    _CH = 0x20;		/* turn off cursor			*/
    geninterrupt(VIDEO);	/* call BIOS to do the work		*/
}

/**************************************************************************\
|* void cursor_on()                                                       *|
|*                                                                        *|
|*    Turns the cursor back on.  Should work for any system.              *|
|*    Requires the header file 'bios.h' be #included.                     *|
|*                                                                        *|
|*                 Homer Arment  -  14 June 87                            *|
\**************************************************************************/

void cursor_on(void)
{
    unsigned int equip;
    int upper_line,lower_line;


    equip=biosequip();
    if((equip & 0x30)==0x30){   /* If monochrome card value will be 0x30 */
        _CH = 12;  	/* for monochrome card			*/
        _CL = 13;
    }
    else{
        _CH = 6;		/* for color card			*/
        _CL = 7;
    }	
    _AH = 0x01;		/* use BIOS to form cursor shape	*/
    geninterrupt(VIDEO);   /* call BIOS to do the work		*/
}


/**************************************************************************\
|* void getcursor_pos(int *row,int *col)                                  *|
|*                                                                        *|
|*    Locate the current active page and cursor position on that page.    *|
|*    Expects the address of row and col to be passed from the calling    *|
|*    function.  returns the value of the current active page and the     *|
|*    cursor position is placed in row and col of the calling function.   *|
|*                                                                        *|
|*                 Homer Arment  -  14 June 87                            *|
\**************************************************************************/


int getcursor_pos(unsigned int *row,unsigned int *col)
{

    int page;

    _BX = get_vid_mode();	/* Get the active page			*/
    _AH = 0x03;             	/* BIOS service to get cursor pos	*/
    geninterrupt(VIDEO);
    page=_BH;
    *row = _DH;       		/* Stuff value into row in main()	*/
    *col = _DL;       		/* Stuff value into col in main()	*/
    return(page);    		/* Return active page value		*/
}

/**************************************************************************\
|* put_ch_attr(char character,int attribute)                              *|
|*                                                                        *|
|*     Writes the character to the active screen at the current cursor    *|
|*     location using the attribute provided in the call.  Cursor         *|
|*     position is updated after the write.  If at col 80 the col is      *|
|*     set to 0 and row is incremented.  If the row is 24, row is set     *|
|*     to 0, so printing wraps to the top of screen                       *|
|*                                                                        *|
|*                 Homer Arment  -  14 June 87                            *|
\**************************************************************************/


void put_ch_attr(char character,int attribute)
{
    union REGS regs;
    unsigned int row,col;

    regs.h.bh = getcursor_pos(&row,&col); /* Get active page		*/
    regs.h.ah = 0x09;		/* Request to write char & attribute	*/
    regs.h.al = character;
    regs.h.bl = (char) attribute;
    regs.x.cx = 1;		/* Only write one character		*/
    int86(VIDEO,&regs,&regs);
    col+=1;
    if (col==80){
        col=0;
        row+=1;
        if(row>24)
            row=0;
    }
    cursor_pos(row,col);
}

/**************************************************************************\
|* put_str_attr(char *string,int attribute)                               *|
|*                                                                        *|
|*    Writes a string to the screen using the attribute provided.  word   *|
|*    wrap occours at column 80.  \t,\n,\r etc. are not recognized.  If   *|
|*    the string wraps on line 24, the remainder will wrap to the top     *|
|*    of the screen.  The screen will not scroll up.                      *|
|*                                                                        *|
|*                 Homer Arment  -  14 June 87                            *|
\**************************************************************************/


void put_str_attr(char *string,int attribute)
{
    int i;

    for(i=0;i<strlen(string);i++)
        put_ch_attr(string[i],attribute);
}


/**************************************************************************\
|*  void screen_color(int attribute)                                      *|
|*                                                                        *|
|*  Clears the screen to passed attribute.  Returns nothing.  No check    *|
|*  is made for a valid attribute.                                        *|
|*                                                                        *|
|*                 Homer Arment  -  14 June 87                            *|
\**************************************************************************/

void screen_color(int attribute)
{
    union REGS regs;

    regs.h.bh = attribute;
    regs.h.ah = 0x06;	/* Set ah =6 for BIOS screen scroll up call	*/
    regs.h.al = 0;	/* and al=0 to blank whole screen		*/
    regs.h.ch=0;	/* start at row 0				*/
    regs.h.cl = 0;	/* and col 0 					*/
    regs.h.dh = 0x18;	/* end at row 24				*/
    regs.h.dl = 0x4f;	/* and col 79					*/
    int86(VIDEO,&regs,&regs);	/* call to interrupt 10H to do work	*/
}


/**************************************************************************\
|*  void border_color(int attribute)                                      *|
|*                                                                        *|
|*  Changes the border to the passed attribute.  Returns nothing.  Mod    *|
|*  arithmetic is used to force the attribute in range.                   *|
|*                                                                        *|
|*                 Homer Arment  -  14 June 87                            *|
\**************************************************************************/


void border_color(int attribute)
{
    attribute=attribute % 16;
    _AH = 0x0b;
    _BX = attribute;
    geninterrupt(VIDEO);
}
