#include <stdio.h>
#include "diskio.h"


#if AZTEC | LATTICE | WIZARD
#include <fcntl.h>
#endif

#if MICROSOFT
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#endif


extern FILE *fopen();
extern long lseek(), ftell();
extern long randpos();

extern long filesize;
extern char test_disk[];


char buf[1024];

/*      fcharcpy / charcpy
 *
 * These routines perform character oriented disk i/o.  They simply copy a
 * file.  One routine performs buffered i/o and the other does the same thing
 * with unbuffered i/o.
 */


int fcharcpy (loop)
        {
        char inf[80], outf[80];

        strcpy (inf, test_disk);
        strcat (inf, INFILE);

        strcpy (outf, test_disk);
        strcat (outf, OUTFILE);

        return (dofcharcpy (loop, inf, outf));
        }



int charcpy (loop)
        {
        char inf[80], outf[80];

        strcpy (inf, test_disk);
        strcat (inf, INFILE);

        strcpy (outf, test_disk);
        strcat (outf, OUTFILE);

        return (docharcpy (loop, inf, outf));
        }




int dofcharcpy (loop, datain, dataout)
        int loop;
        char *datain, *dataout;
        {
        FILE *in, *out;
        register int c;


        timestart ();

        while (loop--)
                {
#if LATTICE
                if ((in  = fopen (datain, "rb")) == NULL)
                        return 0x8000;
                if ((out = fopen (dataout, "wb")) == NULL)
                        return 0x8000;
#else
                if ((in  = fopen (datain, "r")) == NULL)
                        return 0x8000;
                if ((out = fopen (dataout, "w")) == NULL)
                        return 0x8000;
#endif

                while ((c = fgetc (in)) != EOF)
                        fputc (c, out);

                fclose (in);
                fclose (out);
                }

        return (timend ());
        }



int docharcpy (loop, datain, dataout)
        int loop;
        char *datain, *dataout;
        {
        int in, out, c;


        timestart ();

        while (loop--)
                {
#if AZTEC
                if ((in  = open (datain, O_RDONLY)) == -1)
                        return 0x8000;
                if ((out = creat (dataout)) == -1)
                        return 0x8000;
#endif
#if LATTICE
                if ((in  = open (datain, O_RDONLY)) == -1)
                        return 0x8000;
                if ((out = open (dataout, O_RAW|O_RDWR|O_TRUNC|O_CREAT,
                                                S_IWRITE|S_IREAD)) == -1)
                        return 0x8000;
#endif
#if MICROSOFT
                if ((in  = open (datain, O_RDONLY)) == -1)
                        return 0x8000;
                if ((out = creat (dataout, S_IREAD | S_IWRITE)) == -1)
                        return 0x8000;
#endif
#if WIZARD
                if ((in  = _open (datain, O_RDONLY | O_BINARY)) == -1)
                        return 0x8000;
                if ((out = _creat (dataout, O_RDWR)) == -1)
                        return 0x8000;
#endif

                while (read (in, &c, 1) != 0)
                        write (out, &c, 1);

                close (in);
                close (out);
                }

        return (timend ());
        }

/*      fbufcpy / bufcpy
 *
 * These routines perform disk i/o by reading and writing large buffers of
 * data.  They simply copy a file.  One routine uses the compiler's buffered
 * i/o and the other does the same thing with unbuffered i/o.
 */


int fbufcpy (loop)
        {
        char inf[80], outf[80];

        strcpy (inf, test_disk);
        strcat (inf, INFILE);

        strcpy (outf, test_disk);
        strcat (outf, OUTFILE);

        return (dofbufcpy (loop, inf, outf));
        }



int bufcpy (loop)
        {
        char inf[80], outf[80];

        strcpy (inf, test_disk);
        strcat (inf, INFILE);

        strcpy (outf, test_disk);
        strcat (outf, OUTFILE);

        return (dobufcpy (loop, inf, outf));
        }



int dofbufcpy (loop, datain, dataout)
        int loop;
        char *datain, *dataout;
        {
        FILE *in, *out;
        int numchar;


        timestart ();

        while (loop--)
                {
#if LATTICE
                if ((in  = fopen (datain, "rb")) == NULL)
                        return 0x8000;
                if ((out = fopen (dataout, "wb")) == NULL)
                        return 0x8000;
#else
                if ((in  = fopen (datain, "r")) == NULL)
                        return 0x8000;
                if ((out = fopen (dataout, "w")) == NULL)
                        return 0x8000;
#endif

                while ((numchar = fread (buf, sizeof (buf), 1, in)) != 0)
                        fwrite (buf, 1, numchar, out);

                fclose (in);
                fclose (out);
                }

        return (timend ());
        }



int dobufcpy (loop, datain, dataout)
        int loop;
        char *datain, *dataout;
        {
        int in, out, numchar;


        timestart ();

        while (loop--)
                {
#if AZTEC
                if ((in  = open (datain, O_RDONLY)) == -1)
                        return 0x8000;
                if ((out = creat (dataout)) == -1)
                        return 0x8000;
#endif
#if LATTICE
                if ((in  = open (datain, O_RDONLY)) == -1)
                        return 0x8000;
                if ((out = open (dataout, O_RAW|O_RDWR|O_TRUNC|O_CREAT,
                                                S_IWRITE|S_IREAD)) == -1)
                        return 0x8000;
#endif
#if MICROSOFT
                if ((in  = open (datain, O_RDONLY)) == -1)
                        return 0x8000;
                if ((out = creat (dataout, S_IREAD | S_IWRITE)) == -1)
                        return 0x8000;
#endif
#if WIZARD
                if ((in  = _open (datain, O_RDONLY | O_BINARY)) == -1)
                        return 0x8000;
                if ((out = _creat (dataout, O_RDWR)) == -1)
                        return 0x8000;
#endif

                while ((numchar = read( in, buf, sizeof(buf))) != 0)
                        write (out, buf, numchar);

                close (in);
                close (out);
                }

        return (timend ());
        }

/*      fseekio / seekio
 *
 * These routines perform disk i/o by seeking then reading a byte.  One
 * routine uses the compiler's buffered i/o and the other does the same
 * thing with unbuffered i/o.
 */


int fseekio (loop)
        {
        char df[80];

        strcpy (df, test_disk);
        strcat (df, INFILE);
        return (dofseekio (loop, df));
        }



int seekio (loop)
        {
        char df[80];

        strcpy (df, test_disk);
        strcat (df, INFILE);
        return (doseekio (loop, df));
        }



int dofseekio (loop, datafile)
        int loop;
        char *datafile;
        {
        long pos;
        FILE *testf;


        if ((testf = fopen (datafile, "r")) == NULL)
                return 0x8000;

        fseek (testf, 0L, 2);
        filesize = ftell (testf);

        timestart ();

        while (loop--)
                {
                pos = randpos ();

                fseek (testf, pos, 0);
                fgetc (testf);
                }

        fclose (testf);
        return (timend ());
        }



int doseekio (loop, datafile)
        int loop;
        char *datafile;
        {
        char junk;
        int testf;
        long pos;


#if WIZARD
        if ((testf = _open (datafile, O_RDWR | O_BINARY)) == -1)
                return 0x8000;
#else
#if LATTICE
        if ((testf = open (datafile, O_RAW | O_RDWR)) == -1)
                return 0x8000;
#else
        if ((testf = open (datafile, O_RDWR)) == -1)
                return 0x8000;
#endif
#endif

        filesize = lseek (testf, 0L, 2);

        timestart ();

        while (loop--)
                {
                pos = randpos ();

                lseek (testf, pos, 0);
                read (testf, &junk, 1);
                }

        close (testf);
        return (timend ());
        }

