/*      timer.c
**
** Routines to time functions.
*/


#if LATTICE | MICROSOFT
#include <dos.h>
#endif

#if WIZARD
#include <bdos.h>
#endif


#define TIME_LOOP       100


#if LATTICE | MICROSOFT | WIZARD
static union REGS inregs, strtregs, endregs, ohds, ohde;
#endif


#if AZTEC
static struct regval
        {
        int ax, bx, cx, dx;
        int si, di, ds, es;
        } inregs, strtregs, endregs, ohds, ohde;
#endif



/*      timestart / timend
**
** Remember the current system time in structure strtregs.  This will be used
** when timend is called to determine the total duration.
*/


timestart ()
        {
#if LATTICE | MICROSOFT | WIZARD
        inregs.x.ax = 0x2c00;
        int86 (0x21, &inregs, &strtregs);
#endif

#if AZTEC
        inregs.ax = 0x2c00;
        sysint (0x21, &inregs, &strtregs);
#endif
        }



int timend ()
        {
        register int tot;
        int startcx, startdx, endcx, enddx;


#if LATTICE | MICROSOFT | WIZARD
        inregs.x.ax = 0x2c00;
        int86 (0x21, &inregs, &endregs);
        startcx = strtregs.x.cx;
        endcx = endregs.x.cx;
        startdx = strtregs.x.dx;
        enddx = endregs.x.dx;
#endif

#if AZTEC
        inregs.ax = 0x2c00;
        sysint (0x21, &inregs, &endregs);
        startcx = strtregs.cx;
        endcx = endregs.cx;
        startdx = strtregs.dx;
        enddx = endregs.dx;
#endif

/* Calculate the total time in tenths of a second.  First figure the hours,
** then the minutes and seconds, and finally the tenths of seconds.  Round
** the hundredths of the second.
*/
        tot = 36000 * (((endcx >> 8) & 0xff) - ((startcx >> 8) & 0xff));
        tot += 600 * ((endcx & 0xff) - (startcx & 0xff));
        tot += 10 * (((enddx >> 8) & 0xff) - ((startdx >> 8) & 0xff));
        tot += (((enddx & 0xff) - (startdx & 0xff)) + 5) / 10;
        return tot;
        }



/*      timeohd
**
** Figure out the approximate timer overhead.
*/


int timeohd ()
        {
        register int i, tot;
        int startcx, startdx, endcx, enddx;
        int junk;


#if LATTICE | MICROSOFT | WIZARD
        inregs.x.ax = 0x2c00;
        int86 (0x21, &inregs, &ohds);
#endif

#if AZTEC
        inregs.ax = 0x2c00;
        sysint (0x21, &inregs, &ohds);
#endif


        for (i = TIME_LOOP;  i--;  )
                {
                timestart ();
                junk = timend ();
                }


#if LATTICE | MICROSOFT | WIZARD
        inregs.x.ax = 0x2c00;
        int86 (0x21, &inregs, &ohde);
        startcx = ohds.x.cx;
        endcx = ohde.x.cx;
        startdx = ohds.x.dx;
        enddx = ohde.x.dx;
#endif

#if AZTEC
        inregs.ax = 0x2c00;
        sysint (0x21, &inregs, &ohde);
        startcx = ohds.cx;
        endcx = ohde.cx;
        startdx = ohds.dx;
        enddx = ohde.dx;
#endif


/* Calculate the total time in tenths of a second.  First figure the hours,
** then the minutes and seconds, and finally the tenths of seconds.  Round
** the hundredths of the second.
*/
        tot = 36000 * (((endcx >> 8) & 0xff) - ((startcx >> 8) & 0xff));
        tot += 600 * ((endcx & 0xff) - (startcx & 0xff));
        tot += 10 * (((enddx >> 8) & 0xff) - ((startdx >> 8) & 0xff));
        tot += (((enddx & 0xff) - (startdx & 0xff)) + 5) / 10;
        return ((tot + (TIME_LOOP / 2)) / TIME_LOOP);
        }

