Path: aurora!ames!rutgers!pyrnj!mirror!.pc!inmet!gordon
From: gordon@inmet.UUCP
Newsgroups: comp.sys.ibm.pc
Subject: Tel Communications Program
Message-ID: <127500001@inmet>
Date: 5 Dec 86 01:41:00 GMT
Lines: 816
Nf-ID: #N:inmet:127500001:000:35474
Nf-From: inmet.UUCP!gordon    Dec  4 20:41:00 1986


Here is another terminal emulation program, called Tel.  As you might
guess from the name, one of the design goals was to make it as small and
simple as possible.  Briefly, the program has the following features: 

      - Self explanatory command interface - just type ? for help
      - VT-52 and VT-100 terminal emulation
      - XModem and ASCII file transfer
      - Redefine almost any key on the keyboard (except shift keys)
      - VMS 4.x style history mechanism (recalls and retypes up to 24
	previously typed lines)
      - DOS command to run other programs without exiting Tel
      - Reliable operation at 9600 baud (and above on faster CPU's)
      - Complete script language
      - Executable is only 45K bytes in size

If you want Kermit protocol, you can safely run Kermit from within Tel
using the DOS command.  Let me know if this isn't good enough.

To give the flavor of the script language, here is a segment of a script
used to logon to a Unix system (the file PASSWORD.TXT is assumed to
contain your name, group, and password separated by white space):

	Return = "^M";
	open "PASSWORD.TXT" to read;
	read User, Group, Password; close;
	loop
	    if wait 30 for ":" then
		if match "name:" then type User Return;
		else if match "last login" then exit;
		else if match "login:" then type User Return;
		else if match "group" then type Group Return; exit;
		else if match "password:" then type Password Return;
		else if match "incorrect" then type Return;
		end if;
	    else
		type Return;
	    end if;
	end loop;

This is "shareware" - I hope people find it useful.  What follows are
four files: mget.scr tel.hlp dial.scr hangup.scr, in shar format.  The
uuencoded executable TEL.EXE follows in a separate note.  Send me mail
if you have any trouble unpacking or using this program.

		Michael Gordon		inmet!gordon (617) 661-1840
					PO Box 9185, Boston MA 02114

Disclaimer: This software has absolutely nothing to do with my employer,
Intermetrics Inc., Cambridge Mass.

- - - - - - - - - - - - - - cut here - - - - - - - - - - - - - -
: to unbundle, "sh" this file -- DO NOT use csh
:  SHAR archive format.  Archive created Thu Dec 4 20:38:18 EST 1986
echo x - mget.scr
sed 's/^X//' > mget.scr <<'+FUNKY+STUFF+'
X------------------------------------------------------------------------
X-- MGet: Script to get a bunch of files from a Unix system
X-- Invoke with up to four parameters to specify the files to be copied
X-- to the PC.  You should select a protocol and define GetCommand
X-- before using this script.
X------------------------------------------------------------------------
XNL = "^M";
X
X-- Check the parameters:
Xif not P1 then P1 = ""; end if;
Xif not P2 then P2 = ""; end if;
Xif not P3 then P3 = ""; end if;
Xif not P4 then P4 = ""; end if;
X
X-- Get the list of files to get:
XFile = "mget.lst";
Xtype "ls " P1 " " P2 " " P3 " " P4 "> ~/" File NL;
Xtel "get", File, "~/" File;
X
X-- Get the files themselves:
Xopen File to read;
Xloop
X    read L;			-- Read a line from input file
X    if EOF then exit;		-- Check for EOF
X    end if;
X    tel "get " L " " L;		-- Have remote send over the file
X    timeout 15; 
Xend loop;
X
Xecho "^G";
X------------------------------------------------------------------------
+FUNKY+STUFF+
echo '-rw-r--r--  1 gordon        990 Dec  4 09:40 mget.scr    (as sent)'
chmod u=rw,g=r,o=r mget.scr
ls -l mget.scr
echo x - tel.hlp
sed 's/^X//' > tel.hlp <<'+FUNKY+STUFF+'
X		    Copyright 1986 - Michael Gordon
X.license
XTel is copyrighted material.  In return for a small registration fee,
Xyou may use a copy of Tel personally on any machine that runs it.  You
Xare encouraged to make copies and give them to anyone who is willing to
Xpay the registration fee.  Please abide by this agreement, as it is the
Xonly way this software could be made available to you. 
X
XTo register your copy of Tel, send $10.00 to Information Products, P.O.
XBox 9185, Boston, MA 02114.  Be sure to give the version number
Xdisplayed when the program first starts up.  You will receive a printed
Xmanual by return mail.  If a new release has been made since you
Xobtained your copy, it will be included with the manual. If you have any
Xsuggestions for improvements, please mention them.  If suggestions you
Xmake are incorporated into a future release of the program, you will
Xreceive that as well.  Thank you for your support.
X.quit
XThe QUIT command is used to terminate a session with Tel.  This is the
Xonly way to get out of Tel, since the control-break interrupt is
Xdisabled.  It has the following form:
X
X    <Tel>: QUIT (Finished?) yes-or-no
X
XIf you enter any word starting with "Y", Tel returns to DOS.  Otherwise,
Xthe quit command is ignored.  If you are getting or logging to a file,
Xthe file is closed before Tel exits -- no data will be lost.  
X.help
XPress [?] at any time while entering a command for brief help.  For
Xdetails, use the HELP command:
X
X    <Tel>: HELP topic-name
X
Xwhere topic-name is one of the following:
X
XbaudRate	getEOF		Protocol	sendNL
XDefine		HANGUP		Quit		Set
XDIAL		Help		Save		Stop
XDos		License		scripts		Terminal
XDuplex		List		Send		Trace
XFlow		Log		sendCommand	VT100
XGet		Parity		sendDelay	VT52
XgetCommand	Perform		sendEOF		
X
XThe following is a brief introduction to Tel:
X
X-- Tel Features:
X
X  * Emulation of VT-100 and VT-52 terminals
X  * Keyboard Macros - redefine almost any key on the keyboard
X  * File transfer capability - XModem and Text protocols
X  * Command History - instant recall and reentry of previously typed lines
X  * Automatic terminal sessions using scripts
X  * Reliable operation at 9600 baud and above
X  * Invoke other DOS programs without leaving Tel
X
XNote: in this help file, "host" refers to the system to which Tel is
Xconnected and "local" refers to the PC which is running Tel.
X
XWhen Tel is starts up, it emulates a VT-100 terminal: anything you type
Xon the keyboard is sent along to the serial port (COM1 or COM2) and
Xanything arriving over the port is displayed on the screen.  At startup
XTel looks for a script called TELINIT.SCR, first in the current
Xdirectory and then in the directory specified by the TEL environment
Xvariable.  If found, this file is executed immediately.  No parameters
Xcan be passed to TELINIT.  The settings and keyboard definitions you
Xprefer can be placed in this script so that Tel always comes up
Xinitialized according to your personal preferences (after you find a
Xsatisfactory setup, use SAVE TELINIT to create TELINIT.SCR).
X
X-- Command Line Syntax:
X
X    A> TEL [com-port] [script-name [parameters...]]
X
XThere are two command line options: a serial port can be specified, and
Xthe name of a script (optionally followed by additional parameters for
Xthe script itself) can be given.  If the com-port is omitted, it
Xdefaults to COM1.  If specified, it must be COM1 or COM2. If script-name
Xwas given on the command line, the remaining parameters are passed to
Xthis script, which is executed immediately after TELINIT.
X
X-- Entering Tel Commands
X
XPress [Home] to enter Tel commands.  Press [Esc] to return to terminal
Xemulation mode.  Certain commands return to terminal emulation mode
Ximmediately.  During command entry, press [?] for help.
X
X-- Command Recall
X
XTel stores the last 24 lines that have been typed to the host system in
Xa circular buffer.  Press [End] to recall a previously typed command,
X(it will appear in reverse video).  Use the up- and down- arrow keys to
Xscroll through the saved lines.  The left- and right- arrow keys move
Xwithin the saved line, which can be modified before it is re-sent.  Use
X[Ins] to insert new text.  Use [<-] (backspace) to delete unwanted text.
XPress [Enter] when you want the recalled text to be sent or [Esc] to
Xcancel the command recall mode without sending anything. 
X
X-- Installation
X
XTo install Tel, place the TEL.EXE file in any directory that is in your
XDOS command search path.  If you wish, create a TEL subdirectory, say
XC:\TEL, and add the command SET TEL=C:\TEL in your AUTOEXEC.BAT file. 
XIf the TEL environment variable is defined in this way, Tel will look
Xthere for any file that it cannot find in the current directory, including
Xthe help file TEL.HLP and any script specified on the PERFORM command. 
X
X-- Bugs and Limitations
X
X 1. Tel can't detect if a file is incomplete because of insufficient
X    disk space.  Be sure there is plenty of space before you get a file.
X
X 2. Some hardware (possibly the EGA and some speedup boards) disable
X    interrupts for such a long time that characters from the serial
X    port are lost.
X
X 3. Tel neither sets nor senses the RS-232 handshaking lines DSR, DTR,
X    CTS, etc.  
X.hangup
XHANGUP.SCR is a script which disconnects the Hayes Smartmodem and exits
Xfrom Tel.  To use it, enter the following command:
X
X    <Tel>: PERFORM (script file) HANGUP [Enter] [Enter]
X
XThe file HANGUP.SCR must be in your default directory or in the directory
Xgiven by the TEL environment variable (created by the PC-DOS command "SET")
Xor the script file will not be found.  If you do not have a Hayes
Xcompatable modem, you may easily modify this script to work with your
Xmodem. 
X.dos
XThe DOS command allows you to run any other program without leaving Tel.
XIt prompts for a command as follows:
X
X    <Tel>: DOS (command) ""
X
XEnter any command that you might type at the DOS prompt.  When you press
X[Enter], the command will be executed.  If you just press [Enter]
Xwithout typing anything else, you will be placed in a "sub-shell", which
Xputs Tel in the background and puts you back into DOS.  When you are
Xfinished with DOS, type "exit" to return to Tel.  Unless you run some
Xother program that uses the serial port that Tel is using, anything that
Xcomes in over the COM port while Tel is suspended will be held until you
Xreturn to Tel (up to about 4000 characters). 
X.log
XThe LOG command is used to record text displayed on the screen in a local
Xfile.  It prompts for a single file name:
X
X    <Tel>: LOG (local file) file-name
X
XAfter a LOG command is issued, each character displayed on the screen is
Xalso recorded in the specified file.  If the file already existed, the
Xnew text is appended to the old file.  The logging action can be stopped
Xwith the STOP LOG command.
X.list
XThe LIST command has four sub-commands:
X
X    LIST STATUS
X    LIST KEYS
X    LIST FILE file-name
X    LIST DIRECTORY file-specification
X
XLIST STATUS displays the current values of all settable items, (see the
XSET command), the status of any file transfer operation currently in
Xprogress, as well as the current time and date.
X
XLIST KEYS shows any keyboard characters which have been redefined (using
Xthe DEFINE command) and their definitions.
X
XLIST FILE displays a local file on the screen, one screen at a time.
X
XLIST DIRECTORY displays a listing of a directory.  The file-specification
Xmay include wild characters "*" and "?", and may include a drive letter
XExamples: *.*, B:*.BAS, B:\work, etc.
X.Duplex
XDuplex can be set to FULL, where transmitted characters must be echoed
Xby the host system in order to appear on the screen, or HALF, where
Xcharacters are displayed as they are transmitted.  The initial value is
XFULL, which is appropriate for most host computers.
X.dial
XDIAL is a script to dial a phone number using the Hayes SmartModem.  (You
Xcan modify it to work with any other autodialing modem.)  It can be invoked
Xwith from one to three phone numbers; if the first number is busy, it will
Xtry the second and so on, until a connection is made.  For example:
X
X    <TEL>: PERFORM DIAL "2921900 5551212" [Enter]
X
XThis command will first dial 292-1900, and if that is busy, try 555-1212.
XIf that is busy, the first number will be tried once again.  This will
Xcontinue until either a connection is established or you stop the script.
X.define
XThe define command associates a string of text (up to 63 characters)
Xwith a key on the keyboard.  After a key is defined, pressing the key
Xcauses the full definition to be typed.  The command looks like this:
X
X    <Tel>: DEFINE (key) key (as) "string"
X
XAny character can be included in a key definition, including control
Xcodes and function keys.  If you need to include a special character in
Xa key definition, (such as backspace, which normally deletes the
Xcharacter you just entered) use [^Q] followed by the character you wish
Xto enter.  For example, to define [Backspace] as DELETE (ctrl-backspace,
XASCII code 127), enter the following into the Tel command buffer:
X
X    DEF [space] [^Q] [<-] [space] [^Q] [^<-] [Enter]
X
XIt is impossible to redefine [space], [?], and any of the shift keys.
X.scripts
XA script is made up of a sequence of statements that are executed one
Xafter the other.  Some statements can contain other statements (such as
Xthe LOOP statement).  These are called compound statements.  Most
Xstatements (all except the assignment statement) start with a keyword,
Xand all end with a semicolon.  In this document, keywords are given in
Xupper case.  In an actual script, case differences are ignored. 
X
XStatements may refer to variables, which can have numeric or string
Xvalues.  Comments can be included in scripts.  Everything following a
Xdouble dash (--) on a line is considered to be a comment and is ignored
Xwhen the script is executed. 
X
XThe following are the Tel script keywords:
X
X	CLOSE	EOF	IF	OPEN	TEL	TYPE
X	ECHO	EXIT	LOOP	QUIT	THEN	UNTIL
X	ELSE	FOR	MATCH	READ	TIMEOUT	WAIT 
X	END	GOTO	NOT	REPEAT	TO
X
XCHARACTER STRINGS
X
XCharacter strings are frequently used in scripts to supply text to be
Xsent to a host system or displayed on the screen.  A string is a double
Xquote (") followed by any number of characters and terminated by a
Xsecond double quote.  A double quote can be included within a string by
Xentering two of them in a row.  A string must fit on a single line,
Xand lines must be 127 characters long or shorter.
X
XSince it is frequently necessary to enter non-printing characters into
Xstrings, Tel uses two characters (caret [^] and sharp sign [#]) to
Xindicate that a non printing code is to be included in a string.  For
Xthis reason, to enter a single [^] or [#] in a quoted string, you must
Xtype two of them in a row: "##" or "^^". 
X
XThe caret (^) is used to enter control codes (ASCII characters with
Xvalues from 0 to 31 decimal) into character strings, much the same way
Xthey are printed in this help.  For example, the string "^M" (or "^m")
Xrepresents a single character, the ASCII carriage return code.  This is
Xthe code sent when you press the [Enter] key on the keyboard. 
X
XThe sharp sign is used to introduce a special key name.  Using this
Xnotation, a single function key code is indicated by a sharp sign
Xfollowed by the label on the key that you wish to enter surrounded by
Xsquare brackets.  Thus, "#[Home]" represents a string containing the single
Xcharacter that is generated when you press the [Home] key on the
Xkeyboard.  Alt-shifted alphabetic characters may also be entered in this
Xway (#[alt-A]).  The function keys are also specified in a similiar way:
X#[f1], #[F1], #[^f1], and #[alt-f1] indicate unshifted, shifted (upper
Xcase F), control-shifted, and alt-shifted function key F1 respectively. 
X
XThe sharp sign (#) may also be followed by a one to three digit number
Xgiving the decimal value of the code to be entered.  Thus, "#13" is
Xanother way to write a string that contains the single character [^M] or
X[Enter].  The decimal code generated by each key on the keyboard is
Xgiven in the IBM BASIC manual, in appendix G.  Note that for the
Xso-called "extended ASCII sequences", you must add 128 to the code given
Xin the manual.  Thus the [home] key is 128+71, or "#199" (of course,
X#[home] is a more convenient way to enter this code). 
X
XPARAMETERS IN SCRIPTS
X
XWhen a script is invoked, it can be given any number of parameters
X(provided they all fit in the command buffer).  These are assigned to
Xthe variables P1, P2, ...  Pn, where n is the number of parameters given
Xin the PERFORM command (or on the DOS command line if the script-name is
Xgiven when Tel is invoked from DOS).  In a script, you can use IF Pn...
Xto determine if an n'th parameter was entered.
X
XSIMPLE STATEMENTS
X
XThe simple statements are summarized in the following table.  In this
Xtable, "number" indicates a number (such as 10) or a variable that has a
Xnumeric value.  "Value" indicates that any value (either numeric or
Xcharacter string) can be used.  "Values" indicates that one or more
Xvalues of any type can be used in that statement.  "Variable" means that
Xa variable must be used.  A "label" is an identifier followed by a colon
X(:) placed just before a statement. 
X
X	Statement		Description
X	----------------        ----------------
X	variable = value;	Set a variable to a value
X	TYPE values;		Simulated keyboard input
X	ECHO values;		Display values locally without sending
X	WAIT number;		Wait fixed amount of time (tenths of second)
X	WAIT FOR value;		Wait for a string
X	WAIT number FOR value;	Wait specified amount of time for a string
X	WAIT UNTIL number;	Wait until a specified time
X	TIMEOUT number;		Wait for host to stop typing
X	OPEN value TO READ;	Open a local file
X	READ variables;		Read a line from OPENed file
X	CLOSE;			Close the local file
X	QUIT;			Terminates the script
X	GOTO label;		Skip to a labeled statement
X	EXIT;			Exit from a loop
X	REPEAT;			Repeat a loop
X	TEL values, values;	Tel command-buffer entry 
X
XTime delays in WAIT and TIMEOUT statements are measured in tenths of
Xseconds.  The time given to the WAIT UNTIL statement is an integer
Xrepresenting 24-hour time - 2030 represents 8:30 PM.
X
XEach time a READ statement is executed, it reads one line from the
Xcurrently OPEN file.  The first variable gets the first item (group of
Xnon-blank characters), the second the second item, etc., with the last
Xgetting the remainder of the line.  If only one variable is given it
Xgets the whole line.  If an item begins with a double quote character ("),  
Xthe item contains all characters up to the matching quote.
X
XThe complete IF-THEN-ELSE statement has the following form: 
X
X    IF condition THEN
X        statements
X    ELSE IF condition THEN
X        statements
X    ELSE
X        statements
X    END IF;
X
XThe ELSE IF and ELSE parts are optional, and there can be any number of
XELSE IF parts. 
X
XCONDITIONAL TESTS
X
XThe following expressions can be used in an IF statement:
X
X	Condition	Description
X	---------	-----------
X	EOF		True if end of OPENed file has been reached, or if no
X			file has been opened, or if file was opened and then
X			closed.  Use after a READ.
X
X	MATCH string	True if string has been received from the host since
X			the last TYPE statement was executed.
X
X	variable	True if variable has a value
X
X	left == right	True if value of left is equal to the value of right.
X
X	NOT		Negates the following test.
X
X	WAIT number for string
X			True if string is received within the amount of time
X			specified by number, in tenths of seconds.
X
XTHE LOOP STATEMENT
X
XThe loop statement has the following form:
X
X    LOOP
X        statements
X    END LOOP;
X
Xwhere statements is replaced by any sequence of statements, including
Xother loops if desired.  Two statements, REPEAT and EXIT, are intended
Xspecifically for use in a loop.  REPEAT is used to restart a loop at the
Xtop.  EXIT is used to exit from a loop and continue the script from the
Xfirst statement after the END LOOP. 
X.set
XThe SET command is used to select options that control certain Tel
Xfunctions. These include communications parameters, terminal emulation,
Xfile transfer options, and script tracing.  The command is entered as
Xfollows: 
X
X    <Tel>: SET item (to) value
X
XThe following items can be set:
X
X	BaudRate	Parity		SendNL
X	Duplex		Protocol	Trace
X	Flow		SendCommand	Terminal
X	GetCommand	SendDelay
X	GetEOF		SendEOF
X
XUse HELP <item-name> for an explanation of any of these items.
X.send
XThe SEND command transfers a file from the PC to the host system using
Xthe protocol determined by the SET PROTOCOL command (XModem or Text). It
Xhas the following form:
X
X    <Tel>: SEND local-file (to) "host-file"
X
XThe default for host-file is whatever you specified for local-file.
X
XIf you have not SET SendCommand, then the host system must be prepared
Xto receive a file before you enter the SEND command.  If you have set
XSendCommand, then Tel will use it as a command template, replacing the
Xfirst single $ character in it with the host-file name and then sending
Xit to the host system.  This should prepare it to receive the file you
Xare sending.  For additional information, use HELP SendCommand.  
X
XIf you are using Text protocol, use HELP SendNL, SendDelay, and SendEOF
Xfor information on how these items are used to control sending files
Xwhen the Text protocol is in use.
X.SendEOF
XWhen the Text protocol is in use, Tel sends a file line by line as if
Xyou were typing the whole file in on the terminal.  To make this work,
Xthe host system must be running a text editor or some other program that
Xaccepts input from the keyboard.  The SendEOF variable is provided so
Xthat Tel can signal the end of the file to this program.  When the last
Xline of the file has been sent, the value of this variable is sent to
Xthe host system.  If you are connected to a Unix system, the SendEOF is
Xusually "^D".  On a VAX VMS system, "^Z" is usually used.
X.SendNL
XWhen the Text protocol is in use, Tel sends a file line by line as if
Xyou were typing the whole file in on the terminal.  To make this work,
Xthe host system must be running a text editor or some other program that
Xaccepts input from the keyboard.  The SendNL variable is provided
Xbecause different programs or hosts may expect lines of text to end in
Xdifferent ways.  Since most systems expect lines to end with a single
X[Enter], this is the value sent if the SendNL variable has no value.
XThe most common other setting is "^M^J", which is [Enter] followed by a
Xline feed character.  This is entered in the following way:
X
X    <Tel>: SET SENDNL [space] "[^Q] [Enter] [^Q] [^J] [Enter]"
X
XThe [^Q] combination is used to enter special characters (such as [Enter]
Xand line-feed into a string.
X
XSendNL is used only when the Text protocol is being used to send a file
Xto the host system.
X.SendDelay
XWhen the Text protocol is in use, Tel sends a file line by line as if
Xyou were typing the whole file in on the terminal.  Since some systems
Xcannot accept input as fast as Tel can send it, the SendDelay variable
Xallows you to program a pause at the end of each line sent.  This delay
Xis measured in tenths of seconds.  The initial value is zero.
X
XWhen Tel is sending a file using the Text protocol, it sends each line
Xof text at full speed, then waits up to .2 seconds for the line feed which
Xis normally echoed after the [Enter] that ended the line of text, and 
Xfinally waits the amount of time specified by SendDelay.
X.SendCommand
XSendCommand is a string which serves as a template used to construct a
Xcommand for the host system.  This command will prepare it to receive
Xthe file about to be sent using the selected protocol.  If SendCommand
Xis defined, Tel automatically initiates the file transfer when SEND is
Xinvoked.  The actual command used is constructed by replacing the first
X$ in this string by the host-file name entered when SEND is invoked. 
XIf a single $ character must be included in this command, put two adjacent
Xdollar sign characters ($$) in the SendCommand command template. 
X
XIf SendCommand is not defined, you must initiate each transfer manually. 
XSome systems (eg.  most bulletin board systems) support the XModem
Xprotocol but have a menu driven user interface, so that there is no
Xcommand you can send to the system to initiate the transfer.  In these
Xcases, you should leave SendCommand undefined and either start the
Xtransfer manually, or write a script to perform the transfer automatically. 
X.BaudRate
XThe BaudRate setting determines the communications rate.  Acceptable
Xvalues are 110, 300, 600, 1200, 2400, 4800, 9600, 19.2K and 38.4K baud.
XThe initial value is 300.  Although Tel running on an ordinary IBM PC
Xcannot update the display at a continuous 38.4K rate, it does have an
Xinput buffer of 4000 characters.  No received characters will be lost
Xunless this buffer overflows. 
X.Flow
XA "flow-control" protocol allows two computers to signal each other to
Xstop sending data when there is danger that data will be lost.  If flow
Xis ON, Tel recognizes and uses the standard ASCII XON/XOFF flow control
Xprotocol.  If the host system is transmitting so fast that Tel can't
Xkeep up, Tel sends XOFF (^S) to signal the host to stop.  When it can
Xaccept more input, it sends XON (^Q) to the host system.  In the other
Xdirection, if Tel is sending too fast for the host system, and the host
Xsystem sends XOFF, Tel will stop sending until an XON is received from
Xthe remote.
X
XIn effect, an XOFF received by Tel when Flow is ON locks the keyboard. 
XIt will be unlocked when XON is received or if you press the [Home] key
Xto enter a Tel command or when you send a break by pressing [Alt-B] on
Xthe keyboard. 
X.get
XThe GET command is used to get a file from the host system using the
Xprotocol (XModem or Text) you have selected.  It has the form:
X
X    GET local-file (from) "host-file"
X
XThe default for host-file is whatever you specified for local-file.
X
XIf you have selected the XModem protocol, you should start the file
Xtransfer on the host system first.  When the host system is ready to
Xsend the file, invoke GET.  This is the normal mode of operation with a
Xmenu driven host system. In this case, the host-file name is ignored. 
X
XIf you have selected the Text protocol, invoke GET first, return to
Xterminal mode, and type a command to the host system which causes it
Xto list the file you want to get.  As the host system types out the
Xfile, Tel records it in the specified file on the PC.  When the file
Xends, use the STOP GET command to close and write out the local file. 
X
XYou can SET GetCommand and Tel will then know how to start getting the
Xfile automatically.  For a text-protocol get, you may set GetEOF so that
XTel can automatically recognize that the file has ended (Use HELP GetEOF
Xand HELP GetCommand for details). 
X
XWarning: Tel cannot detect if you run out of space on disk for the file
Xyou are getting.  Be sure there is plenty of space.  This bug is in PC DOS
Xor the C compiler run time library so there is little we can do to fix it!
X.GetEOF
XGetEOF is a text string which is sent by the host system after a file is
Xlisted.  When these characters are received from the host during a
XText-protocol GET, Tel recognizes that the transfer is complete, closes
Xthe local-file, and stops getting.  GetEOF is not needed or used during
Xa XModem-protocol transfer. 
X
XA typical setting for GetEOF is "% " or "$ ", which will terminate the
Xtransfer when the host system transmits the system prompt.  Use caution
Xwith GetEOF, because the file you are getting may contain the GetEOF
Xstring and the transfer will be terminated prematurely.  Placing the
XASCII control codes for [Enter] and [line feed] in the string may help
X(eg.  "^J% ").  If the GetEOF string is used, it will never appear in a
Xfile: the transfer is stopped before the GetEOF string is added to the
Xfile.  This may save some editing.
X.GetCommand
XGetCommand is a command template used to construct the command that
Xshould be sent to the host system to cause it to send the contents of a
Xfile you want to get.  It is used to automatically initiate a file
Xtransfer when GET is invoked.  If GetCommand is not defined, you must
Xinitiate the transfer manually (or in a script) before invoking GET.
XNote that when you change Protocol, you will need to change this
Xdefinition. 
X
XThe first $ in this string is replaced by the host-file name obtained
Xwhen GET is invoked, and the resulting command is transmitted to the
Xhost system as if it had been typed on the keyboard.
X
XFor example, if you have selected the TEXT protocol, and the host system
Xtypes out the file X.DAT when you enter "TYPE X.DAT", GET COMMAND should
Xbe set to "TYPE $".  An [Enter] is always sent after this command.
X.Parity
XThe setting of Parity determines the parity of transmitted characters.
XAcceptable values are ODD, EVEN, and NONE.  The initial value is NONE.
X
XParity is automatically changed to NONE when the XModem protocol is
Xselected.  Tel does not check the parity of incoming data; this setting
Xaffects transmitted characters only.  
X.Protocol
XTel supports two file transfer protocols, TEXT and XModem.  The initial
Xvalue of Protocol is XModem.  Text protocol requires minimal support
Xfrom the host system but does not check for file transmission errors.
XXModem protocol requires support from the host system, checks for and
Xcorrects most transmission errors, and is capable of transferring both
Xtext and binary files.  The XModem protocol is supported by all bulletin
Xboard systems and by many personal computer communications programs. 
X.Trace
XIf trace is ON, Tel displays each command from a script as it is being
Xperformed.  This is useful for debugging scripts.  The initial value for
XTrace is OFF. 
X.Terminal
XThe setting of Terminal determines the type of terminal to be emulated
Xby Tel.  There are four acceptable values: VT-100, VT-52, PC, and Debug. 
XThe initial value is VT-100.  If PC is selected, characters received
Xfrom the host system are simply echoed to the screen through DOS.  If
XVT-100 is selected, Tel emulates the DEC VT-100 terminal.  If VT-52 is
Xselected, Tel emulates the DEC VT-52 terminal.  If Debug is selected,
Xall control codes are displayed on the screen using up-arrow notation
X(eg.  ^M for [Enter], and characters outside of the ASCII character set
Xare displayed in decimal notation (eg.  #128 for a null byte with the
Xparity bit set).  This mode is useful when you are getting unprintable
Xtext from the host system and are debugging a script or some other
Xcommunications program. 
X.save
XThe SAVE command records all settable items and key definitions in a
Xscript.  The PERFORM command can subsequently be used to restore the
Xdefinitions.  This command has the following form:
X
X    <Tel>: SAVE (settings on file) local-file
X
XThe local-file name need not include a suffix -- SAVE always uses a
Xfile-name suffix of .SCR, which is the extension expected by the PERFORM
Xcommand.
X
XIf you save the current settings in a file called TELINIT.SCR, they will
Xautomatically be restored the next time you run Tel.
X.stop
XThe STOP command is used to stop Tel a script or file transfer.  It
Xis entered as follows:
X
X    <Tel>: STOP LOG-or-GET-or-SEND-or-SCRIPT
X
XIf a LOG or GET is stopped, the local-file is closed and the file
Xtransfer ends.
X
XIf a SEND command is stopped, the file being sent is closed and
Xsending terminates.
X
XIf a script is stopped, execution of the script stops as soon as the
Xnext statement in the script is executed.  In addition, if the current
Xscript was called from some other script, both of them are stopped.
X.perform
XThe PERFORM command is used to initiate a script. It has the following
Xform:
X
X    <Tel>: PERFORM (from local file) file-name "parameters..."
X
XScripts are completely checked for syntax errors before being executed.
XIf errors are found, appropriate error messages are displayed and the
Xscript is not executed.  If no errors are found, Tel returns to terminal
Xmode and executes the script. 
X
XKeyboard input is accepted as usual while a script is in progress.  You
Xmay press the [Home] key at any time to interrupt a script and issue a
XTel command.  When you press [Esc] to return to terminal mode, the
Xscript will continue from the point where it was interrupted.
X
XAny number of parameters (separated by spaces) can be passed to a script.
X.VT100
XIn VT-100 terminal mode, the function keys and keypad on the PC are used
Xto simulate the VT-100 keypad as shown in the following table:
X
X	VT-100 Keypad	PC Keyboard
X       -----------------------------
X	PF1		[Shift-F1]
X	PF2		[Shift-F2]
X	PF3		[Shift-F3]
X	PF4		[Shift-F4]
X	Arrow keys	Arrow keys
X	1-9		F1-F9
X	0		F10
X	-		[PgUp]
X	,		[PgDn]
X	.		[Del]
X	[Enter]		[Ins]
X	[break]		[Alt-B]
X
XIf the arrow keys transmit numbers, press [Num Lock] to get the keypad
Xout of numeric mode.
X.VT52
XIn VT-52 terminal mode, the function keys and some keys on the keypad of
Xthe PC are used to simulate the VT-52 keypad as shown in the following table:
X
X	VT-52 Keypad	PC Keyboard
X       ------------------------------
X	Blue (F1)	[Shift-F1]
X	Red (F2)	[Shift-F2]
X	Gray (F3)	[Shift-F3]
X	Arrow keys	Arrow keys
X	1-9		F1-F9
X	0		F10
X	.		[Del]
X	[Enter]		Ins]
X	[break]		Alt-B]
X       ------------------------------
X
XIf the arrow keys transmit numbers, press [Num Lock] to get the keypad
Xout of numeric mode.
+FUNKY+STUFF+
echo '-rw-r--r--  1 gordon      29080 Dec  4 08:27 tel.hlp    (as sent)'
chmod u=rw,g=r,o=r tel.hlp
ls -l tel.hlp
echo x - dial.scr
sed 's/^X//' > dial.scr <<'+FUNKY+STUFF+'
X----------------------------------------------------------------
X-- DIAL.SCR V1.1 -- Try one to three numbers until answered
X----------------------------------------------------------------
X
XNL = "^M^J";	Enter = "^M";
X
XnextNumber:
X
XIF P3 THEN		-- If three numbers are available
X    Number = P1;	-- Use the first one and shift the rest
X    P1 = P2; P2 = P3; P3 = Number;
XELSE IF P2 THEN		-- If only two numbers are available
X    Number = P1;	-- Use the first one and shift other two
X    P1 = P2; P2 = Number;
XELSE IF P1 THEN		-- If only one number is available...
X    Number = P1;	-- Use the only one
XELSE
X    ECHO "?? No phone number passed to DIAL.SCR^G" NL;
X    TEL "CANCEL SCRIPT";	-- Cancel script
XEND IF;
X
XLOOP	-- Loop until modem notices:
X    TYPE "AT" Enter; WAIT 5;
X    IF MATCH "OK" THEN EXIT;
X    END IF;
XEND LOOP;
X
XLOOP	-- Dial the number
X    WAIT 2;
X    TYPE "AT D " Number Enter;
X    WAIT FOR "O";	-- CONNECT or NO CARRIER
X    TIMEOUT 2;		-- wait for text after "O"
X    IF MATCH "CONNECT" THEN QUIT;
X    ELSE IF MATCH "NO CARRIER" THEN 
X	goto nextNumber;	-- Try another number
X    END IF;
XEND LOOP;		-- Otherwise, try again
+FUNKY+STUFF+
echo '-rw-r--r--  1 gordon       1137 Nov 20 20:33 dial.scr    (as sent)'
chmod u=rw,g=r,o=r dial.scr
ls -l dial.scr
echo x - hangup.scr
sed 's/^X//' > hangup.scr <<'+FUNKY+STUFF+'
X----------------------------------------------------------------
X-- HANGUP.SCR: Script to disconnect Hayes SmartModem
X-- and exit from Tel.
X----------------------------------------------------------------
X
XENTER = "^M";
X
Xloop
X    wait 15;
X    type "+++";		-- Try to get modem's attention.
X    wait 15;		-- Should answer OK, or be ready for command.
X    type ENTER "AT Z" ENTER;	-- Try hanging up.
X    wait 5;		-- Wait for modem to hang up.
X    if match "OK" then exit; end if;
Xend loop;
X
Xtel "QUIT YES ";
X
X----------------------------------------------------------------
+FUNKY+STUFF+
echo '-rw-r--r--  1 gordon        571 Nov 20 20:33 hangup.scr    (as sent)'
chmod u=rw,g=r,o=r hangup.scr
ls -l hangup.scr
exit 0
