/*
** is-disk.c source file for 'disk' functions of IS
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include "is.h"
#define INBUFF 81

int is_disk(char *fun, char *ret_str)
{
   struct diskfree_t diskinfo;                 /* place to store disk info */
   char drivestr[2];                           /* place to store drive     */
   unsigned int drivenum;
   char *dbeg, *dend;                           /* drive begin             */
   char *dr = drivestr;
   long freespace, totalspace;

   /* extract drive from fun (if any) */
   if((dbeg = strchr(fun, '(')) != NULL)       /* if there's a left paren  */
   {
       if((dend = strrchr(fun, ')')) != NULL)  /* and a right paren        */
       {
           ++dbeg;                         /* copy what's inside to prompt */
           *dr++ = *dbeg;
           *dr = '\0';
       }
   }

   /* if no drive specified, use current drive */
   if(dr == drivestr)
       drivenum = 0;
   else
   {
       tolower((int) drivestr[0]);
       drivenum = (int) drivestr[0] - 'a' + 1;
   }

   /* get free space   */
   _dos_getdiskfree(drivenum, &diskinfo);
   freespace = diskinfo.avail_clusters * diskinfo.sectors_per_cluster;
   freespace *= diskinfo.bytes_per_sector;
   totalspace = diskinfo.total_clusters * diskinfo.sectors_per_cluster;
   totalspace *= diskinfo.bytes_per_sector;

   if(strncmp(fun, "diskfree", 8) == 0)
   {
       ltoa(freespace, ret_str, 10);
       return(OK);
   }
   else
   {
       if(strncmp(fun, "disksize", 8) == 0)
       {
           ltoa(totalspace, ret_str, 10);
           return(OK);
       }
       else
           return(BAD);
   }
}

