/*
** is-fun.c source module for function dispatcher for IS
*/

#include <stdio.h>
#include <string.h>
#include "is.h"

int is_fun(char *fun, char * *env, char *ret_str)
{
   /* external functions supported */
   extern int is_input(char *, char *);
   extern int is_sys(char *, char *);
   extern int is_file(char *, char *);
   extern int is_disk(char *, char *);

   int ret, i, j;          /* useful ints  */
   size_t n;
   char *lwrfun;           /* storage for lowercase function name  */

   /*
   ** determine which function is requested, can be one of the following:
   ** input[(prompt)] | sysdate | systime | filedate(d:\path\file.ext) |
   ** filetime(d:\path\file.ext) | filesize(d:\path\file.ext) |
   ** diskfree[(d:)] | disksize[(d:)]
   */

   lwrfun = strlwr(strdup(fun));
   if((strncmp(lwrfun, "input", 5)) == 0)      /* is it input or input()?  */
       ret = is_input(fun, ret_str);           /* if so, get user input    */
   else if((strncmp(lwrfun, "sys", 3)) == 0)   /* is it sysdate or systime */
       ret = is_sys(lwrfun, ret_str);          /* if so, get it            */
   else if((strncmp(lwrfun, "file", 4)) == 0)  /* is it filesize, date or  */
       ret = is_file(lwrfun, ret_str);         /* time, if so get it       */
   else if((strncmp(lwrfun, "disk", 4)) == 0)  /* is it diskfree or        */
       ret = is_disk(lwrfun, ret_str);         /* disksize, if so get it   */
   else
   {                                           /* otherwise . . . treat it */
       strcpy(ret_str, lwrfun);                /* as a literal string      */
       ret = OK;
   }
   return(ret);
}

