/*
** is-input.c source file for 'input' functions of IS
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "is.h"
#define INBUFF 81

int is_input(char *fun, char *ret_str)
{
   char buffer[INBUFF];                        /* place to store input     */
   static char prompt[INBUFF] = {"\0"};        /* place to store prompt    */
   char *pbeg = 0, *pend = 0;                  /* prompt begin, prompt end */
   char *pr = prompt;
   char *instring;

   /* extract prompt from fun (if any) */
   if((pbeg = strchr(fun, '(')) != NULL)       /* if there's a left paren  */
   {
       if((pend = strrchr(fun, ')')) != NULL)  /* and a right paren        */
       {
           ++pbeg;                         /* copy what's inside to prompt */
           --pend;
           while(pbeg <= pend)
               *pr++ = *pbeg++;
           *pr = '\0';
           printf("\n%s", prompt);                     /* and show prompt  */
       }
   }
   ret_str = gets(ret_str);
   if(ret_str == NULL)
       return(BAD);
   ret_str = strlwr(ret_str);
   return(OK);
}

