#ifndef BH_OBJECT_H
#define BH_OBJECT_H 1
#include <generic.h>
#ifdef implement
#undef implement /* blows up in Object.h if defined */
#endif
#ifdef declare
#undef declare /* ditto */
#endif
#include <OOPS/Object.hxx>


/*
    For now, I have not bothered to hack the original Object class -- however, be
    advised that most of its virtual functions remain unimplemented in my code.
    I am primarily using only the isA() and isKindOf() functions to provide
    assertion checking on type casting of base objects to subclass objects.

    Use 
	derived_class* foo = CAST(bar,derived_class); // bar is BHObject* or subclass
    to get assertion checking when DEBUGI is defined and a straight cast otherwise.

    I have defined BH_DEFINE_CLASS to eliminate the reader/writer junk from
    the original, so that this stuff does not have to be implemented in each
    class.
*/
extern Class class_BHObject;
class BHObject : public Object {
public:
    BHObject() {}
    virtual const Class* isA();
};


extern void OOPS_init();  // in OOPS library
inline void init_OOPS_if_needed() { if (!OOPSInitialized()) OOPS_init(); }
extern void set_OOPS_exceptions_to_abort();  
    // mine -- initializes all exceptions to abort


#define BH_DEFINE_CLASS(classname,basename,version,initor1,initor2)	\
Class name2(class_,classname) = Class( name2(class_,basename), "classname",	\
 version, sizeof(classname), 0, 0, initor1, initor2 ); \
const Class* classname::isA()	{ return &name2(class_,classname); }


#if defined(DEBUGI) || defined(DEBUG) || defined(DEBUGD)
inline Object* _check_pointer_type(Object* p, const Class& cl)
    { if (p) assertClass(*p, cl);  return p; }
#define CAST(ptr,type)  ((type*)_check_pointer_type(ptr,name2(class_,type)))
#else
#define CAST(ptr,type) ((type*)(ptr))
#endif
#endif



