/* Array.c.m4 -- template for implementations of generic array objects

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	September, 1985

Function:

m4 macro template for the .c files for arrays of the specified
fundamental type: char, int, short, long, unsigned, float, and double.
For example, to generate the implementation of an array of chars:

	m4 Array.c.m4 Arraychar.p >Arraychar.c

The type-specific part of the implementation is in the file
Arraychar.p, for example.

WARNING -- Make changes to the .p or .m4 files, not to the .c file
they generate.

Modification History:

*/


/* Arrayint.p -- type-specific functions for class Arrayint

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	September, 1985

Function:
	
Type-specific functions for class Arrayint, such as hash() and
printOn().  Generic functions are generated from the m4 template file
Array.c.m4.

WARNING -- Make changes to the .p or .m4 files, not to the .c file
they generate.

Modification History:

26-Feb-87	K. E. Gorlen

1.  Quote preprocessor commands for compatibility with 4.2BSD m4.

28-Oct-86	K. E. Gorlen

1.  Made generic by using m4 macros.

07-Oct-86	S. M. Orlow

1.  Adapted from Array.h and Arrayimp.h because the macros were
    defeating the preprocessor.
*/

#include "Arrayint.hxx"
#include "oopsconfig.hxx"
#include <libc.hxx>
#include "oopsIO.hxx"

#define	THIS	Arrayint
#define	BASE	Collection
DEFINE_CLASS(Arrayint,Collection,1,NULL,NULL);

static int intCmp(int* a, int* b)
{
	return *(unsigned int*)a - *(unsigned int*)b;
}

UNSIGNED THIS::hash()
{
        register UNSIGNED h = sz;
	register UNSIGNED i = sz;
	register UNSIGNED* vv = (UNSIGNED*)v;
	while (i--) h ^= *vv++;
	return h;
}

void THIS::printOn(ostream& strm)
{
	strm << "THIS::printOn() unimplemented\n";
}

THIS::THIS(istream& strm, THIS& where)
{
	this = &where;
	strm >> sz;
	v = new int[sz];
	for (register UNSIGNED i =0; i<sz; i++) 
	{
	    int _i; 
	    strm >> _i; 
	    v[i] = _i; 
	}
}

void THIS::storer(ostream& strm)
{
	Object::storer(strm);
	strm << sz << " ";
	for (register UNSIGNED i=0; i<sz; i++) 
	    strm << v[i] << " ";
}

Arrayint::Arrayint(fileDescTy& fd, Arrayint& where)
{
	this = &where;
	readBin(fd,sz);
	v = new int[sz];
	readBin(fd,v,sz);
}

void Arrayint::storer(fileDescTy& fd) 
{
	Object::storer(fd);
	storeBin(fd,sz);
	storeBin(fd,v,sz);
}

Arrayint::Arrayint(UNSIGNED size)
{
	sz = size;
	if (size<=0) AllocSizeErr();
	else v = new int[sz];
}

Arrayint::Arrayint(const Arrayint& a)
{
	register UNSIGNED i = a.sz;
	sz = i;
	v = new int[i];
	register int* vv = &v[0];
	register int* av = &a.v[0];
	while (i--) *vv++ = *av++;
}

void Arrayint::clearForReadFrom() {delete v;}

void Arrayint::operator=(const Arrayint& a)
{
	if (v != a.v) {
		delete v;
		v = new int[sz=a.sz];
		register UNSIGNED i = a.sz;
		register int* vv = &v[0];
		register int* av = &a.v[0];
		while (i--) *vv++ = *av++;
	}
}

bool Arrayint::operator==(const Arrayint& a)
{
	if (sz != a.sz) return NO;
	register UNSIGNED i = sz;
	register int* vv = &v[0];
	register int* av = &a.v[0];
	while (i--) if (*vv++ != *av++) return NO;
	return YES;
}

int& Arrayint::at(int i)
{
	return this->operator[](i);
}

UNSIGNED Arrayint::capacity()	{ return sz; }

bool Arrayint::isEqual(const Object& a)
{
	return a.isSpecies(class_Arrayint) && *this==*(Arrayint*)&a;
}

const Class* Arrayint::species()	{ return &class_Arrayint; }

void Arrayint::reSize(UNSIGNED newsz)
{
	if (newsz<=0) AllocSizeErr();
	int* newv = new int[newsz];
	register UNSIGNED i = (newsz<=sz) ? newsz:sz;
	register int* vp = &v[0];
	register int* np = &newv[0];
	while (i--) *np++ = *vp++;
	delete v;
	v = newv;
	sz = newsz;
}

void Arrayint::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	register int* av = &v[0];
	register UNSIGNED i = sz;
	v = new int[i];
	register int* vv = &v[0];
	while (i--) *vv++ = *av++;
}

UNSIGNED Arrayint::size()	{ return sz; }

void Arrayint::sort()
{
	qsort(v,sz,sizeof(int),intCmp);
}

extern const int OOPS_ALLOCSIZE;
extern const int OOPS_INDEXRANGE;

void Arrayint::AllocSizeErr()
{
	setOOPSerror(OOPS_ALLOCSIZE,DEFAULT,this,className());
}
void Arrayint::IndexRangeErr()
{
	setOOPSerror(OOPS_INDEXRANGE,DEFAULT,this,className());
}

