/* Arrayobid.c -- member functions of class Arrayobid

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	September, 1985

Function:
	
Member function definitions for class Arrayobid (Array of obid, or
Object*).  Objects of class Arrayobid are used in the implementations of
several other Collection classes such as: Bag, Dictionary, Set, and
OrderedCltn.  Note that the Arrayobid constructor initializes the array
with pointers to the nil object.

Modification History:

01-May-89	R. Edwards

1.  Fixed bug in reSize which did not initialize new space to nil

07-Oct-86	S. M. Orlow

1.  Changed invocation of qsort to be compatible with declaration.
     
06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions
*/

#include <libc.hxx>
#include "Arrayobid.hxx"
#include "oopsIO.hxx"

#define	THIS	Arrayobid
#define	BASE	Collection
DEFINE_CLASS(Arrayobid,Collection,1,NULL,NULL);

extern const int OOPS_ALLOCSIZE,OOPS_INDEXRANGE;

Arrayobid::Arrayobid(UNSIGNED size)
{
	sz = size;
	if (sz<=0) AllocSizeErr();
	else	{
		v = new obid[sz];
		register i = sz;
		register obid* vv = &v[0];
		while (i--) *vv++ = nil;
	}
}
	
Arrayobid::Arrayobid(const Arrayobid& a)
{
	register i = a.sz;
	sz = i;
	v = new obid[i];
	register obid* vv = &v[0];
	register obid* av = &a.v[0];
	while (i--) *vv++ = *av++;
}

void Arrayobid::clearForReadFrom() { delete v;}

void Arrayobid::operator=(const Arrayobid& a)
{
	if (v != a.v) {
		delete v;
		v = new obid[sz=a.sz];
		register i = a.sz;
		register obid* vv = &v[0];
		register obid* av = &a.v[0];
		while (i--) *vv++ = *av++;
	}
}

bool Arrayobid::operator==(const Arrayobid& a)
{
	if (sz != a.sz) return NO;
	else {
		register UNSIGNED i = sz;
		register obid* vv = &v[0];
		register obid* av = &a.v[0];
		while (i--) { if (!((*vv++)->isEqual(**av++))) return NO; }
	}
	return YES;
}

obid& Arrayobid::at(int i)	{ return this->operator[](i); }

UNSIGNED Arrayobid::capacity()	{ return sz; }
	
bool Arrayobid::isEqual(const Object& a)
{
	return a.isSpecies(class_Arrayobid) && *this==*(Arrayobid*)&a;
}

const Class* Arrayobid::species()	{ return &class_Arrayobid; }

void Arrayobid::reSize(UNSIGNED size)
{
	if (size<=0) AllocSizeErr();
	obid* nv = new obid[size];
	register i = (size<=sz)?size:sz;
	register obid* vp = &v[0];
	register obid* nvp = &nv[0];
	while (i--) *nvp++ = *vp++;
	for (i = sz; i < size; i++) *nvp++ = nil;
	delete v;
	v = nv;
	sz = size;
}

Collection& Arrayobid::addContentsTo(Collection& cltn)
{
	register obid* vp = &v[0];
	register UNSIGNED i = sz;
	while (i--) cltn.add(**vp++);
	return cltn;
}

obid Arrayobid::doNext(DoCltnPos& pos)
{
	if (pos.index < size()) return v[pos.index++];
	return 0;
}

void Arrayobid::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	register obid* av = &v[0];
	register i = sz;
	v = new obid[i];
	register obid* vv = &v[0];
	while (i--) *vv++ = (*av++)->deepCopy();
}

UNSIGNED Arrayobid::hash()
{
	register UNSIGNED h = sz;
	register UNSIGNED i = sz;
	register obid* vv = &v[0];
	while (i--) h^=(*vv++)->hash();
	return h;
}

void Arrayobid::printOn(ostream& strm)
{
	strm << className() << "[\n";
	for (register UNSIGNED i=0; i<sz; i++) {
		if (i>0) strm << "\n";
		v[i]->printOn(strm);
	}
	strm << "]\n";
}

Arrayobid::Arrayobid(istream& strm, Arrayobid& where)
{
	this = &where;
	strm >> sz;
	v = new obid[sz];
	for (register UNSIGNED i=0; i<sz; i++) v[i] = readFrom(strm);
}

void Arrayobid::storer(ostream& strm)
{
	Object::storer(strm);
	strm << sz;
	for (register UNSIGNED i=0; i<sz; i++) v[i]->storeOn(strm);
}

UNSIGNED Arrayobid::size()	{ return sz; }

static int compare_ob(obid* a, obid* b) { return (*a)->compare(**b); }

void Arrayobid::sort()
{
	qsort(&v[0],sz,sizeof(obid),compare_ob);
}

void Arrayobid::AllocSizeErr()
{
	setOOPSerror(OOPS_ALLOCSIZE,DEFAULT,this,className());
}

void Arrayobid::IndexRangeErr()
{
	setOOPSerror(OOPS_INDEXRANGE,DEFAULT,this,className());
}

Arrayobid::Arrayobid(fileDescTy& fd, Arrayobid& where)
{
	this = &where;
	readBin(fd,sz);
	v = new obid[sz];
	for (register UNSIGNED i=0; i<sz; i++ )
	   v[i] = readFrom(fd);
}

void Arrayobid::storer(fileDescTy& fd) 
{
	Object::storer(fd);
	storeBin(fd,sz);
	for (register UNSIGNED i=0; i<sz; i++) 
		v[i]->storeOn(fd);
}
