#ifndef HEAPH
#define HEAPH

/* Heap.hxx -- declarations for abstract heap          

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	C. J. Eppich
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/
#include "Collection.hxx"
#include "OrderedCltn.hxx"
#include "Arrayobid.hxx"

extern Class class_Heap;          

class Heap: public SeqCltn {
	int endIndex;
	Arrayobid contents;

	void bubbleUp(int);
	void bubbleUpMax(int);
	void bubbleUpMin(int);
	int child(int i)	{ return( (i << 1) + 1 ); }
	int descendents(int);
	void errEmpty(const char* fn);
	int grandchild(int i)	{ return( (child(i) << 1) + 1 ); }
	int largest(int,int);
	int level(int);
	int parent(int i)		{return( (i - 1) >> 1 );}
	obid removeAtIndex(int i);
	int smallest(int,int);
	void swap(int a,int b)    	{obid temp = contents[a];
					 contents[a] = contents[b]; 
					 contents[b] = temp;}
	void trickleDown(int);
	void trickleDownMax(int);
	void trickleDownMin(int);

public:
	Heap(int size=CLTN_DEFAULT_CAPACITY);
	Heap(const Heap&);
	Heap(const Arrayobid&);
	Heap(istream&,Heap&);
	Heap(fileDescTy&,Heap&);
	void operator=(const Heap&);
	bool operator==(const Heap&);
	bool operator!=(const Heap& a)    {  return !(*this==a);  }
	virtual obid add(const Object&);
	virtual Collection& addContentsTo(Collection&);
	virtual obid& at(int i);          // should not implement
	virtual void atAllPut(const Object& ob);  // should not implement
	unsigned capacity();
	virtual void deepenShallowCopy();
	virtual obid doNext(DoCltnPos&);
	virtual obid first();
	virtual unsigned hash();
	virtual int indexOf(const Object& ob);   // should not implement
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0);
		// should not implement
	virtual const Class* isA();
	virtual bool isEmpty();
	virtual bool isEqual(const Object&);
	virtual obid last();
	virtual void printOn(ostream& strm);
	virtual obid remove(const Object&);
	virtual obid removeFirst();
	virtual obid removeLast();
	virtual void reSize(int newSize);
	virtual unsigned size();
	OrderedCltn sort();
	virtual const Class* species();
};

#endif
