#ifndef INTEGERH
#define INTEGERH 

/* Integer.hxx -- declarations for Integer object

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Object.hxx"

extern Class class_Integer;

class Integer: public Object {
	int val;
	void parseInteger(istream& strm)	{ strm >> val; }
public:
	Integer(int v =0)		{ val = v; }
	Integer(istream&);
	Integer(fileDescTy&,Integer&);
	Integer(istream&,Integer&);
	int value()			{ return val; }
	int value(int newval)		{ return val = newval; }
	virtual int compare(const Object&);
	virtual obid	copy();			// { return shallowCopy(); }
	virtual void	deepenShallowCopy();	// {}
	virtual UNSIGNED hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object&);
	virtual void printOn(ostream& strm);
	virtual void scanFrom(istream& strm);
	virtual const Class* species();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
};

#endif
