/* Point_3d.c  -- implementation of X-Y-Z coordinates

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	August, 1985

Function:
	
A Point_3d represents an x-y-z coordinate triple. By convention,
Point_3d(0,0,0) is the top left corner of the display, with x increasing
to the right and y increasing to the bottom. The z co-ordinate is normally
not shown (i.e. the view on the screen is from above looking down).

Modification History:
3/15/88		N. B. Cohen

1.  Create 3 dimensional points

30-Oct-86	K. E. Gorlen

1.  Make member variables protected, define access functions.

06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions

29-Apr-86	K. E. Gorlen

1.  Implement copy() as shallowCopy() and deepenShallowCopy() as {}.

7-Jan-86	K. E. Gorlen

1.  Add Point_3d::species().

2.  Modify Point_3d::isEqual to use species().

*/

#include "Point_3d.hxx"
#include "oopsIO.hxx"

#define	THIS	Point_3d
#define	BASE	Object
DEFINE_CLASS(Point_3d,Object,1,NULL,NULL);

Point_3d Point_3d::max(Point_3d p)
{
	return Point_3d(MAX(xc,p.xc),MAX(yc,p.yc),MAX(zc,p.zc));
}

Point_3d Point_3d::min(Point_3d p)
{
	return Point_3d(MIN(xc,p.xc),MIN(yc,p.yc),MIN(zc,p.zc));
}

bool Point_3d::isEqual(const Object& p)
{
	return p.isSpecies(class_Point_3d) && *this==*(Point_3d*)&p;
}

const Class* Point_3d::species()	{ return &class_Point_3d; }

UNSIGNED Point_3d::hash()	{ return (int) xc^(int) yc^(int) zc; }

int Point_3d::compare(const Object& p)
{
	double t;
	assertArgSpecies(p,class_Point_3d,"compare");
	if ((t=zc-((Point_3d*)&p)->zc) != 0) return (int) t;
	else if ((t=yc-((Point_3d*)&p)->yc) != 0) return (int) t;
	else return ((int) (xc-((Point_3d*)&p)->xc));
}

obid Point_3d::copy()		{ return shallowCopy(); }

void Point_3d::deepenShallowCopy()	{}

void Point_3d::printOn(ostream& strm)
{
	strm << "(" << xc << " @ " << yc << " @ " << zc << ")";
}

Point_3d::Point_3d(istream& strm, Point_3d& where)
{
	this = &where;
	strm >> xc >> yc >> zc;
}

void Point_3d::storer(ostream& strm)
{
	BASE::storer(strm);
	strm << xc << " " << yc << " " << zc << " ";
}

Point_3d::Point_3d(fileDescTy& fd, Point_3d& where)
{
	this = &where;
	READ_OBJECT_AS_BINARY(fd);
}

void Point_3d::storer(fileDescTy& fd) 
{
	BASE::storer(fd);
	STORE_OBJECT_AS_BINARY(fd);
}

//extern double sqrt(double);

double Point_3d::dist(Point_3d &p){
	double dist, dx, dy, dz;

	dx = p.xc - this->xc;
	dy = p.yc - this->yc;
	dz = p.zc - this->zc;

	dist = (dx * dx) + (dy * dy) + (dz * dz);
	return(sqrt(dist));
}	/* end distance */
