#ifndef RECTANGLEH
#define RECTANGLEH 

/* Rectangle.hxx -- declarations for class Rectangle

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

28-Feb-87	K. E. Gorlen

1.  Eliminate use of MAX_X_COORD and MAX_Y_COORD.

30-Oct-86	K. E. Gorlen

1.  Make member variables private, add access functions.

*/

#include "Object.hxx"
#include "Point.hxx"
#include <math.h>

extern Class class_Rectangle;

class OrderedCltn;

class Rectangle: public Object {
	Point tl;		// top left corner (origin)
	Point br;		// bottom right corner (corner)
public:
	Rectangle(int left=0, int top=0, int height=0, int width=0);
	Rectangle(Point, Point);
	Rectangle(fileDescTy&, Rectangle&);
	Rectangle(istream&, Rectangle&);
	Point	origin()		{ return tl; }
	Point	origin(const Point& p)	{ return tl = p; }
	Point	corner()		{ return br; }
	Point	corner(const Point& p)	{ return br = p; }
	Point	topLeft()	{ return tl; }
	Point	topCenter()	{ return Point((br.x()+tl.x())/2,tl.y()); }
	Point	topRight()	{ return Point(br.x(),tl.y()); }
	Point	rightCenter()	{ return Point(br.x(),(br.y()+tl.y())/2); }
	Point	bottomRight()	{ return br; }
	Point	bottomCenter()	{ return Point((br.x()+tl.x())/2,br.y()); }
	Point	bottomLeft()	{ return Point(tl.x(),br.y()); }
	Point	leftCenter()	{ return Point(tl.x(),(br.y()+tl.y())/2); }
	Point	center()	{ return Point((br.x()+tl.x())/2,(br.y()+tl.y())/2); }
//	This is original code - bug in center calculations (subtract instead
//		of adding co-ordinates before dividing by 2
//	Point	topLeft()	{ return tl; }
//	Point	topCenter()	{ return Point((br.x()-tl.x())/2,tl.y()); }
//	Point	topRight()	{ return Point(br.x(),tl.y()); }
//	Point	rightCenter()	{ return Point(br.x(),(br.y()-tl.y())/2); }
//	Point	bottomRight()	{ return br; }
//	Point	bottomCenter()	{ return Point((br.x()-tl.x())/2,br.y()); }
//	Point	bottomLeft()	{ return Point(tl.x(),br.y()); }
//	Point	leftCenter()	{ return Point(tl.x(),(br.y()-tl.y())/2); }
//	Point	center()	{ return Point((br.x()-tl.x())/2,(br.y()-tl.y())/2); }
	Point	extent()	{ return Point(br.x()-tl.x(),br.y()-tl.y()); }
	int	area()		{ return (br.x()-tl.x())*(br.y()-tl.y()); }
	int	width()		{ return br.x()-tl.x(); }
	int	height()	{ return br.y()-tl.y(); }
	bool	operator==(const Rectangle&);
	bool	operator!=(const Rectangle&);
	Rectangle operator&&(const Rectangle&);	// intersection 
	Rectangle operator||(const Rectangle&);	// union 
	void	operator+=(const Point&);	// translate 
	void	operator-=(const Point&);
	OrderedCltn& areasOutside(const Rectangle&);
	bool	contains(const Point&);
	bool	contains(const Rectangle&);
	bool	intersects(const Rectangle&);
	void 	moveTo(const Point&);
	virtual obid	copy();			// { return shallowCopy(); }
	virtual void	deepenShallowCopy();	// {}
	virtual UNSIGNED hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object&);	// equality test 
	virtual void printOn(ostream& strm);
	virtual const Class* species();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
};

#endif
