/* RegExp.c -- implementation of Basic Regular Expressions */
#include "Object.hxx"
#include "String.hxx"
#include "RegExp.hxx"

#define	THIS	RegExp
#define	BASE	Object

DEFINE_CLASS(RegExp,Object,1,NULL,NULL);

extern char *re_comp(const char *);
extern int re_exec(const char *);

static String previousPAT("");

bool
RegExp::Match(const String& word) {
    if (PATTERN != previousPAT) {
	char *errStr = re_comp(PATTERN);
	if (errStr != (char*)0) {
	    cerr << "RegExp::Match FAIL on re_comp : "<< errStr << "\n";
	    return NO; // compile failed
        }
	previousPAT = PATTERN;
    }
    return (re_exec(word) == 1) ? YES : NO;
}

RegExp::RegExp(const RegExp& d) {
    PATTERN = d.PATTERN;
}

RegExp::RegExp(istream& strm, RegExp& where) {
    this = &where;
    readFrom(strm, "String", PATTERN);
}

RegExp::RegExp(fileDescTy& fd, RegExp& where) {
    this = &where;
    readFrom(fd, "String", PATTERN);
}

void
RegExp::operator=(const RegExp& d) {
    PATTERN = d.PATTERN;
}

bool
RegExp::operator==(const RegExp& d) {
    return (PATTERN == d.PATTERN);
}

UNSIGNED
RegExp::hash() {
    return PATTERN.hash();
}

bool
RegExp::isEqual(const Object &Ob) {
    return Ob.isSpecies(class_RegExp) && *this == *(RegExp*)&Ob;
}

void
RegExp::storer(ostream& strm) {
    BASE::storer(strm);
    PATTERN.storeOn(strm);
}

void
RegExp::storer(fileDescTy& fd) {
    BASE::storer(fd);
    PATTERN.storeOn(fd);
}

void
RegExp::deepenShallowCopy() {
    PATTERN.deepenShallowCopy();
}

