#ifndef SETH
#define SETH

/* Set.hxx -- declarations for hash tables

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Collection.hxx"
#include "Arrayobid.hxx"

extern Class class_Set;
class Dictionary;
class IdentDict;

class Set: public Collection {
	UNSIGNED count;		// number of objects in set 
	UNSIGNED nbits;		// log base 2 of contents.capacity() 
protected:
	UNSIGNED mask;		// contents.capacity()-1 
	Arrayobid contents;	// array of set objects 
	UNSIGNED setCapacity(unsigned);	// compute set allocation size 
	int h(unsigned long);	// convert hash key into contents index 
	obid findObjectWithKey(const Object&);
	virtual int findIndexOf(const Object&);
public:
	Set(UNSIGNED size =CLTN_DEFAULT_CAPACITY);
	Set(const Set&);
	Set(fileDescTy&,Set&);
	Set(istream&,Set&);
	void operator=(const Set&);
	bool operator==(const Set&);
	bool operator!=(const Set& a)		{ return !(*this==a); }
	Set operator&(const Set&);		// intersection 
	Set operator|(const Set&);		// union 
	Set operator-(const Set&);		// difference 
	virtual	obid	add(const Object&);
	virtual Collection& addContentsTo(Collection&);
	virtual UNSIGNED capacity();
	virtual void	deepenShallowCopy();
	virtual obid	doNext(DoCltnPos&);
	virtual UNSIGNED hash();
	virtual const Class*	isA();
	virtual bool	isEqual(const Object&);
	virtual UNSIGNED occurrencesOf(const Object&);
	virtual void	printOn(ostream& strm);
	virtual void	reSize(UNSIGNED);
	virtual obid	remove(const Object&);
	virtual UNSIGNED size();
	virtual const Class*	species();
};

#endif
