#ifndef SORTEDCLTNH
#define SORTEDCLTNH

/* SortedCltn.hxx -- declarations for sorted collection

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "OrderedCltn.hxx"

extern Class class_SortedCltn;

class SortedCltn : public OrderedCltn {
public:
	SortedCltn(UNSIGNED size =CLTN_DEFAULT_CAPACITY);
	SortedCltn(const SortedCltn&);
	SortedCltn(fileDescTy&,SortedCltn&);
	SortedCltn(istream&,SortedCltn&);
	bool operator!=(const SortedCltn& a)	{ return !(*this==a); }
	void operator=(const SortedCltn&);
	bool operator==(const SortedCltn&);
	virtual obid add(const Object&);
	virtual obid addAfter(const Object& ob, const Object& newob);
	virtual obid addAllLast(const OrderedCltn&);
	virtual obid addBefore(const Object& ob, const Object& newob);
	virtual obid addLast(const Object& ob);
	virtual void atAllPut(const Object& ob);
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0);
	virtual const Class* isA();
	virtual SeqCltn operator&(const SeqCltn& cltn);
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);
	virtual void sort();
};

#endif
