#ifndef STRINGH
#define STRINGH

/* String.hxx -- declarations for character strings

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Arraychar.hxx"
#include <string.h>

typedef const char* constCharPtTy;
class String;
extern Class class_String;

class SubString {
	char* sp;	// substring pointer 
	UNSIGNED sl;		// substring length 
	SubString(const String& s, unsigned pos, unsigned lgt);
	friend String;
public:
	SubString(const SubString& from)	{ strncpy(sp,from.sp,sl); }
	void operator=(const SubString& from)	{ strncpy(sp,from.sp,sl); }
	void operator=(const String& from);
	bool operator<(const String& s);
	bool operator>(const String& s);
	bool operator<=(const String& s);
	bool operator>=(const String& s);
	bool operator==(const String& s);
	bool operator!=(const String& s);
	String operator&(const String& s);
};

class String : public Arraychar {
	String(const char* cs, unsigned lgt) : (lgt+1) {
		strncpy(v,cs,lgt);
	}
	void errSubStr(unsigned pos, unsigned lgt);
	friend SubString;
public:
	String() : (1) { *v = '\0'; }
	String(const char* cs) : (strlen(cs)+1) {
		strcpy(v,cs);
	}
	String(UNSIGNED l, char c =' ');
	String(const String& s) : (s)	{}
	String(const SubString& ss) : (ss.sl+1) {
		strncpy(v,ss.sp,ss.sl);
		v[ss.sl] = 0;
	}
	String(fileDescTy&,String&);
	String(istream&,String&);
	operator constCharPtTy()	{ return v; }
	SubString operator()(unsigned pos, unsigned lgt);
	char& operator[](unsigned pos) {
		if (pos >= sz-1) IndexRangeErr();
		return v[pos];
    	}
	void operator=(const String& s)	{ this->Arraychar::operator=(s); }
	void operator=(const char* s)	{
	    this->Arraychar::reSize(strlen(s)+1);
	    strcpy(v, s);
	}
	void operator=(const SubString& ss)	{
		String s(ss);
		this->Arraychar::operator=(s);
	}
	bool operator<(const String& s)		{ return strcmp(v, s.v) < 0; }
	bool operator>(const String& s)		{ return strcmp(v, s.v) > 0; }
	bool operator<=(const String& s)	{ return strcmp(v, s.v) <= 0; }
	bool operator>=(const String& s)	{ return strcmp(v, s.v) >= 0; }
	bool operator==(const String& s)	{ return strcmp(v, s.v) == 0; }
	bool operator!=(const String& s)	{ return strcmp(v, s.v) != 0; }
	String operator&(const String& s) {
		String t(v, sz+s.sz-2);
		strcpy(&(t.v[sz-1]), s.v);
		return t;
	}
	void operator&=(const String& s) {
		UNSIGNED oldSize = sz-1;
		reSize(s.sz-1+oldSize+1);
		strcpy(&v[oldSize],s.v);
	}
	UNSIGNED length() { return sz-1; }
	UNSIGNED strchr(char c) {
	 // returns 1st position of char in String or -1
	    char *a = ::strchr(v, c);
	    return a ? (UNSIGNED)(a - v) : -1;
	}
	UNSIGNED strrchr(char c) {
	 // returns 1st position of char in String or -1
	    char *a = ::strrchr(v, c);
	    return a ? (UNSIGNED)(a - v) : -1;
	}
	void toAscii();
	void toLower();
	void toUpper();
	virtual int compare(const Object& ob);
	virtual const Class* isA();
	virtual void printOn(ostream& strm);
	virtual void scanFrom(istream& strm);
	virtual UNSIGNED size();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
};

inline SubString::SubString(const String& s, unsigned pos, unsigned lgt) { 
	sp = &s[pos];
	if (pos+lgt >= s.sz) s.errSubStr(pos,lgt);
	sl = lgt;
}
	
inline void SubString::operator=(const String& from)	{ strncpy(sp,from.v,sl); }

inline bool SubString::operator<(const String& s)	{ return strncmp(sp, s.v, sl) < 0; }
inline bool SubString::operator>(const String& s)	{ return strncmp(sp, s.v, sl) > 0; }
inline bool SubString::operator<=(const String& s)	{ return strncmp(sp, s.v, sl) <= 0; }
inline bool SubString::operator>=(const String& s)	{ return strncmp(sp, s.v, sl) >= 0; }
inline bool SubString::operator==(const String& s)	{ return strncmp(sp, s.v, sl) == 0; }
inline bool SubString::operator!=(const String& s)	{ return strncmp(sp, s.v, sl) != 0; }
	
/*inline*/ static SubString String::operator()(unsigned pos, unsigned lgt)
{
	return SubString(*this, pos, lgt);
}
	
inline String SubString::operator&(const String& s) {
	String t(sp, sl+s.sz-1);
	strcpy(&(t.v[sl]), s.v);
	return t;
}
	
#endif
